/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.c.struct.CInterfaceLocationIdentity;
import com.oracle.svm.core.graal.code.amd64.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.nodes.CInterfaceReadNode;
import com.oracle.svm.core.graal.nodes.CInterfaceWriteNode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CInterfaceError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointJavaCallStubMethod;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.word.LocationIdentity;

public class CInterfaceInvocationPlugin
implements NodePlugin {
    private final WordTypes wordTypes;
    private final NativeLibraries nativeLibs;
    private final ResolvedJavaType functionPointerType;

    public CInterfaceInvocationPlugin(MetaAccessProvider metaAccess, WordTypes wordTypes, NativeLibraries nativeLibs) {
        this.wordTypes = wordTypes;
        this.nativeLibs = nativeLibs;
        this.functionPointerType = metaAccess.lookupJavaType(CFunctionPointer.class);
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        ElementInfo methodInfo = this.nativeLibs.findElementInfo(method);
        if (methodInfo instanceof AccessorInfo) {
            ElementInfo parentInfo = methodInfo.getParent();
            if (parentInfo instanceof StructFieldInfo) {
                int offset = ((StructFieldInfo)parentInfo).getOffsetInfo().getProperty();
                if (((AccessorInfo)methodInfo).getAccessorKind() == AccessorInfo.AccessorKind.OFFSET) {
                    return this.replaceOffsetOf(b, method, args, (AccessorInfo)methodInfo, offset);
                }
                return this.replaceAccessor(b, method, args, (AccessorInfo)methodInfo, offset);
            }
            if (parentInfo instanceof StructBitfieldInfo) {
                return this.replaceBitfieldAccessor(b, method, args, (StructBitfieldInfo)parentInfo, (AccessorInfo)methodInfo);
            }
            if (parentInfo instanceof StructInfo || parentInfo instanceof PointerToInfo) {
                return this.replaceAccessor(b, method, args, (AccessorInfo)methodInfo, 0);
            }
            throw VMError.shouldNotReachHere();
        }
        if (methodInfo instanceof ConstantInfo) {
            return this.replaceConstant(b, method, (ConstantInfo)methodInfo);
        }
        if (method.getAnnotation(InvokeCFunctionPointer.class) != null) {
            return this.replaceFunctionPointerInvoke(b, method, args, SubstrateCallingConventionType.NativeCall);
        }
        if (method.getAnnotation(InvokeJavaFunctionPointer.class) != null) {
            return this.replaceFunctionPointerInvoke(b, method, args, SubstrateCallingConventionType.JavaCall);
        }
        if (method.getAnnotation(CEntryPoint.class) != null) {
            AnalysisMethod aMethod = (AnalysisMethod)(method instanceof HostedMethod ? ((HostedMethod)method).getWrapped() : method);
            assert (!(aMethod.getWrapped() instanceof CEntryPointJavaCallStubMethod)) : "Call stub should never have a @CEntryPoint annotation";
            AnalysisMethod stub = CEntryPointCallStubSupport.singleton().registerJavaStubForMethod(aMethod);
            if (method instanceof HostedMethod) {
                HostedMetaAccess hMetaAccess = (HostedMetaAccess)b.getMetaAccess();
                stub = hMetaAccess.getUniverse().lookup((JavaMethod)stub);
            }
            assert (!b.getMethod().equals(stub)) : "Plugin should not be called for the invoke in the stub itself";
            b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)stub, args, false);
            return true;
        }
        return false;
    }

    private boolean replaceOffsetOf(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, AccessorInfo accessorInfo, int displacement) {
        assert (args.length == accessorInfo.parameterCount(!method.isStatic()));
        JavaKind kind = this.wordTypes.asKind(b.getInvokeReturnType());
        b.addPush(CInterfaceInvocationPlugin.pushKind(method), (ValueNode)ConstantNode.forIntegerKind((JavaKind)kind, (long)displacement, (StructuredGraph)b.getGraph()));
        return true;
    }

    private boolean replaceAccessor(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, AccessorInfo accessorInfo, int displacement) {
        StructuredGraph graph = b.getGraph();
        SizableInfo sizableInfo = (SizableInfo)accessorInfo.getParent();
        int elementSize = sizableInfo.getSizeInfo().getProperty();
        boolean isUnsigned = sizableInfo.isUnsigned();
        assert (args.length == accessorInfo.parameterCount(true));
        ValueNode base = args[accessorInfo.baseParameterNumber(true)];
        switch (accessorInfo.getAccessorKind()) {
            case ADDRESS: {
                ValueNode address = CInterfaceInvocationPlugin.makeAddress(graph, args, accessorInfo, base, displacement, elementSize);
                b.addPush(CInterfaceInvocationPlugin.pushKind(method), address);
                return true;
            }
            case GETTER: {
                JavaKind resultKind = this.wordTypes.asKind(b.getInvokeReturnType());
                JavaKind readKind = CInterfaceInvocationPlugin.kindFromSize(elementSize, resultKind);
                if (readKind == JavaKind.Object) {
                    assert (resultKind == JavaKind.Object);
                } else if (readKind.getBitCount() > resultKind.getBitCount() && !readKind.isNumericFloat() && resultKind != JavaKind.Boolean) {
                    readKind = resultKind;
                }
                ValueNode address = CInterfaceInvocationPlugin.makeAddress(graph, args, accessorInfo, base, displacement, elementSize);
                LocationIdentity locationIdentity = CInterfaceInvocationPlugin.makeLocationIdentity(b, method, args, accessorInfo);
                Object stamp = readKind == JavaKind.Object ? b.getInvokeReturnStamp(null).getTrustedStamp() : (readKind == JavaKind.Float || readKind == JavaKind.Double ? StampFactory.forKind((JavaKind)readKind) : StampFactory.forInteger((int)readKind.getBitCount()));
                ValueNode read = CInterfaceInvocationPlugin.readOp(b, address, locationIdentity, stamp, accessorInfo);
                ValueNode adapted = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, read, readKind, resultKind == JavaKind.Boolean ? resultKind : resultKind.getStackKind(), isUnsigned);
                b.push(CInterfaceInvocationPlugin.pushKind(method), adapted);
                return true;
            }
            case SETTER: {
                ValueNode value = args[accessorInfo.valueParameterNumber(true)];
                JavaKind valueKind = value.getStackKind();
                JavaKind writeKind = CInterfaceInvocationPlugin.kindFromSize(elementSize, valueKind);
                ValueNode address = CInterfaceInvocationPlugin.makeAddress(graph, args, accessorInfo, base, displacement, elementSize);
                LocationIdentity locationIdentity = CInterfaceInvocationPlugin.makeLocationIdentity(b, method, args, accessorInfo);
                ValueNode adaptedValue = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, value, valueKind, writeKind, isUnsigned);
                CInterfaceInvocationPlugin.writeOp(b, address, locationIdentity, adaptedValue, accessorInfo);
                return true;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean replaceBitfieldAccessor(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, StructBitfieldInfo bitfieldInfo, AccessorInfo accessorInfo) {
        int byteOffset = bitfieldInfo.getByteOffsetInfo().getProperty();
        int startBit = bitfieldInfo.getStartBitInfo().getProperty();
        int endBit = bitfieldInfo.getEndBitInfo().getProperty();
        boolean isUnsigned = bitfieldInfo.isUnsigned();
        assert (byteOffset >= 0 && byteOffset < ((SizableInfo)bitfieldInfo.getParent()).getSizeInfo().getProperty());
        assert (startBit >= 0 && startBit < 8);
        assert (endBit >= startBit && endBit < 64);
        JavaKind memoryKind = endBit < 8 ? JavaKind.Byte : (endBit < 16 ? JavaKind.Short : (endBit < 32 ? JavaKind.Int : JavaKind.Long));
        int numBytes = memoryKind.getByteCount();
        int alignmentCorrection = byteOffset % numBytes;
        if (alignmentCorrection > 0 && endBit + alignmentCorrection * 8 < numBytes * 8) {
            byteOffset -= alignmentCorrection;
            startBit += alignmentCorrection * 8;
            endBit += alignmentCorrection * 8;
        }
        assert (byteOffset >= 0 && byteOffset < ((SizableInfo)bitfieldInfo.getParent()).getSizeInfo().getProperty());
        assert (startBit >= 0 && startBit < numBytes * 8);
        assert (endBit >= startBit && endBit < numBytes * 8);
        int numBits = endBit - startBit + 1;
        assert (numBits > 0 && numBits <= numBytes * 8);
        JavaKind computeKind = memoryKind.getStackKind();
        Stamp computeStamp = StampFactory.forKind((JavaKind)computeKind);
        int computeBits = computeKind.getBitCount();
        assert (startBit >= 0 && startBit < computeBits);
        assert (endBit >= startBit && endBit < computeBits);
        assert (computeBits >= numBits);
        assert (args.length == accessorInfo.parameterCount(true));
        ValueNode base = args[accessorInfo.baseParameterNumber(true)];
        StructuredGraph graph = b.getGraph();
        ValueNode address = CInterfaceInvocationPlugin.makeAddress(graph, args, accessorInfo, base, byteOffset, -1);
        LocationIdentity locationIdentity = CInterfaceInvocationPlugin.makeLocationIdentity(b, method, args, accessorInfo);
        IntegerStamp stamp = StampFactory.forInteger((int)memoryKind.getBitCount());
        ValueNode cur = CInterfaceInvocationPlugin.readOp(b, address, locationIdentity, (Stamp)stamp, accessorInfo);
        cur = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, cur, memoryKind, computeKind, true);
        switch (accessorInfo.getAccessorKind()) {
            case GETTER: {
                if (isUnsigned) {
                    cur = (ValueNode)graph.unique((Node)new RightShiftNode(cur, (ValueNode)ConstantNode.forInt((int)startBit, (StructuredGraph)graph)));
                    cur = (ValueNode)graph.unique((Node)new AndNode(cur, (ValueNode)ConstantNode.forIntegerStamp((Stamp)computeStamp, (long)((1L << numBits) - 1L), (StructuredGraph)graph)));
                } else {
                    cur = (ValueNode)graph.unique((Node)new LeftShiftNode(cur, (ValueNode)ConstantNode.forInt((int)(computeBits - endBit - 1), (StructuredGraph)graph)));
                    cur = (ValueNode)graph.unique((Node)new RightShiftNode(cur, (ValueNode)ConstantNode.forInt((int)(computeBits - numBits), (StructuredGraph)graph)));
                }
                JavaKind resultKind = this.wordTypes.asKind(b.getInvokeReturnType());
                b.push(CInterfaceInvocationPlugin.pushKind(method), CInterfaceInvocationPlugin.adaptPrimitiveType(graph, cur, computeKind, resultKind == JavaKind.Boolean ? resultKind : resultKind.getStackKind(), isUnsigned));
                return true;
            }
            case SETTER: {
                long mask = (1L << numBits) - 1L << startBit ^ 0xFFFFFFFFFFFFFFFFL;
                cur = (ValueNode)graph.unique((Node)new AndNode(cur, (ValueNode)ConstantNode.forIntegerStamp((Stamp)computeStamp, (long)mask, (StructuredGraph)graph)));
                ValueNode value = args[accessorInfo.valueParameterNumber(true)];
                value = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, value, value.getStackKind(), computeKind, isUnsigned);
                value = (ValueNode)graph.unique((Node)new AndNode(value, (ValueNode)ConstantNode.forIntegerStamp((Stamp)computeStamp, (long)((1L << numBits) - 1L), (StructuredGraph)graph)));
                value = (ValueNode)graph.unique((Node)new LeftShiftNode(value, (ValueNode)ConstantNode.forInt((int)startBit, (StructuredGraph)graph)));
                cur = (ValueNode)graph.unique((Node)new OrNode(cur, value));
                cur = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, cur, computeKind, memoryKind, true);
                CInterfaceInvocationPlugin.writeOp(b, address, locationIdentity, cur, accessorInfo);
                return true;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static ValueNode readOp(GraphBuilderContext b, ValueNode address, LocationIdentity locationIdentity, Stamp stamp, AccessorInfo accessorInfo) {
        assert (address.getStackKind() == FrameAccess.getWordKind());
        CInterfaceReadNode read = (CInterfaceReadNode)b.add((ValueNode)new CInterfaceReadNode((AddressNode)b.add((ValueNode)OffsetAddressNode.create((ValueNode)address)), locationIdentity, stamp, HeapAccess.BarrierType.NONE, CInterfaceInvocationPlugin.accessName(accessorInfo)));
        read.setForceFixed(true);
        return read;
    }

    private static void writeOp(GraphBuilderContext b, ValueNode address, LocationIdentity locationIdentity, ValueNode value, AccessorInfo accessorInfo) {
        b.add((ValueNode)new CInterfaceWriteNode((AddressNode)b.add((ValueNode)OffsetAddressNode.create((ValueNode)address)), locationIdentity, value, HeapAccess.BarrierType.NONE, CInterfaceInvocationPlugin.accessName(accessorInfo)));
    }

    private static String accessName(AccessorInfo accessorInfo) {
        if (accessorInfo.getParent() instanceof StructFieldInfo) {
            return accessorInfo.getParent().getParent().getName() + "." + accessorInfo.getParent().getName();
        }
        return accessorInfo.getParent().getName() + "*";
    }

    private static ValueNode makeAddress(StructuredGraph graph, ValueNode[] args, AccessorInfo accessorInfo, ValueNode base, int displacement, int indexScaling) {
        ConstantNode offset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)displacement, (StructuredGraph)graph);
        if (accessorInfo.isIndexed()) {
            ValueNode index = args[accessorInfo.indexParameterNumber(true)];
            assert (index.getStackKind().isPrimitive());
            ValueNode wordIndex = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, index, index.getStackKind(), FrameAccess.getWordKind(), false);
            ValueNode scaledIndex = (ValueNode)graph.unique((Node)new MulNode(wordIndex, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)indexScaling, (StructuredGraph)graph)));
            offset = (ValueNode)graph.unique((Node)new AddNode(scaledIndex, (ValueNode)offset));
        }
        assert (base.getStackKind() == FrameAccess.getWordKind());
        return (ValueNode)graph.unique((Node)new AddNode(base, (ValueNode)offset));
    }

    private static LocationIdentity makeLocationIdentity(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, AccessorInfo accessorInfo) {
        LocationIdentity locationIdentity;
        if (accessorInfo.hasLocationIdentityParameter()) {
            ValueNode locationIdentityNode = args[accessorInfo.locationIdentityParameterNumber(true)];
            if (!locationIdentityNode.isConstant()) {
                throw UserError.abort(new CInterfaceError("locationIdentity is not a compile time constant for call to " + method.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()), method).getMessage());
            }
            locationIdentity = (LocationIdentity)SubstrateObjectConstant.asObject(locationIdentityNode.asConstant());
        } else if (accessorInfo.hasUniqueLocationIdentity()) {
            StructFieldInfo fieldInfo = (StructFieldInfo)accessorInfo.getParent();
            assert (fieldInfo.getLocationIdentity() != null);
            locationIdentity = fieldInfo.getLocationIdentity();
        } else {
            locationIdentity = CInterfaceLocationIdentity.DEFAULT_LOCATION_IDENTITY;
        }
        return locationIdentity;
    }

    public static ValueNode adaptPrimitiveType(StructuredGraph graph, ValueNode value, JavaKind fromKind, JavaKind toKind, boolean isUnsigned) {
        int toBits;
        if (fromKind == toKind) {
            return value;
        }
        assert (fromKind.isNumericFloat() == toKind.isNumericFloat());
        int fromBits = fromKind.getBitCount();
        if (fromBits == (toBits = toKind.getBitCount())) {
            return value;
        }
        if (fromKind.isNumericFloat()) {
            FloatConvert op;
            if (fromKind == JavaKind.Float && toKind == JavaKind.Double) {
                op = FloatConvert.F2D;
            } else if (fromKind == JavaKind.Double && toKind == JavaKind.Float) {
                op = FloatConvert.D2F;
            } else {
                throw VMError.shouldNotReachHere();
            }
            return (ValueNode)graph.unique((Node)new FloatConvertNode(op, value));
        }
        if (toKind == JavaKind.Boolean) {
            JavaKind computeKind = fromKind == JavaKind.Long ? JavaKind.Long : JavaKind.Int;
            LogicNode comparison = (LogicNode)graph.unique((Node)new IntegerEqualsNode(CInterfaceInvocationPlugin.adaptPrimitiveType(graph, value, fromKind, computeKind, true), (ValueNode)ConstantNode.forIntegerKind((JavaKind)computeKind, (long)0L, (StructuredGraph)graph)));
            return (ValueNode)graph.unique((Node)new ConditionalNode(comparison, (ValueNode)ConstantNode.forBoolean((boolean)false, (StructuredGraph)graph), (ValueNode)ConstantNode.forBoolean((boolean)true, (StructuredGraph)graph)));
        }
        if (fromBits > toBits) {
            return (ValueNode)graph.unique((Node)new NarrowNode(value, toBits));
        }
        if (isUnsigned) {
            return (ValueNode)graph.unique((Node)new ZeroExtendNode(value, toBits));
        }
        return (ValueNode)graph.unique((Node)new SignExtendNode(value, toBits));
    }

    private static JavaKind kindFromSize(int sizeInBytes, JavaKind matchingKind) {
        if (matchingKind == JavaKind.Object || sizeInBytes * 8 == matchingKind.getBitCount()) {
            return matchingKind;
        }
        if (matchingKind == JavaKind.Float || matchingKind == JavaKind.Double) {
            switch (sizeInBytes) {
                case 4: {
                    return JavaKind.Float;
                }
                case 8: {
                    return JavaKind.Double;
                }
            }
        } else {
            switch (sizeInBytes) {
                case 1: {
                    return JavaKind.Byte;
                }
                case 2: {
                    return JavaKind.Short;
                }
                case 4: {
                    return JavaKind.Int;
                }
                case 8: {
                    return JavaKind.Long;
                }
            }
        }
        throw VMError.shouldNotReachHere("Unsupported size: " + sizeInBytes);
    }

    private boolean replaceConstant(GraphBuilderContext b, ResolvedJavaMethod method, ConstantInfo constantInfo) {
        ConstantNode valueNode;
        Object value = constantInfo.getValueInfo().getProperty();
        JavaKind kind = this.wordTypes.asKind(b.getInvokeReturnType());
        switch (constantInfo.getKind()) {
            case INTEGER: 
            case POINTER: {
                if (method.getSignature().getReturnKind() == JavaKind.Boolean) {
                    valueNode = ConstantNode.forBoolean(((Long)value != 0L ? 1 : 0) != 0, (StructuredGraph)b.getGraph());
                    break;
                }
                valueNode = ConstantNode.forIntegerKind((JavaKind)kind, (long)((Long)value), (StructuredGraph)b.getGraph());
                break;
            }
            case FLOAT: {
                valueNode = ConstantNode.forFloatingKind((JavaKind)kind, (double)((Double)value), (StructuredGraph)b.getGraph());
                break;
            }
            case STRING: 
            case BYTEARRAY: {
                valueNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(value), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("Unexpected constant kind " + constantInfo);
            }
        }
        b.push(CInterfaceInvocationPlugin.pushKind(method), (ValueNode)valueNode);
        return true;
    }

    private boolean replaceFunctionPointerInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, CallingConvention.Type callType) {
        if (!this.functionPointerType.isAssignableFrom(method.getDeclaringClass())) {
            throw UserError.abort(new CInterfaceError("function pointer invocation method " + method.format("%H.%n(%p)") + " must be in a type that extends " + CFunctionPointer.class.getSimpleName(), method).getMessage());
        }
        assert (b.getInvokeKind() == CallTargetNode.InvokeKind.Interface);
        JavaType[] parameterTypes = method.getSignature().toParameterTypes(null);
        if (callType == SubstrateCallingConventionType.NativeCall) {
            Predicate<JavaType> isValid = t -> t.getJavaKind().isPrimitive() || this.wordTypes.isWord(t);
            UserError.guarantee(Stream.of(parameterTypes).allMatch(isValid) && isValid.test(method.getSignature().getReturnType(null)), "C function pointer invocation method must have only primitive types or word types for its parameters and return value: " + method.format("%H.%n(%p)"), new Object[0]);
            b.append((ValueNode)new CFunctionPrologueNode());
        }
        assert (args.length >= 1);
        ValueNode methodAddress = args[0];
        ValueNode[] argsWithoutReceiver = Arrays.copyOfRange(args, 1, args.length);
        assert (argsWithoutReceiver.length == parameterTypes.length);
        Stamp returnStamp = this.wordTypes.isWord(b.getInvokeReturnType()) ? this.wordTypes.getWordStamp((ResolvedJavaType)b.getInvokeReturnType()) : b.getInvokeReturnStamp(null).getTrustedStamp();
        CallTargetNode indirectCallTargetNode = (CallTargetNode)b.add((ValueNode)new IndirectCallTargetNode(methodAddress, argsWithoutReceiver, StampPair.createSingle((Stamp)returnStamp), parameterTypes, method, callType, CallTargetNode.InvokeKind.Static));
        if (callType == SubstrateCallingConventionType.JavaCall) {
            b.handleReplacedInvoke(indirectCallTargetNode, b.getInvokeReturnType().getJavaKind());
        } else if (callType == SubstrateCallingConventionType.NativeCall) {
            InvokeNode invokeNode = new InvokeNode(indirectCallTargetNode, b.bci());
            if (CInterfaceInvocationPlugin.pushKind(method) != JavaKind.Void) {
                b.addPush(CInterfaceInvocationPlugin.pushKind(method), (ValueNode)invokeNode);
            } else {
                b.add((ValueNode)invokeNode);
            }
            b.append((ValueNode)new CFunctionEpilogueNode());
        } else {
            throw VMError.shouldNotReachHere("Unsupported type of call: " + callType);
        }
        return true;
    }

    public static JavaKind pushKind(ResolvedJavaMethod method) {
        return method.getSignature().getReturnKind().getStackKind();
    }
}

