/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.NativeImageOptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.word.WordTypes;

public abstract class SharedGraphBuilderPhase
extends GraphBuilderPhase.Instance {
    final WordTypes wordTypes;

    public SharedGraphBuilderPhase(MetaAccessProvider metaAccess, StampProvider stampProvider, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes) {
        super(metaAccess, stampProvider, constantReflection, constantFieldProvider, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        this.wordTypes = wordTypes;
    }

    public static abstract class SharedBytecodeParser
    extends BytecodeParser {
        private final boolean explicitExceptionEdges;

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
            this.explicitExceptionEdges = explicitExceptionEdges;
        }

        protected RuntimeException throwParserError(Throwable e) {
            if (e instanceof UserError.UserException) {
                throw (UserError.UserException)e;
            }
            throw super.throwParserError(e);
        }

        protected WordTypes getWordTypes() {
            return ((SharedGraphBuilderPhase)this.getGraphBuilderInstance()).wordTypes;
        }

        protected void maybeEagerlyResolve(int cpi, int bytecode) {
            block2: {
                try {
                    super.maybeEagerlyResolve(cpi, bytecode);
                }
                catch (Exception e) {
                    if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) break block2;
                    throw e;
                }
            }
        }

        private JavaMethod lookupFailedResolutionMethod(int cpi, int opcode) {
            assert (this.constantPool instanceof WrappedConstantPool);
            JavaMethod target = ((WrappedConstantPool)this.constantPool).lookupMethodInWrapped(cpi, opcode);
            return target;
        }

        private JavaType lookupFailedResolutionType(int cpi, int opcode) {
            assert (this.constantPool instanceof WrappedConstantPool);
            JavaType target = ((WrappedConstantPool)this.constantPool).lookupTypeInWrapped(cpi, opcode);
            return target;
        }

        private JavaField lookupFailedResolutionField(int cpi, ResolvedJavaMethod lookupMethod, int opcode) {
            assert (this.constantPool instanceof WrappedConstantPool);
            JavaField target = ((WrappedConstantPool)this.constantPool).lookupFieldInWrapped(cpi, lookupMethod, opcode);
            return target;
        }

        private void handleMethodResolutionError(LinkageError e, int cpi, int opcode, CallTargetNode.InvokeKind invokeKind) {
            if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                JavaMethod target = this.lookupFailedResolutionMethod(cpi, opcode);
                this.handleUnresolvedInvoke(target, invokeKind);
                return;
            }
            throw e;
        }

        protected void genInvokeStatic(int cpi, int opcode) {
            try {
                super.genInvokeStatic(cpi, opcode);
            }
            catch (LinkageError e) {
                this.handleMethodResolutionError(e, cpi, opcode, CallTargetNode.InvokeKind.Static);
            }
        }

        protected void genInvokeVirtual(int cpi, int opcode) {
            try {
                super.genInvokeVirtual(cpi, opcode);
            }
            catch (LinkageError e) {
                this.handleMethodResolutionError(e, cpi, opcode, CallTargetNode.InvokeKind.Virtual);
            }
        }

        protected void genInvokeSpecial(int cpi, int opcode) {
            try {
                super.genInvokeSpecial(cpi, opcode);
            }
            catch (LinkageError e) {
                this.handleMethodResolutionError(e, cpi, opcode, CallTargetNode.InvokeKind.Special);
            }
        }

        protected void genInvokeDynamic(int cpi, int opcode) {
            try {
                super.genInvokeDynamic(cpi, opcode);
            }
            catch (LinkageError e) {
                this.handleMethodResolutionError(e, cpi, opcode, CallTargetNode.InvokeKind.Static);
            }
        }

        protected void genNewInstance(int cpi) {
            try {
                super.genNewInstance(cpi);
            }
            catch (LinkageError e) {
                if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                    JavaType target = this.lookupFailedResolutionType(cpi, 187);
                    this.handleUnresolvedNewInstance(target);
                    return;
                }
                throw e;
            }
        }

        protected JavaType lookupType(int cpi, int bytecode) {
            try {
                return super.lookupType(cpi, bytecode);
            }
            catch (LinkageError e) {
                if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                    return null;
                }
                throw e;
            }
        }

        private boolean handleStoreFieldResolutionError(int cpi, int opcode) {
            if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                JavaField target = this.lookupFailedResolutionField(cpi, this.method, opcode);
                this.handleUnresolvedStoreField(target, null, null);
                return true;
            }
            return false;
        }

        private void handleLoadFieldResolutionError(LinkageError e, int cpi, int opcode, ValueNode receiverInput) {
            if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                JavaField target = this.lookupFailedResolutionField(cpi, this.method, opcode);
                this.handleUnresolvedLoadField(target, receiverInput);
                return;
            }
            throw e;
        }

        protected void genGetField(int cpi, int opcode, ValueNode receiverInput) {
            try {
                super.genGetField(cpi, opcode, receiverInput);
            }
            catch (LinkageError e) {
                this.handleLoadFieldResolutionError(e, cpi, opcode, receiverInput);
            }
        }

        protected void genPutField(int cpi, int opcode) {
            try {
                JavaField field = this.lookupField(cpi, opcode);
                if (field == null) {
                    this.handleStoreFieldResolutionError(cpi, opcode);
                } else {
                    this.genPutField(field);
                }
            }
            catch (LinkageError e) {
                if (this.handleStoreFieldResolutionError(cpi, opcode)) {
                    return;
                }
                throw e;
            }
        }

        protected void genGetStatic(int cpi, int opcode) {
            try {
                super.genGetStatic(cpi, opcode);
            }
            catch (LinkageError e) {
                this.handleLoadFieldResolutionError(e, cpi, opcode, null);
            }
        }

        protected void genPutStatic(int cpi, int opcode) {
            try {
                JavaField field = this.lookupField(cpi, opcode);
                if (field == null) {
                    this.handleStoreFieldResolutionError(cpi, opcode);
                } else {
                    this.genPutStatic(field);
                }
            }
            catch (LinkageError e) {
                if (this.handleStoreFieldResolutionError(cpi, opcode)) {
                    return;
                }
                throw e;
            }
        }

        protected void emitCheckForInvokeSuperSpecial(ValueNode[] args) {
        }

        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        protected void genIf(ValueNode x, Condition cond, ValueNode y) {
            if (x.getStackKind() == JavaKind.Object && y.getStackKind() == this.getWordTypes().getWordKind() || x.getStackKind() == this.getWordTypes().getWordKind() && y.getStackKind() == JavaKind.Object) {
                throw UserError.abort("Should not compare Word to Object in condition at " + this.method.format("%H.%n(%p)") + " in " + this.method.asStackTraceElement(this.bci()));
            }
            super.genIf(x, cond, y);
        }

        protected boolean shouldComplementProbability() {
            return !HostedConfiguration.instance().isUsingAOTProfiles();
        }

        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
            boolean isStatic = targetMethod.isStatic();
            if (!isStatic) {
                this.checkWordType(args[0], (JavaType)targetMethod.getDeclaringClass(), "call receiver");
            }
            for (int i = 0; i < targetMethod.getSignature().getParameterCount(false); ++i) {
                this.checkWordType(args[i + (isStatic ? 0 : 1)], targetMethod.getSignature().getParameterType(i, null), "call argument");
            }
            return super.createMethodCallTarget(invokeKind, targetMethod, args, returnStamp, profile);
        }

        protected void genReturn(ValueNode returnVal, JavaKind returnKind) {
            this.checkWordType(returnVal, this.method.getSignature().getReturnType(null), "return value");
            super.genReturn(returnVal, returnKind);
        }

        protected void genLoadConstant(int cpi, int opcode) {
            try {
                super.genLoadConstant(cpi, opcode);
            }
            catch (AnalysisError.TypeNotFoundError | LinkageError e) {
                if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
                    this.handleUnresolvedLoadConstant(null);
                    return;
                }
                throw e;
            }
        }

        private void checkWordType(ValueNode value, JavaType expectedType, String reason) {
            if (expectedType.getJavaKind() == JavaKind.Object) {
                boolean isWordValue;
                boolean isWordTypeExpected = this.getWordTypes().isWord(expectedType);
                boolean bl = isWordValue = value.getStackKind() == this.getWordTypes().getWordKind();
                if (isWordTypeExpected && !isWordValue) {
                    throw UserError.abort("Expected Word but got Object for " + reason + " at " + this.method.format("%H.%n(%p)") + " in " + this.method.asStackTraceElement(this.bci()));
                }
                if (!isWordTypeExpected && isWordValue) {
                    throw UserError.abort("Expected Object but got Word for " + reason + " at " + this.method.format("%H.%n(%p)") + " in " + this.method.asStackTraceElement(this.bci()));
                }
            }
        }

        protected boolean needsExplicitNullCheckException(ValueNode object) {
            return this.needsExplicitException() && object.getStackKind() == JavaKind.Object;
        }

        protected boolean needsExplicitStoreCheckException(ValueNode array, ValueNode value) {
            return this.needsExplicitException() && value.getStackKind() == JavaKind.Object;
        }

        public boolean needsExplicitException() {
            return this.explicitExceptionEdges && !this.parsingIntrinsic();
        }

        protected BytecodeParser.IntrinsicGuard guardIntrinsic(ValueNode[] args, ResolvedJavaMethod targetMethod, InvocationPlugins.InvocationPluginReceiver pluginReceiver) {
            return null;
        }

        public void notifyReplacedCall(ResolvedJavaMethod targetMethod, ConstantNode node) {
            JavaConstant constant = node.asJavaConstant();
            if (this.metaAccess instanceof AnalysisMetaAccess && constant.getJavaKind() == JavaKind.Object && constant.isNonNull()) {
                SubstrateObjectConstant sValue = (SubstrateObjectConstant)node.asJavaConstant();
                sValue.setRoot(targetMethod);
            }
        }
    }
}

