/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.nodes.SubstrateNewArrayNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewInstanceNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.phases.SharedGraphBuilderPhase;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public class SubstrateGraphBuilderPhase
extends SharedGraphBuilderPhase {
    private final Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate;

    public SubstrateGraphBuilderPhase(MetaAccessProvider metaAccess, StampProvider stampProvider, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes, Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate) {
        super(metaAccess, stampProvider, constantReflection, constantFieldProvider, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, wordTypes);
        this.deoptimizeOnExceptionPredicate = deoptimizeOnExceptionPredicate != null ? deoptimizeOnExceptionPredicate : method -> false;
    }

    protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        return new SubstrateBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext, false);
    }

    public static class SubstrateBytecodeParser
    extends SharedGraphBuilderPhase.SharedBytecodeParser {
        private boolean curDeoptimizeOnException;

        public SubstrateBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, explicitExceptionEdges);
        }

        protected SubstrateGraphBuilderPhase getGraphBuilderInstance() {
            return (SubstrateGraphBuilderPhase)super.getGraphBuilderInstance();
        }

        protected boolean disableLoopSafepoint() {
            return super.disableLoopSafepoint() || this.method.getAnnotation(Uninterruptible.class) != null;
        }

        protected NewInstanceNode createNewInstance(ResolvedJavaType type, boolean fillContents) {
            return new SubstrateNewInstanceNode(type, fillContents, null);
        }

        protected NewArrayNode createNewArray(ResolvedJavaType elementType, ValueNode length, boolean fillContents) {
            return new SubstrateNewArrayNode(elementType, length, fillContents, null);
        }

        protected void createHandleExceptionTarget(FixedWithNextNode finishedDispatch, int bci, FrameStateBuilder dispatchState) {
            if (this.curDeoptimizeOnException) {
                DeoptimizeNode deoptimize = (DeoptimizeNode)this.graph.add((Node)new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.NotCompiledExceptionHandler));
                VMError.guarantee(finishedDispatch.next() == null);
                finishedDispatch.setNext((FixedNode)deoptimize);
            } else {
                super.createHandleExceptionTarget(finishedDispatch, bci, dispatchState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InvokeWithExceptionNode createInvokeWithException(int invokeBci, CallTargetNode callTarget, JavaKind resultType, BytecodeParser.ExceptionEdgeAction exceptionEdgeAction) {
            try {
                assert (!this.curDeoptimizeOnException);
                this.curDeoptimizeOnException = this.getGraphBuilderInstance().deoptimizeOnExceptionPredicate.test(callTarget.targetMethod());
                InvokeWithExceptionNode invokeWithExceptionNode = super.createInvokeWithException(invokeBci, callTarget, resultType, exceptionEdgeAction);
                return invokeWithExceptionNode;
            }
            finally {
                this.curDeoptimizeOnException = false;
            }
        }

        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.getSource().equals(Fold.class) || plugin.getSource().equals(Node.NodeIntrinsic.class);
        }

        public InvokeWithExceptionNode handleInvokeWithException(CallTargetNode callTarget, JavaKind resultType) {
            InvokeWithExceptionNode invoke = this.createInvokeWithException(this.bci(), callTarget, resultType, BytecodeParser.ExceptionEdgeAction.INCLUDE_AND_HANDLE);
            AbstractBeginNode beginNode = (AbstractBeginNode)this.graph.add((Node)KillingBeginNode.create((LocationIdentity)LocationIdentity.any()));
            invoke.setNext(beginNode);
            this.lastInstr = beginNode;
            return invoke;
        }
    }
}

