/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.GraalAccess;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class InjectedAccessorsField
implements ReadableJavaField {
    private final ResolvedJavaField original;
    private final InjectAccessors injectAccessors;

    public InjectedAccessorsField(ResolvedJavaField original, InjectAccessors injectAccessors) {
        this.original = original;
        this.injectAccessors = injectAccessors;
    }

    public Annotation[] getAnnotations() {
        Annotation[] result = this.original.getAnnotations();
        result = Arrays.copyOf(result, result.length + 1);
        result[result.length - 1] = this.injectAccessors;
        return result;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (InjectAccessors.class.isAssignableFrom(annotationClass)) {
            return (T)((Annotation)annotationClass.cast(this.injectAccessors));
        }
        return (T)this.original.getAnnotation(annotationClass);
    }

    @Override
    public JavaConstant readValue(JavaConstant receiver) {
        return ReadableJavaField.readFieldValue(GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
    }

    @Override
    public boolean allowConstantFolding() {
        throw VMError.shouldNotReachHere();
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return ReadableJavaField.injectFinalForRuntimeCompilation(this.original);
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public String toString() {
        return "InjectedAccessorsField<original " + this.original.toString() + ">";
    }
}

