/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.truffle.SubstrateTruffleCompilationIdentifier;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstrateTruffleInstalledCodeBridge;
import java.util.Map;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateTruffleCompiler
extends TruffleCompilerImpl {
    private final String compilerConfigurationName = GraalConfiguration.instance().getCompilerConfigurationName();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler(TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, Suites suites, LIRSuites lirSuites, Backend backend, SnippetReflectionProvider snippetReflection) {
        super(runtime, plugins, suites, lirSuites, backend, null, null, null, snippetReflection);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PartialEvaluator createPartialEvaluator() {
        return TruffleFeature.getSupport().createPartialEvaluator(this.lastTierProviders, this.config, this.snippetReflection, this.backend.getTarget().arch);
    }

    public PhaseSuite<HighTierContext> createGraphBuilderSuite() {
        return null;
    }

    public String getCompilerConfigurationName() {
        return this.compilerConfigurationName;
    }

    protected CompilationResult createCompilationResult(String name, CompilationIdentifier compilationIdentifier, CompilableTruffleAST compilable) {
        return new SubstrateCompilationResult(compilationIdentifier, name);
    }

    public CompilationIdentifier getCompilationIdentifier(CompilableTruffleAST optimizedCallTarget) {
        return new SubstrateTruffleCompilationIdentifier((OptimizedCallTarget)optimizedCallTarget);
    }

    public DebugContext openDebugContext(OptionValues options, CompilationIdentifier compilationId, CompilableTruffleAST callTarget) {
        return GraalSupport.get().openDebugContext(options, compilationId, callTarget);
    }

    protected DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return GraalSupport.get().getDebugOutputDirectory();
    }

    protected Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return GraalSupport.get().getCompilationProblemsPerAction();
    }

    protected InstalledCode createInstalledCode(CompilableTruffleAST compilable) {
        return new SubstrateTruffleInstalledCodeBridge((SubstrateOptimizedCallTarget)compilable);
    }
}

