/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field59
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "59";
    public static final String F_59 = "59";
    public static final Integer ACCOUNT = 1;
    public static final Integer NAME_AND_ADDRESS = 2;

    public Field59() {
        super(5);
    }

    public Field59(String value) {
        super(value);
    }

    public Field59(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"59")) {
            throw new IllegalArgumentException("cannot create field 59 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field59 newInstance(Field59 source) {
        Field59 cp = new Field59();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("59", value);
    }

    public static Tag emptyTag() {
        return new Tag("59", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            if (lines.get(0).startsWith("/")) {
                this.setComponent1(StringUtils.substring((String)lines.get(0), (int)1));
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 1, lines);
            } else {
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 0, lines);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        this.appendInLines(result, 2, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 59");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return this.getComponent(5);
    }

    @Override
    public String typesPattern() {
        return "SSSSS";
    }

    @Override
    public String parserPattern() {
        return "[/S$]S[$S]0-3";
    }

    @Override
    public String validatorPattern() {
        return "[/34x$]35x[$35x]0-3";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "account");
        result.put(2, "nameAndAddress");
        result.put(3, "nameAndAddress2");
        result.put(4, "nameAndAddress3");
        result.put(5, "nameAndAddress4");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("account", 1);
        this.labelMap.put("nameandaddress", 2);
        this.labelMap.put("nameandaddress2", 3);
        this.labelMap.put("nameandaddress3", 4);
        this.labelMap.put("nameandaddress4", 5);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String account = this.getComponent(1);
        if (account != null) {
            for (int i = 0; i < account.length(); ++i) {
                if (account.charAt(i) == '/') continue;
                return account.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent2();
    }

    public String getNameAndAddress() {
        return this.getNameAndAddress(null);
    }

    public String getNameAndAddress(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 6; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent4();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent5();
    }

    public Field59 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field59 setAccount(String component1) {
        return this.setComponent1(component1);
    }

    public Field59 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field59 setNameAndAddressLine1(String component2) {
        return this.setComponent2(component2);
    }

    public Field59 setNameAndAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 4, 0, lines);
        return this;
    }

    public Field59 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field59 setNameAndAddressLine2(String component3) {
        return this.setComponent3(component3);
    }

    public Field59 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field59 setNameAndAddressLine3(String component4) {
        return this.setComponent4(component4);
    }

    public Field59 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field59 setNameAndAddressLine4(String component5) {
        return this.setComponent5(component5);
    }

    @Override
    public String getName() {
        return "59";
    }

    public static Field59 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("59");
        if (t == null) {
            return null;
        }
        return new Field59(t);
    }

    public static Field59 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field59.get(msg.getBlock4());
    }

    public static List<Field59> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field59.getAll(msg.getBlock4());
    }

    public static List<Field59> getAll(SwiftTagListBlock block) {
        ArrayList<Field59> result = new ArrayList<Field59>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("59");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field59(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field59 cp = Field59.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field59 cp = Field59.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field59 cp = Field59.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field59 fromJson(String json) {
        Field59 field = new Field59();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("account") != null) {
            field.setComponent1(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("nameAndAddress") != null) {
            field.setComponent2(jsonObject.get("nameAndAddress").getAsString());
        }
        if (jsonObject.get("nameAndAddress2") != null) {
            field.setComponent3(jsonObject.get("nameAndAddress2").getAsString());
        }
        if (jsonObject.get("nameAndAddress3") != null) {
            field.setComponent4(jsonObject.get("nameAndAddress3").getAsString());
        }
        if (jsonObject.get("nameAndAddress4") != null) {
            field.setComponent5(jsonObject.get("nameAndAddress4").getAsString());
        }
        return field;
    }
}

