/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.java.models.consumer.objects_api.membership;

import lombok.NonNull;

public class PNChannelMembership {
    private final ChannelId channel;
    private Object custom;
    private String status;
    private String type;

    public static Builder builder(String channelId) {
        return new Builder(channelId);
    }

    private PNChannelMembership(Builder builder) {
        this.channel = new ChannelId(builder.channelId);
        this.custom = builder.custom;
        this.status = builder.status;
        this.type = builder.type;
    }

    public static PNChannelMembership channel(String channelId) {
        return new JustChannel(new ChannelId(channelId));
    }

    public static PNChannelMembership channelWithCustom(String channelId, Object custom) {
        return new ChannelWithCustom(new ChannelId(channelId), custom);
    }

    public PNChannelMembership(ChannelId channel) {
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PNChannelMembership)) {
            return false;
        }
        PNChannelMembership other = (PNChannelMembership)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChannelId this$channel = this.getChannel();
        ChannelId other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Object this$custom = this.getCustom();
        Object other$custom = other.getCustom();
        if (this$custom == null ? other$custom != null : !this$custom.equals(other$custom)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PNChannelMembership;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChannelId $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Object $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public ChannelId getChannel() {
        return this.channel;
    }

    public Object getCustom() {
        return this.custom;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public static class ChannelWithCustom
    extends PNChannelMembership {
        private final Object custom;

        public ChannelWithCustom(@NonNull ChannelId channelId, @NonNull Object custom) {
            super(channelId);
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (custom == null) {
                throw new NullPointerException("custom is marked non-null but is null");
            }
            this.custom = custom;
        }

        @Override
        public Object getCustom() {
            return this.custom;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelWithCustom)) {
                return false;
            }
            ChannelWithCustom other = (ChannelWithCustom)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Object this$custom = this.getCustom();
            Object other$custom = other.getCustom();
            return !(this$custom == null ? other$custom != null : !this$custom.equals(other$custom));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelWithCustom;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Object $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
            return result;
        }
    }

    public static class JustChannel
    extends PNChannelMembership {
        public JustChannel(@NonNull ChannelId channelId) {
            super(channelId);
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JustChannel)) {
                return false;
            }
            JustChannel other = (JustChannel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof JustChannel;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class ChannelId {
        private final String id;

        public ChannelId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelId)) {
                return false;
            }
            ChannelId other = (ChannelId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Builder {
        private final String channelId;
        private Object custom;
        private String status;
        private String type;

        public Builder(String channelId) {
            if (channelId == null || channelId.isEmpty()) {
                throw new IllegalArgumentException("channelId cannot be null or empty");
            }
            this.channelId = channelId;
        }

        public Builder custom(Object custom) {
            this.custom = custom;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public PNChannelMembership build() {
            return new PNChannelMembership(this);
        }
    }
}

