/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.History;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryImpl
extends PassthroughEndpoint<PNHistoryResult>
implements History {
    private static final Logger log = LoggerFactory.getLogger(HistoryImpl.class);
    private String channel;
    private Long start;
    private Long end;
    private boolean reverse;
    private int count = 100;
    private boolean includeTimetoken;
    private boolean includeMeta;

    public HistoryImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNHistoryResult> createRemoteAction() {
        return this.pubnub.history(this.channel, this.start, this.end, this.count, this.reverse, this.includeTimetoken, this.includeMeta);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public HistoryImpl channel(String channel) {
        this.channel = channel;
        return this;
    }

    public HistoryImpl start(Long start) {
        this.start = start;
        return this;
    }

    public HistoryImpl end(Long end) {
        this.end = end;
        return this;
    }

    public HistoryImpl reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public HistoryImpl count(int count) {
        this.count = count;
        return this;
    }

    public HistoryImpl includeTimetoken(boolean includeTimetoken) {
        this.includeTimetoken = includeTimetoken;
        return this;
    }

    public HistoryImpl includeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
        return this;
    }
}

