/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.files.ListFiles;
import com.pubnub.api.models.consumer.files.PNListFilesResult;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;

public class ListFilesImpl
extends PassthroughEndpoint<PNListFilesResult>
implements ListFiles {
    private final String channel;
    private Integer limit;
    private PNPage.PNNext next;

    public ListFilesImpl(String channel, PubNub pubnub) {
        super(pubnub);
        this.channel = channel;
    }

    @Override
    @NotNull
    protected Endpoint<PNListFilesResult> createRemoteAction() {
        return this.pubnub.listFiles(this.channel, this.limit, this.next);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
        if (this.limit != null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS, "Limit should be in range from 1 to 100 (both inclusive)");
        }
        if (this.next != null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS, "Next should not be an empty string");
        }
    }

    public ListFilesImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ListFilesImpl next(PNPage.PNNext next) {
        this.next = next;
        return this;
    }

    public static class Builder
    implements ListFiles.Builder {
        private final PubNub pubnubInstance;

        public Builder(PubNub pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }

        public ListFiles channel(String channel) {
            return new ListFilesImpl(channel, this.pubnubInstance);
        }
    }
}

