/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.java.endpoints.BuilderSteps;
import com.pubnub.api.java.endpoints.files.SendFile;
import com.pubnub.api.java.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.internal.java.endpoints.PassthroughRemoteAction;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class SendFileImpl
extends PassthroughRemoteAction<PNFileUploadResult>
implements SendFile {
    private final String channel;
    private final String fileName;
    private final InputStream inputStream;
    private Object message;
    private Object meta;
    private Integer ttl;
    private Boolean shouldStore;
    private String cipherKey;
    private String customMessageType;

    public SendFileImpl(PubNub pubnub, String channel, String fileName, InputStream inputStream) {
        super(pubnub);
        this.channel = channel;
        this.fileName = fileName;
        this.inputStream = inputStream;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNFileUploadResult> createRemoteAction() {
        return this.pubnub.sendFile(this.channel, this.fileName, this.inputStream, this.message, this.meta, this.ttl, this.shouldStore, this.cipherKey, this.customMessageType);
    }

    public SendFileImpl message(Object message) {
        this.message = message;
        return this;
    }

    public SendFileImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public SendFileImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SendFileImpl shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    public SendFileImpl cipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public SendFileImpl customMessageType(String customMessageType) {
        this.customMessageType = customMessageType;
        return this;
    }

    public static class Builder
    implements SendFile.Builder {
        private final PubNub pubnub;

        public Builder(PubNub pubnub) {
            this.pubnub = pubnub;
        }

        public FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>> channel(String channel) {
            return new InnerBuilder(this.pubnub).channel(channel);
        }

        public static class InnerBuilder
        implements BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>>,
        FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>,
        FilesBuilderSteps.InputStreamStep<SendFile> {
            private final PubNub pubnub;
            private String channelValue;
            private String fileNameValue;

            private InnerBuilder(PubNub pubnub) {
                this.pubnub = pubnub;
            }

            public FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>> channel(String channel) {
                this.channelValue = channel;
                return this;
            }

            public FilesBuilderSteps.InputStreamStep<SendFile> fileName(String fileName) {
                this.fileNameValue = fileName;
                return this;
            }

            public SendFile inputStream(InputStream inputStream) {
                return new SendFileImpl(this.pubnub, this.channelValue, this.fileNameValue, inputStream);
            }
        }
    }
}

