/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.objects_api.members;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.java.endpoints.objects_api.members.ManageChannelMembers;
import com.pubnub.api.java.endpoints.objects_api.members.ManageChannelMembersBuilder;
import com.pubnub.api.java.endpoints.objects_api.utils.Include;
import com.pubnub.api.java.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.java.models.consumer.objects_api.member.MemberInclude;
import com.pubnub.api.java.models.consumer.objects_api.member.PNManageChannelMembersResult;
import com.pubnub.api.java.models.consumer.objects_api.member.PNManageChannelMembersResultConverter;
import com.pubnub.api.java.models.consumer.objects_api.member.PNUUID;
import com.pubnub.api.java.models.consumer.objects_api.member.PNUser;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects.member.MemberInput;
import com.pubnub.api.models.consumer.objects.member.PNMember;
import com.pubnub.api.models.consumer.objects.member.PNMemberArrayResult;
import com.pubnub.internal.java.endpoints.DelegatingEndpoint;
import com.pubnub.internal.java.endpoints.objects_api.members.SetChannelMembersImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ManageChannelMembersImpl
extends DelegatingEndpoint<PNMemberArrayResult, PNManageChannelMembersResult>
implements ManageChannelMembers,
ManageChannelMembersBuilder {
    private final String channel;
    private Integer limit = null;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private boolean includeType;
    private Include.PNUUIDDetailsLevel includeUUID;
    private Collection<PNUUID> uuidsToSet;
    private Collection<PNUUID> uuidsToRemove;
    private Collection<PNUser> usersToSet;
    private List<String> userIdsToRemove;
    private MemberInclude include;

    @Deprecated
    public ManageChannelMembersImpl(String channel, Collection<PNUUID> uuidsToSet, Collection<PNUUID> uuidsToRemove, PubNub pubnubInstance) {
        super(pubnubInstance);
        this.channel = channel;
        this.uuidsToSet = uuidsToSet;
        this.uuidsToRemove = uuidsToRemove;
    }

    public ManageChannelMembersImpl(PubNub pubnubInstance, String channel, Collection<PNUser> usersToSet, Collection<String> userIdsToRemove) {
        super(pubnubInstance);
        this.channel = channel;
        this.usersToSet = usersToSet;
        this.userIdsToRemove = new ArrayList<String>(userIdsToRemove);
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNManageChannelMembersResult> mapResult(@NotNull ExtendedRemoteAction<PNMemberArrayResult> action) {
        return new MappingRemoteAction(action, PNManageChannelMembersResultConverter::from);
    }

    @Override
    @NotNull
    protected Endpoint<PNMemberArrayResult> createRemoteAction() {
        List<String> toRemove;
        List<MemberInput> toSet;
        if (this.usersToSet != null || this.userIdsToRemove != null) {
            toSet = this.createMemberInputFromUserToSet();
            toRemove = this.userIdsToRemove;
        } else {
            toSet = this.createMemberInputFromUUIDToSet();
            toRemove = this.createUserIdsFromUUIDToRemove();
        }
        return this.pubnub.manageChannelMembers(this.channel, toSet, toRemove, this.limit, this.page, this.filter, SetChannelMembersImpl.toInternal(this.sort), (com.pubnub.api.models.consumer.objects.member.MemberInclude)SetChannelMembersImpl.getMemberInclude(this.include, this.includeUUID, this.includeTotalCount, this.includeCustom, this.includeType));
    }

    private List<MemberInput> createMemberInputFromUserToSet() {
        if (this.usersToSet == null) {
            return Collections.emptyList();
        }
        ArrayList<MemberInput> memberInputs = new ArrayList<MemberInput>();
        for (PNUser user : this.usersToSet) {
            memberInputs.add((MemberInput)new PNMember.Partial(user.getUserId(), user.getCustom(), user.getStatus(), user.getType()));
        }
        return memberInputs;
    }

    private List<MemberInput> createMemberInputFromUUIDToSet() {
        if (this.uuidsToSet == null) {
            return Collections.emptyList();
        }
        ArrayList<MemberInput> memberInputs = new ArrayList<MemberInput>();
        for (PNUUID uuid : this.uuidsToSet) {
            memberInputs.add((MemberInput)new PNMember.Partial(uuid.getUuid().getId(), uuid instanceof PNUUID.UUIDWithCustom ? ((PNUUID.UUIDWithCustom)uuid).getCustom() : null, uuid.getStatus(), null));
        }
        return memberInputs;
    }

    private List<String> createUserIdsFromUUIDToRemove() {
        if (this.uuidsToRemove == null) {
            return Collections.emptyList();
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (PNUUID uuid : this.uuidsToRemove) {
            toRemove.add(uuid.getUuid().getId());
        }
        return toRemove;
    }

    public ManageChannelMembersImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ManageChannelMembersImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public ManageChannelMembersImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public ManageChannelMembersImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public ManageChannelMembersImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public ManageChannelMembersImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public ManageChannelMembersImpl includeType(boolean includeType) {
        this.includeType = includeType;
        return this;
    }

    public ManageChannelMembersImpl includeUUID(Include.PNUUIDDetailsLevel includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }

    public ManageChannelMembersImpl uuidsToSet(Collection<PNUUID> uuidsToSet) {
        this.uuidsToSet = uuidsToSet;
        return this;
    }

    public ManageChannelMembersImpl uuidsToRemove(Collection<PNUUID> uuidsToRemove) {
        this.uuidsToRemove = uuidsToRemove;
        return this;
    }

    public ManageChannelMembersImpl usersToSet(Collection<PNUser> usersToSet) {
        this.usersToSet = usersToSet;
        return this;
    }

    public ManageChannelMembersImpl userIdsToRemove(List<String> userIdsToRemove) {
        this.userIdsToRemove = userIdsToRemove;
        return this;
    }

    public ManageChannelMembersImpl include(MemberInclude include) {
        this.include = include;
        return this;
    }

    public static class Builder
    implements ManageChannelMembers.Builder {
        private final PubNub pubnubInstance;

        public Builder(PubNub pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }

        public ObjectsBuilderSteps.RemoveOrSetStep<ManageChannelMembers, PNUUID> channel(final String channel) {
            return new ObjectsBuilderSteps.RemoveOrSetStep<ManageChannelMembers, PNUUID>(){

                public ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageChannelMembers, PNUUID> set(final Collection<PNUUID> uuidsToSet) {
                    return new ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageChannelMembers, PNUUID>(){

                        public ManageChannelMembers remove(Collection<PNUUID> uuidsToRemove) {
                            return new ManageChannelMembersImpl(channel, uuidsToSet, uuidsToRemove, pubnubInstance);
                        }
                    };
                }

                public ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageChannelMembers, PNUUID> remove(final Collection<PNUUID> uuidsToRemove) {
                    return new ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageChannelMembers, PNUUID>(){

                        public ManageChannelMembers set(Collection<PNUUID> uuidsToSet) {
                            return new ManageChannelMembersImpl(channel, uuidsToSet, uuidsToRemove, pubnubInstance);
                        }
                    };
                }
            };
        }
    }
}

