/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.push;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.push.AddChannelsToPush;
import com.pubnub.api.models.consumer.push.PNPushAddChannelResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddChannelsToPushImpl
extends PassthroughEndpoint<PNPushAddChannelResult>
implements AddChannelsToPush {
    private PNPushType pushType;
    private List<String> channels;
    private String deviceId;
    private PNPushEnvironment environment = PNPushEnvironment.DEVELOPMENT;
    private String topic;

    public AddChannelsToPushImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNPushAddChannelResult> createRemoteAction() {
        return this.pubnub.addPushNotificationsOnChannels(this.pushType, this.channels, this.deviceId, this.topic, this.environment);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.pushType == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING);
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING);
        }
        if (this.channels == null || this.channels.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public AddChannelsToPushImpl pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public AddChannelsToPushImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public AddChannelsToPushImpl deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public AddChannelsToPushImpl environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public AddChannelsToPushImpl topic(String topic) {
        this.topic = topic;
        return this;
    }
}

