/*
 * Decompiled with CFR 0.152.
 */
package spark.staticfiles;

import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import spark.utils.Assert;

public class StaticFiles {
    public static void setLocationIfPresent(String staticFileLocation, List<Handler> handlersInList) {
        Assert.notNull(handlersInList, "'handlersInList' must not be null");
        if (staticFileLocation != null) {
            ResourceHandler resourceHandler = new ResourceHandler();
            Resource staticResources = Resource.newClassPathResource((String)staticFileLocation);
            resourceHandler.setBaseResource(staticResources);
            resourceHandler.setWelcomeFiles(new String[]{"index.html"});
            handlersInList.add((Handler)resourceHandler);
        }
    }

    public static void setExternalLocationIfPresent(String externalFileLocation, List<Handler> handlersInList) {
        Assert.notNull(handlersInList, "'handlersInList' must not be null");
        if (externalFileLocation != null) {
            ResourceHandler externalResourceHandler = new ResourceHandler();
            externalResourceHandler.setResourceBase(externalFileLocation);
            externalResourceHandler.setWelcomeFiles(new String[]{"index.html"});
            handlersInList.add((Handler)externalResourceHandler);
        }
    }
}

