/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.common.AssetId;
import im.mak.paddle.Account;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommonParams<T extends CommonParams<?>> {
    protected final Account sender;
    protected final long baseFee;
    protected long additionalFee;
    protected AssetId feeAssetId;
    protected long timestamp;
    protected List<Account> signers;

    protected CommonParams(Account sender, long baseFee) {
        this.sender = sender;
        this.baseFee = baseFee;
        this.additionalFee = 0L;
        this.feeAssetId = AssetId.WAVES;
        this.timestamp = 0L;
        this.signers = new ArrayList<Account>();
    }

    protected long getFee() {
        return this.baseFee + this.sender.getScriptInfo().extraFee() + this.additionalFee;
    }

    public T timestamp(long timestamp) {
        this.timestamp = timestamp;
        return (T)this;
    }

    public T additionalFee(long amount) {
        this.additionalFee = amount;
        return (T)this;
    }

    public T signedBy(Account ... signers) {
        this.signers.addAll(Arrays.asList(signers));
        return (T)this;
    }

    public T signedBy(int proofIndex, Account signer) {
        for (int i = this.signers.size(); i <= proofIndex; ++i) {
            this.signers.add(null);
        }
        this.signers.set(proofIndex, signer);
        return (T)this;
    }
}

