/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.invocation.Arg;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.wavesj.ScriptInfo;
import im.mak.paddle.Account;
import im.mak.paddle.InvokeScriptParamsOptional;
import im.mak.paddle.Node;
import im.mak.paddle.util.RecipientResolver;
import im.mak.paddle.util.Script;

public class InvokeScriptParams
extends InvokeScriptParamsOptional {
    protected Recipient dApp;
    protected Function functions;

    protected InvokeScriptParams(Account sender) {
        super(sender);
        this.dApp = sender.address();
        this.defaultFunction();
    }

    @Override
    protected long getFee() {
        long totalWavesFee = super.getFee();
        ScriptInfo scriptInfo = Node.node().getScriptInfo(RecipientResolver.toAddress(this.dApp));
        int rideVersion = Script.getRideVersion(scriptInfo.script());
        if (rideVersion <= 4) {
            for (Amount payment : this.payments) {
                if (payment.assetId().isWaves() || !Node.node().getAssetDetails(payment.assetId()).isScripted()) continue;
                totalWavesFee += 400000L;
            }
        }
        if (this.feeAssetId.isWaves()) {
            return totalWavesFee;
        }
        long minSponsoredFee = Node.node().getAssetDetails(this.feeAssetId).minSponsoredAssetFee();
        long increment = totalWavesFee % 100000L == 0L ? 0L : minSponsoredFee;
        return totalWavesFee / 100000L * minSponsoredFee + increment;
    }

    public InvokeScriptParams dApp(Recipient addressOrAlias) {
        this.dApp = addressOrAlias;
        return this;
    }

    public InvokeScriptParams dApp(Account account) {
        return this.dApp((Recipient)account.address());
    }

    public InvokeScriptParams function(Function function) {
        this.functions = function;
        return this;
    }

    public InvokeScriptParams function(String name, Arg ... args) {
        return this.function(Function.as((String)name, (Arg[])args));
    }

    public InvokeScriptParams defaultFunction() {
        this.functions = Function.asDefault();
        return this;
    }
}

