/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.mass.Transfer;
import im.mak.paddle.Account;
import im.mak.paddle.CommonParams;
import im.mak.paddle.Node;
import im.mak.paddle.token.Token;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MassTransferParams
extends CommonParams<MassTransferParams> {
    protected AssetId assetId;
    protected List<Transfer> transfers = new LinkedList<Transfer>();
    protected Base58String attachment;

    protected MassTransferParams(Account sender) {
        super(sender, 100000L);
        this.assetId = AssetId.WAVES;
        this.attachment = Base58String.empty();
    }

    @Override
    protected long getFee() {
        long totalWavesFee = super.getFee();
        if (!this.assetId.isWaves() && Node.node().getAssetDetails(this.assetId).isScripted()) {
            totalWavesFee += 400000L;
        }
        return totalWavesFee += (long)((this.transfers.size() + 1) / 2) * 100000L;
    }

    public MassTransferParams assetId(AssetId assetId) {
        this.assetId = assetId;
        return this;
    }

    public MassTransferParams asset(Token token) {
        return this.assetId(token.id());
    }

    public MassTransferParams to(Recipient recipient, long amount) {
        this.transfers.add(Transfer.to((Recipient)recipient, (long)amount));
        return this;
    }

    public MassTransferParams to(Account recipient, long amount) {
        return this.to((Recipient)recipient.address(), amount);
    }

    public MassTransferParams transfers(Transfer ... transfers) {
        this.transfers.addAll(Arrays.asList(transfers));
        return this;
    }

    public MassTransferParams attachment(Base58String message) {
        this.attachment = message;
        return this;
    }

    public MassTransferParams attachmentUtf8(String utf8Message) {
        return this.attachment(new Base58String(utf8Message.getBytes(StandardCharsets.UTF_8)));
    }
}

