/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.wavesj.AssetBalance;
import com.wavesplatform.wavesj.AssetDetails;
import com.wavesplatform.wavesj.AssetDistribution;
import com.wavesplatform.wavesj.Balance;
import com.wavesplatform.wavesj.BalanceDetails;
import com.wavesplatform.wavesj.Block;
import com.wavesplatform.wavesj.BlockHeaders;
import com.wavesplatform.wavesj.BlockchainRewards;
import com.wavesplatform.wavesj.HistoryBalance;
import com.wavesplatform.wavesj.LeaseInfo;
import com.wavesplatform.wavesj.ScriptInfo;
import com.wavesplatform.wavesj.ScriptMeta;
import com.wavesplatform.wavesj.TransactionStatus;
import com.wavesplatform.wavesj.Validation;
import com.wavesplatform.wavesj.exceptions.NodeException;
import com.wavesplatform.wavesj.info.TransactionInfo;
import im.mak.paddle.Account;
import im.mak.paddle.exceptions.ApiError;
import im.mak.paddle.exceptions.NodeError;
import im.mak.paddle.internal.Settings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class Node
extends com.wavesplatform.wavesj.Node {
    private static Node instance;
    protected final Settings conf;
    protected final Account faucet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node node() {
        if (instance != null) return instance;
        Class<Node> clazz = Node.class;
        synchronized (Node.class) {
            if (instance != null) return instance;
            try {
                instance = new Node();
            }
            catch (IOException | URISyntaxException e) {
                throw new NodeError(e);
            }
            catch (NodeException e) {
                throw new ApiError(e.getErrorCode(), e.getMessage());
            }
            return instance;
        }
    }

    public Node(Settings settings) throws NodeException, IOException, URISyntaxException {
        super(Node.maybeRunDockerContainer(settings));
        this.conf = settings;
        this.faucet = this.conf.faucetSeed == null ? null : new Account(PrivateKey.fromSeed((String)this.conf().faucetSeed), this);
    }

    protected Node() throws NodeException, IOException, URISyntaxException {
        this(new Settings());
    }

    protected static String maybeRunDockerContainer(Settings conf) {
        if (conf.dockerImage != null) {
            String containerId;
            DefaultDockerClient docker;
            try {
                docker = DefaultDockerClient.fromEnv().build();
                try {
                    docker.pull(conf.dockerImage);
                }
                catch (DockerException | InterruptedException throwable) {
                    // empty catch block
                }
                URL apiUrl = new URL(conf.apiUrl);
                int port = apiUrl.getPort() <= 0 ? 80 : apiUrl.getPort();
                HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
                portBindings.put("6869", Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)port)));
                HostConfig hostConfig = HostConfig.builder().portBindings(portBindings).build();
                ContainerConfig containerConfig = ContainerConfig.builder().hostConfig(hostConfig).image(conf.dockerImage).exposedPorts(new String[]{"6869"}).build();
                containerId = docker.createContainer(containerConfig).id();
                docker.startContainer(containerId);
                boolean isNodeReady = false;
                for (int repeat = 0; repeat < 60; ++repeat) {
                    try {
                        try {
                            com.wavesplatform.wavesj.Node node = new com.wavesplatform.wavesj.Node(conf.apiUrl);
                        }
                        catch (IOException | URISyntaxException e) {
                            throw new NodeError(e);
                        }
                        catch (NodeException e) {
                            throw new ApiError(e.getErrorCode(), e.getMessage());
                        }
                        isNodeReady = true;
                        break;
                    }
                    catch (ApiError | NodeError e) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (!isNodeReady) {
                    throw new NodeError("Could not wait for node readiness");
                }
            }
            catch (DockerCertificateException | DockerException | InterruptedException | MalformedURLException e) {
                throw new NodeError(e);
            }
            if (conf.autoShutdown) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Node.lambda$maybeRunDockerContainer$1((DockerClient)docker, containerId)));
            }
        }
        return conf.apiUrl;
    }

    public Settings conf() {
        return this.conf;
    }

    public Account faucet() {
        return this.faucet;
    }

    public int minAssetInfoUpdateInterval() {
        return this.conf().minAssetInfoUpdateInterval;
    }

    protected <T> T throwErrorOrGet(Callable<T> mightThrowException) {
        try {
            return mightThrowException.call();
        }
        catch (IOException e) {
            throw new NodeError(e);
        }
        catch (NodeException e) {
            throw new ApiError(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Address> getAddresses() {
        return this.throwErrorOrGet(() -> super.getAddresses());
    }

    public List<Address> getAddresses(int fromIndex, int toIndex) {
        return this.throwErrorOrGet(() -> super.getAddresses(fromIndex, toIndex));
    }

    public long getBalance(Address address) {
        return this.throwErrorOrGet(() -> super.getBalance(address));
    }

    public long getBalance(Address address, int confirmations) {
        return this.throwErrorOrGet(() -> super.getBalance(address, confirmations));
    }

    public List<Balance> getBalances(List<Address> addresses) {
        return this.throwErrorOrGet(() -> super.getBalances(addresses));
    }

    public List<Balance> getBalances(List<Address> addresses, int height) {
        return this.throwErrorOrGet(() -> super.getBalances(addresses, height));
    }

    public BalanceDetails getBalanceDetails(Address address) {
        return this.throwErrorOrGet(() -> super.getBalanceDetails(address));
    }

    public List<DataEntry> getData(Address address) {
        return this.throwErrorOrGet(() -> super.getData(address));
    }

    public List<DataEntry> getData(Address address, List<String> keys) {
        return this.throwErrorOrGet(() -> super.getData(address, keys));
    }

    public List<DataEntry> getData(Address address, Pattern regex) {
        return this.throwErrorOrGet(() -> super.getData(address, regex));
    }

    public DataEntry getData(Address address, String key) {
        return this.throwErrorOrGet(() -> super.getData(address, key));
    }

    public long getEffectiveBalance(Address address) {
        return this.throwErrorOrGet(() -> super.getEffectiveBalance(address));
    }

    public long getEffectiveBalance(Address address, int confirmations) {
        return this.throwErrorOrGet(() -> super.getEffectiveBalance(address, confirmations));
    }

    public ScriptInfo getScriptInfo(Address address) {
        return this.throwErrorOrGet(() -> super.getScriptInfo(address));
    }

    public ScriptMeta getScriptMeta(Address address) {
        return this.throwErrorOrGet(() -> super.getScriptMeta(address));
    }

    public List<Alias> getAliasesByAddress(Address address) {
        return this.throwErrorOrGet(() -> super.getAliasesByAddress(address));
    }

    public Address getAddressByAlias(Alias alias) {
        return this.throwErrorOrGet(() -> super.getAddressByAlias(alias));
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height) {
        return this.throwErrorOrGet(() -> super.getAssetDistribution(assetId, height));
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height, int limit) {
        return this.throwErrorOrGet(() -> super.getAssetDistribution(assetId, height, limit));
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height, int limit, Address after) {
        return this.throwErrorOrGet(() -> super.getAssetDistribution(assetId, height, limit, after));
    }

    public List<AssetBalance> getAssetsBalance(Address address) {
        return this.throwErrorOrGet(() -> super.getAssetsBalance(address));
    }

    public long getAssetBalance(Address address, AssetId assetId) {
        return this.throwErrorOrGet(() -> super.getAssetBalance(address, assetId));
    }

    public AssetDetails getAssetDetails(AssetId assetId) {
        return this.throwErrorOrGet(() -> super.getAssetDetails(assetId));
    }

    public List<AssetDetails> getAssetsDetails(List<AssetId> assetIds) {
        return this.throwErrorOrGet(() -> super.getAssetsDetails(assetIds));
    }

    public List<AssetDetails> getNft(Address address) {
        return this.throwErrorOrGet(() -> super.getNft(address));
    }

    public List<AssetDetails> getNft(Address address, int limit) {
        return this.throwErrorOrGet(() -> super.getNft(address, limit));
    }

    public List<AssetDetails> getNft(Address address, int limit, AssetId after) {
        return this.throwErrorOrGet(() -> super.getNft(address, limit, after));
    }

    public BlockchainRewards getBlockchainRewards() {
        return this.throwErrorOrGet(() -> super.getBlockchainRewards());
    }

    public BlockchainRewards getBlockchainRewards(int height) {
        return this.throwErrorOrGet(() -> super.getBlockchainRewards(height));
    }

    public int getHeight() {
        return this.throwErrorOrGet(() -> super.getHeight());
    }

    public int getBlockHeight(Base58String blockId) {
        return this.throwErrorOrGet(() -> super.getBlockHeight(blockId));
    }

    public int getBlockHeight(long timestamp) {
        return this.throwErrorOrGet(() -> super.getBlockHeight(timestamp));
    }

    public int getBlocksDelay(Base58String startBlockId, int blocksNum) {
        return this.throwErrorOrGet(() -> super.getBlocksDelay(startBlockId, blocksNum));
    }

    public BlockHeaders getBlockHeaders(int height) {
        return this.throwErrorOrGet(() -> super.getBlockHeaders(height));
    }

    public BlockHeaders getBlockHeaders(Base58String blockId) {
        return this.throwErrorOrGet(() -> super.getBlockHeaders(blockId));
    }

    public List<BlockHeaders> getBlocksHeaders(int fromHeight, int toHeight) {
        return this.throwErrorOrGet(() -> super.getBlocksHeaders(fromHeight, toHeight));
    }

    public BlockHeaders getLastBlockHeaders() {
        return this.throwErrorOrGet(() -> super.getLastBlockHeaders());
    }

    public Block getBlock(int height) {
        return this.throwErrorOrGet(() -> super.getBlock(height));
    }

    public Block getBlock(Base58String blockId) {
        return this.throwErrorOrGet(() -> super.getBlock(blockId));
    }

    public List<Block> getBlocks(int fromHeight, int toHeight) {
        return this.throwErrorOrGet(() -> super.getBlocks(fromHeight, toHeight));
    }

    public Block getGenesisBlock() {
        return this.throwErrorOrGet(() -> super.getGenesisBlock());
    }

    public Block getLastBlock() {
        return this.throwErrorOrGet(() -> super.getLastBlock());
    }

    public List<Block> getBlocksGeneratedBy(Address generator, int fromHeight, int toHeight) {
        return this.throwErrorOrGet(() -> super.getBlocksGeneratedBy(generator, fromHeight, toHeight));
    }

    public String getVersion() {
        return this.throwErrorOrGet(() -> super.getVersion());
    }

    public List<HistoryBalance> getBalanceHistory(Address address) {
        return this.throwErrorOrGet(() -> super.getBalanceHistory(address));
    }

    public <T extends Transaction> Validation validateTransaction(T transaction) {
        return this.throwErrorOrGet(() -> super.validateTransaction(transaction));
    }

    public List<LeaseInfo> getActiveLeases(Address address) {
        return this.throwErrorOrGet(() -> super.getActiveLeases(address));
    }

    public LeaseInfo getLeaseInfo(Id leaseId) {
        return this.throwErrorOrGet(() -> super.getLeaseInfo(leaseId));
    }

    public List<LeaseInfo> getLeasesInfo(List<Id> leaseIds) {
        return this.throwErrorOrGet(() -> super.getLeasesInfo(leaseIds));
    }

    public List<LeaseInfo> getLeasesInfo(Id ... leaseIds) {
        return this.throwErrorOrGet(() -> super.getLeasesInfo(leaseIds));
    }

    public <T extends Transaction> Amount calculateTransactionFee(T transaction) {
        return this.throwErrorOrGet(() -> super.calculateTransactionFee(transaction));
    }

    public <T extends Transaction> T broadcast(T transaction) {
        return (T)this.throwErrorOrGet(() -> super.broadcast(transaction));
    }

    public TransactionInfo getTransactionInfo(Id txId) {
        return this.throwErrorOrGet(() -> super.getTransactionInfo(txId));
    }

    public <T extends TransactionInfo> T getTransactionInfo(Id txId, Class<T> transactionInfoClass) {
        return (T)this.throwErrorOrGet(() -> super.getTransactionInfo(txId, transactionInfoClass));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address) {
        return this.throwErrorOrGet(() -> super.getTransactionsByAddress(address));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address, int limit) {
        return this.throwErrorOrGet(() -> super.getTransactionsByAddress(address, limit));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address, int limit, Id afterTxId) {
        return this.throwErrorOrGet(() -> super.getTransactionsByAddress(address, limit, afterTxId));
    }

    public TransactionStatus getTransactionStatus(Id txId) {
        return this.throwErrorOrGet(() -> super.getTransactionStatus(txId));
    }

    public List<TransactionStatus> getTransactionsStatus(List<Id> txIds) {
        return this.throwErrorOrGet(() -> super.getTransactionsStatus(txIds));
    }

    public List<TransactionStatus> getTransactionsStatus(Id ... txIds) {
        return this.throwErrorOrGet(() -> super.getTransactionsStatus(txIds));
    }

    public Transaction getUnconfirmedTransaction(Id txId) {
        return this.throwErrorOrGet(() -> super.getUnconfirmedTransaction(txId));
    }

    public List<Transaction> getUnconfirmedTransactions() {
        return this.throwErrorOrGet(() -> super.getUnconfirmedTransactions());
    }

    public int getUtxSize() {
        return this.throwErrorOrGet(() -> super.getUtxSize());
    }

    public ScriptInfo compileScript(String source) {
        return this.throwErrorOrGet(() -> super.compileScript(source));
    }

    public ScriptInfo compileScript(String source, boolean enableCompaction) {
        return this.throwErrorOrGet(() -> super.compileScript(source, enableCompaction));
    }

    public TransactionInfo waitForTransaction(Id id, int waitingInSeconds) {
        return this.throwErrorOrGet(() -> super.waitForTransaction(id, waitingInSeconds));
    }

    public TransactionInfo waitForTransaction(Id id) {
        return this.throwErrorOrGet(() -> super.waitForTransaction(id));
    }

    public <T extends TransactionInfo> T waitForTransaction(Id id, Class<T> infoClass) {
        return (T)this.throwErrorOrGet(() -> super.waitForTransaction(id, infoClass));
    }

    public void waitForTransactions(List<Id> ids, int waitingInSeconds) {
        this.throwErrorOrGet(() -> {
            super.waitForTransactions(ids, waitingInSeconds);
            return true;
        });
    }

    public void waitForTransactions(List<Id> ids) {
        this.throwErrorOrGet(() -> {
            super.waitForTransactions(ids);
            return true;
        });
    }

    public void waitForTransactions(Id ... ids) {
        this.throwErrorOrGet(() -> {
            super.waitForTransactions(ids);
            return true;
        });
    }

    public int waitForHeight(int target, int waitingInSeconds) {
        return this.throwErrorOrGet(() -> super.waitForHeight(target, waitingInSeconds));
    }

    public int waitForHeight(int expectedHeight) {
        return this.throwErrorOrGet(() -> super.waitForHeight(expectedHeight));
    }

    public int waitBlocks(int blocksCount, int waitingInSeconds) {
        return this.throwErrorOrGet(() -> super.waitBlocks(blocksCount, waitingInSeconds));
    }

    public int waitBlocks(int blocksCount) {
        return this.throwErrorOrGet(() -> super.waitBlocks(blocksCount));
    }

    private static /* synthetic */ void lambda$maybeRunDockerContainer$1(DockerClient docker, String containerId) {
        try {
            if (docker.listContainers(new DockerClient.ListContainersParam[0]).stream().anyMatch(c -> c.id().equals(containerId))) {
                docker.killContainer(containerId);
                docker.removeContainer(containerId);
                docker.close();
            }
        }
        catch (DockerException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

