/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle.assertj;

import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.data.BinaryEntry;
import com.wavesplatform.transactions.data.BooleanEntry;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.transactions.data.DeleteEntry;
import com.wavesplatform.transactions.data.IntegerEntry;
import com.wavesplatform.transactions.data.StringEntry;
import com.wavesplatform.wavesj.AssetDetails;
import im.mak.paddle.Account;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class AccountAssert
extends AbstractAssert<AccountAssert, Account> {
    public AccountAssert(Account actual) {
        super((Object)actual, AccountAssert.class);
    }

    public static AccountAssert assertThat(Account actual) {
        return new AccountAssert(actual);
    }

    public AccountAssert hasNoData() {
        this.isNotNull();
        Assertions.assertThat(((Account)this.actual).getData()).isEmpty();
        return this;
    }

    public AccountAssert hasDataExactly(Consumer<DataEntries> expected) {
        this.isNotNull();
        DataEntries entries = new DataEntries();
        expected.accept(entries);
        Assertions.assertThat(((Account)this.actual).getData()).containsExactlyInAnyOrder((Object[])entries.dataEntries.toArray(new DataEntry[0]));
        return this;
    }

    public AccountAssert hasDataExactly(DataEntry ... expected) {
        return this.hasDataExactly((DataEntries de) -> {
            for (DataEntry entry : expected) {
                de.entry(entry);
            }
        });
    }

    public AccountAssert hasBalance(Amount expected) {
        this.isNotNull();
        long actualBalance = expected.assetId().isWaves() ? ((Account)this.actual).getWavesBalance() : ((Account)this.actual).getAssetBalance(expected.assetId());
        Assertions.assertThat((long)actualBalance).isEqualTo(expected.value());
        return this;
    }

    public AccountAssert hasAssetsExactly(Amount ... expected) {
        this.isNotNull();
        List balances = ((Account)this.actual).getAssetsBalance().stream().map(b -> Amount.of((long)b.balance(), (AssetId)b.assetId())).collect(Collectors.toList());
        Assertions.assertThat(balances).containsExactlyInAnyOrder((Object[])expected);
        return this;
    }

    public AccountAssert hasNftExactly(AssetId ... expected) {
        this.isNotNull();
        List nftList = ((Account)this.actual).getNft().stream().map(AssetDetails::assetId).collect(Collectors.toList());
        Assertions.assertThat(nftList).containsExactlyInAnyOrder((Object[])expected);
        return this;
    }

    public static class DataEntries {
        protected List<DataEntry> dataEntries = new ArrayList<DataEntry>();

        protected DataEntries() {
        }

        public DataEntries entry(DataEntry dataEntry) {
            this.dataEntries.add(dataEntry);
            return this;
        }

        public DataEntries binary(String key, Base64String value) {
            this.dataEntries.add((DataEntry)BinaryEntry.as((String)key, (Base64String)value));
            return this;
        }

        public DataEntries binary(String key, byte[] value) {
            this.dataEntries.add((DataEntry)BinaryEntry.as((String)key, (byte[])value));
            return this;
        }

        public DataEntries binary(String key, String value) {
            this.dataEntries.add((DataEntry)BinaryEntry.as((String)key, (String)value));
            return this;
        }

        public DataEntries bool(String key, boolean value) {
            this.dataEntries.add((DataEntry)BooleanEntry.as((String)key, (boolean)value));
            return this;
        }

        public DataEntries integer(String key, long value) {
            this.dataEntries.add((DataEntry)IntegerEntry.as((String)key, (long)value));
            return this;
        }

        public DataEntries string(String key, String value) {
            this.dataEntries.add((DataEntry)StringEntry.as((String)key, (String)value));
            return this;
        }

        public DataEntries delete(String key) {
            this.dataEntries.add((DataEntry)DeleteEntry.as((String)key));
            return this;
        }
    }
}

