/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle.assertj;

import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.data.BinaryEntry;
import com.wavesplatform.transactions.data.BooleanEntry;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.transactions.data.DeleteEntry;
import com.wavesplatform.transactions.data.IntegerEntry;
import com.wavesplatform.transactions.data.StringEntry;
import com.wavesplatform.wavesj.LeaseInfo;
import com.wavesplatform.wavesj.StateChanges;
import com.wavesplatform.wavesj.actions.BurnAction;
import com.wavesplatform.wavesj.actions.InvokeAction;
import com.wavesplatform.wavesj.actions.IssueAction;
import com.wavesplatform.wavesj.actions.ReissueAction;
import com.wavesplatform.wavesj.actions.ScriptTransfer;
import com.wavesplatform.wavesj.actions.SponsorFeeAction;
import im.mak.paddle.Account;
import im.mak.paddle.dapp.DAppCall;
import im.mak.paddle.util.RecipientResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class StateChangesAssert
extends AbstractAssert<StateChangesAssert, StateChanges> {
    public StateChangesAssert(StateChanges actual) {
        super((Object)actual, StateChangesAssert.class);
    }

    public static StateChangesAssert assertThat(StateChanges actual) {
        return new StateChangesAssert(actual);
    }

    public StateChangesAssert containsExactly(Consumer<StateChangesFields> expected) {
        this.isNotNull();
        StateChangesFields fields = new StateChangesFields();
        expected.accept(fields);
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThat((Optional)((StateChanges)this.actual).error()).isNotPresent(), () -> Assertions.assertThat((List)((StateChanges)this.actual).data()).containsExactlyInAnyOrder((Object[])((DataEntry[])fields.dataEntries.toArray(DataEntry[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).transfers()).containsExactlyInAnyOrder((Object[])((ScriptTransfer[])fields.transfers.toArray(ScriptTransfer[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).issues()).containsExactlyInAnyOrder((Object[])((IssueAction[])fields.issues.toArray(IssueAction[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).reissues()).containsExactlyInAnyOrder((Object[])((ReissueAction[])fields.reissues.toArray(ReissueAction[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).burns()).containsExactlyInAnyOrder((Object[])((BurnAction[])fields.burns.toArray(BurnAction[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).sponsorFees()).containsExactlyInAnyOrder((Object[])((SponsorFeeAction[])fields.sponsorFees.toArray(SponsorFeeAction[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).leases()).containsExactlyInAnyOrder((Object[])((LeaseInfo[])fields.leases.toArray(LeaseInfo[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).leaseCancels()).containsExactlyInAnyOrder((Object[])((LeaseInfo[])fields.leaseCancels.toArray(LeaseInfo[]::new))), () -> Assertions.assertThat((List)((StateChanges)this.actual).invokes()).containsExactlyInAnyOrder((Object[])((InvokeAction[])fields.invokes.toArray(InvokeAction[]::new)))});
        return this;
    }

    public static class StateChangesFields {
        protected List<DataEntry> dataEntries = new ArrayList<DataEntry>();
        protected List<ScriptTransfer> transfers = new ArrayList<ScriptTransfer>();
        protected List<IssueAction> issues = new ArrayList<IssueAction>();
        protected List<ReissueAction> reissues = new ArrayList<ReissueAction>();
        protected List<BurnAction> burns = new ArrayList<BurnAction>();
        protected List<SponsorFeeAction> sponsorFees = new ArrayList<SponsorFeeAction>();
        protected List<LeaseInfo> leases = new ArrayList<LeaseInfo>();
        protected List<LeaseInfo> leaseCancels = new ArrayList<LeaseInfo>();
        protected List<InvokeAction> invokes = new ArrayList<InvokeAction>();

        protected StateChangesFields() {
        }

        public StateChangesFields entry(DataEntry dataEntry) {
            this.dataEntries.add(dataEntry);
            return this;
        }

        public StateChangesFields binaryEntry(String key, Base64String value) {
            this.dataEntries.add((DataEntry)BinaryEntry.as((String)key, (Base64String)value));
            return this;
        }

        public StateChangesFields binaryEntry(String key, byte[] value) {
            this.dataEntries.add((DataEntry)BinaryEntry.as((String)key, (byte[])value));
            return this;
        }

        public StateChangesFields binaryEntry(String key, String value) {
            this.dataEntries.add((DataEntry)BinaryEntry.as((String)key, (String)value));
            return this;
        }

        public StateChangesFields booleanEntry(String key, boolean value) {
            this.dataEntries.add((DataEntry)BooleanEntry.as((String)key, (boolean)value));
            return this;
        }

        public StateChangesFields integerEntry(String key, long value) {
            this.dataEntries.add((DataEntry)IntegerEntry.as((String)key, (long)value));
            return this;
        }

        public StateChangesFields stringEntry(String key, String value) {
            this.dataEntries.add((DataEntry)StringEntry.as((String)key, (String)value));
            return this;
        }

        public StateChangesFields deleteEntry(String key) {
            this.dataEntries.add((DataEntry)DeleteEntry.as((String)key));
            return this;
        }

        public StateChangesFields transfer(Address to, Amount amount) {
            this.transfers.add(new ScriptTransfer((Recipient)to, amount));
            return this;
        }

        public StateChangesFields transfer(Account to, Amount amount) {
            return this.transfer(to.address(), amount);
        }

        public StateChangesFields invoke(DAppCall dAppCall, List<Amount> payments, StateChanges stateChanges) {
            this.invokes.add(new InvokeAction(RecipientResolver.toAddress(dAppCall.getDApp()), dAppCall.getFunction(), payments, stateChanges));
            return this;
        }

        public StateChangesFields invoke(DAppCall dAppCall, List<Amount> payments, Consumer<StateChangesFields> stateChanges) {
            StateChangesFields f = new StateChangesFields();
            stateChanges.accept(f);
            return this.invoke(dAppCall, payments, new StateChanges(f.dataEntries, f.transfers, f.issues, f.reissues, f.burns, f.sponsorFees, f.leases, f.leaseCancels, f.invokes, null));
        }

        public StateChangesFields invoke(DAppCall dAppCall, List<Amount> payments) {
            return this.invoke(dAppCall, payments, new StateChanges());
        }

        public StateChangesFields invoke(DAppCall dAppCall, Amount ... payments) {
            return this.invoke(dAppCall, Arrays.asList(payments));
        }

        public StateChangesFields invoke(DAppCall dAppCall, Amount payment, Consumer<StateChangesFields> stateChanges) {
            return this.invoke(dAppCall, Collections.singletonList(payment), stateChanges);
        }
    }
}

