/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;

public class Settings {
    public final String name;
    public final String apiUrl;
    public final long blockInterval;
    public final int minAssetInfoUpdateInterval;
    public final String faucetSeed;
    public final String dockerImage;
    public final boolean autoShutdown;

    public Settings(String apiUrl, long blockInterval, int minAssetInfoUpdateInterval, String faucetSeed, String dockerImage, boolean autoShutdown) {
        this.name = "manual";
        this.apiUrl = apiUrl;
        this.blockInterval = blockInterval;
        this.minAssetInfoUpdateInterval = minAssetInfoUpdateInterval;
        this.faucetSeed = faucetSeed;
        this.dockerImage = dockerImage;
        this.autoShutdown = autoShutdown;
    }

    public Settings(String apiUrl) {
        this(apiUrl, 60000L, 100000, null, null, false);
    }

    public Settings() {
        String base = "paddle";
        String rootPath = System.getProperty("user.dir") + "/" + base;
        Config overridden = ConfigFactory.parseFileAnySyntax((File)new File(rootPath)).withFallback((ConfigMergeable)ConfigFactory.load((String)base)).withFallback((ConfigMergeable)ConfigFactory.defaultReference());
        this.name = overridden.getString("paddle.profile");
        Config _conf = overridden.getObject("paddle." + this.name).toConfig();
        this.apiUrl = _conf.getString("api-url");
        this.blockInterval = _conf.hasPath("block-interval") ? _conf.getDuration("block-interval").toMillis() : 60000L;
        this.minAssetInfoUpdateInterval = _conf.hasPath("min-asset-info-update-interval") ? _conf.getInt("min-asset-info-update-interval") : 0;
        this.faucetSeed = _conf.hasPath("faucet-seed") ? _conf.getString("faucet-seed") : null;
        this.dockerImage = _conf.hasPath("docker-image") ? _conf.getString("docker-image") : null;
        this.autoShutdown = !_conf.hasPath("auto-shutdown") || _conf.getBoolean("auto-shutdown");
    }
}

