/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle.token;

import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.wavesj.BalanceDetails;
import im.mak.paddle.Account;
import im.mak.paddle.Node;
import im.mak.paddle.token.Token;
import im.mak.paddle.util.RecipientResolver;

public abstract class Waves
implements Token {
    private static final AssetId ID = AssetId.WAVES;
    private static final int DECIMALS = 8;
    public static final Waves WAVES = new Waves(){

        @Override
        public AssetId id() {
            return ID;
        }

        @Override
        public int decimals() {
            return 8;
        }

        @Override
        public long getQuantity() {
            return Node.node().getBlockchainRewards().totalWavesAmount();
        }

        @Override
        public long getBalanceOf(Recipient recipient) {
            return Node.node().getBalance(RecipientResolver.toAddress(recipient));
        }
    };

    private Waves() {
    }

    @Override
    public abstract AssetId id();

    @Override
    public abstract int decimals();

    @Override
    public abstract long getQuantity();

    @Override
    public abstract long getBalanceOf(Recipient var1);

    public BalanceDetails getBalanceDetailsOf(Recipient recipient) {
        return Node.node().getBalanceDetails(RecipientResolver.toAddress(recipient));
    }

    public BalanceDetails getBalanceDetailsOf(PrivateKey account) {
        return this.getBalanceDetailsOf((Recipient)account.address());
    }

    public BalanceDetails getBalanceDetailsOf(Account account) {
        return this.getBalanceDetailsOf(account.privateKey());
    }
}

