/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.crypto.Crypto;
import com.wavesplatform.transactions.BurnTransaction;
import com.wavesplatform.transactions.CreateAliasTransaction;
import com.wavesplatform.transactions.DataTransaction;
import com.wavesplatform.transactions.ExchangeTransaction;
import com.wavesplatform.transactions.InvokeScriptTransaction;
import com.wavesplatform.transactions.IssueTransaction;
import com.wavesplatform.transactions.LeaseCancelTransaction;
import com.wavesplatform.transactions.LeaseTransaction;
import com.wavesplatform.transactions.MassTransferTransaction;
import com.wavesplatform.transactions.ReissueTransaction;
import com.wavesplatform.transactions.SetAssetScriptTransaction;
import com.wavesplatform.transactions.SetScriptTransaction;
import com.wavesplatform.transactions.SponsorFeeTransaction;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.TransactionOrOrder;
import com.wavesplatform.transactions.TransferTransaction;
import com.wavesplatform.transactions.UpdateAssetInfoTransaction;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.data.BinaryEntry;
import com.wavesplatform.transactions.data.BooleanEntry;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.transactions.data.IntegerEntry;
import com.wavesplatform.transactions.data.StringEntry;
import com.wavesplatform.transactions.exchange.Order;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.wavesj.AssetBalance;
import com.wavesplatform.wavesj.AssetDetails;
import com.wavesplatform.wavesj.BalanceDetails;
import com.wavesplatform.wavesj.Block;
import com.wavesplatform.wavesj.Common;
import com.wavesplatform.wavesj.HistoryBalance;
import com.wavesplatform.wavesj.ScriptInfo;
import com.wavesplatform.wavesj.ScriptMeta;
import com.wavesplatform.wavesj.TransactionDebugInfo;
import im.mak.paddle.BurnParams;
import im.mak.paddle.CommonParams;
import im.mak.paddle.DataParams;
import im.mak.paddle.ExchangeParams;
import im.mak.paddle.InvokeScriptParams;
import im.mak.paddle.InvokeScriptParamsOptional;
import im.mak.paddle.IssueNftParams;
import im.mak.paddle.IssueParams;
import im.mak.paddle.MassTransferParams;
import im.mak.paddle.Node;
import im.mak.paddle.ReissueParams;
import im.mak.paddle.TransferParams;
import im.mak.paddle.UpdateAssetInfoParams;
import im.mak.paddle.api.TxInfo;
import im.mak.paddle.dapp.DAppCall;
import im.mak.paddle.token.Asset;
import im.mak.paddle.token.Token;
import im.mak.paddle.util.Script;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class Account {
    private final PrivateKey privateKey;

    public Account(PrivateKey privateKey, long initialWavesBalance) {
        this.privateKey = (PrivateKey)Common.notNull((Object)privateKey, (String)"Private key");
        if (initialWavesBalance > 0L) {
            Node.node().faucet().transfer(this, AssetId.WAVES, initialWavesBalance);
        }
    }

    public Account(PrivateKey privateKey) {
        this(privateKey, 0L);
    }

    public Account(String seedPhrase, long initialWavesBalance) {
        this(PrivateKey.fromSeed((String)seedPhrase), initialWavesBalance);
    }

    public Account(long initialWavesBalance) {
        this(Crypto.getRandomSeedPhrase(), initialWavesBalance);
    }

    public Account() {
        this(0L);
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public PublicKey publicKey() {
        return this.privateKey.publicKey();
    }

    public Address address() {
        return this.publicKey().address();
    }

    public ScriptInfo getScriptInfo() {
        return Node.node().getScriptInfo(this.address());
    }

    public ScriptMeta getScriptMeta() {
        return Node.node().getScriptMeta(this.address());
    }

    public long getWavesBalance() {
        return Node.node().getBalance(this.address());
    }

    public BalanceDetails getWavesBalanceDetails() {
        return Node.node().getBalanceDetails(this.address());
    }

    public List<HistoryBalance> getWavesBalanceHistory() {
        return Node.node().getBalanceHistory(this.address());
    }

    public List<LeaseTransaction> getActiveLeases() {
        return Node.node().getActiveLeases(this.address());
    }

    public List<AssetBalance> getAssetsBalance() {
        return Node.node().getAssetsBalance(this.address());
    }

    public long getAssetBalance(AssetId assetId) {
        return Node.node().getAssetBalance(this.address(), assetId);
    }

    public long getAssetBalance(Asset asset) {
        return this.getAssetBalance(asset.id());
    }

    public long getBalance(Token token) {
        return token.id().isWaves() ? this.getWavesBalance() : this.getAssetBalance((AssetId)token);
    }

    public List<AssetDetails> getNft(int limit, AssetId after) {
        return Node.node().getNft(this.address(), limit, after);
    }

    public List<AssetDetails> getNft(int limit, Asset after) {
        return this.getNft(limit, after.id());
    }

    public List<AssetDetails> getNft(int limit) {
        return Node.node().getNft(this.address(), limit);
    }

    public List<AssetDetails> getNft() {
        return Node.node().getNft(this.address());
    }

    public List<Alias> getAliases() {
        return Node.node().getAliasesByAddress(this.address());
    }

    public List<Block> getGeneratedBlocks(int fromHeight, int toHeight) {
        return Node.node().getBlocksGeneratedBy(this.address(), fromHeight, toHeight);
    }

    public List<DataEntry> getData() {
        return Node.node().getData(this.address());
    }

    public List<DataEntry> getData(List<String> keys) {
        return Node.node().getData(this.address(), keys);
    }

    public DataEntry getData(String key) {
        return Node.node().getData(this.address(), key);
    }

    public List<DataEntry> getData(Pattern regex) {
        return Node.node().getData(this.address(), regex);
    }

    public Base64String getBinaryData(String key) {
        return ((BinaryEntry)this.getData(key)).value();
    }

    public boolean getBooleanData(String key) {
        return ((BooleanEntry)this.getData(key)).value();
    }

    public long getIntegerData(String key) {
        return ((IntegerEntry)this.getData(key)).value();
    }

    public String getStringData(String key) {
        return ((StringEntry)this.getData(key)).value();
    }

    public List<TransactionDebugInfo> getTransactionsHistory() {
        return Node.node().getStateChangesByAddress(this.address());
    }

    public List<TransactionDebugInfo> getTransactionsHistory(int limit) {
        return Node.node().getStateChangesByAddress(this.address(), limit);
    }

    public List<TransactionDebugInfo> getTransactionsHistory(int limit, Id afterTxId) {
        return Node.node().getStateChangesByAddress(this.address(), limit, afterTxId);
    }

    public Proof signBytes(byte[] bytes) {
        return Proof.as((byte[])this.privateKey.sign(bytes));
    }

    public Account sign(TransactionOrOrder txOrOrder) {
        txOrOrder.addProof(this.privateKey());
        return this;
    }

    public <T extends TransactionOrOrder> T signAndGet(T tx) {
        return (T)tx.addProof(this.privateKey());
    }

    private static <T extends TransactionOrOrder> T signAndGet(List<Account> signers, T unsigned) {
        for (Account account : signers) {
            if (account == null) {
                unsigned.addProof(Proof.EMPTY);
                continue;
            }
            unsigned.addProof(account.privateKey());
        }
        return unsigned;
    }

    public TxInfo<IssueTransaction> issue(Consumer<IssueParams> params) {
        IssueParams ip = new IssueParams(this);
        params.accept(ip);
        if (ip.signers.size() == 0) {
            ip.signedBy(ip.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(ip.signers, (IssueTransaction)((IssueTransaction.IssueTransactionBuilder)((IssueTransaction.IssueTransactionBuilder)((IssueTransaction.IssueTransactionBuilder)IssueTransaction.builder((String)ip.name, (long)ip.quantity, (int)ip.decimals).description(ip.description).isReissuable(ip.reissuable).script(ip.compiledScript).sender(ip.sender.publicKey())).fee(Amount.of((long)ip.getFee(), (AssetId)ip.feeAssetId))).timestamp(ip.timestamp == 0L ? System.currentTimeMillis() : ip.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), IssueTransaction.class);
    }

    public TxInfo<IssueTransaction> issue() {
        return this.issue(opt -> {});
    }

    public TxInfo<IssueTransaction> issueNft(Consumer<IssueNftParams> params) {
        IssueNftParams ip = new IssueNftParams(this);
        params.accept(ip);
        if (ip.signers.size() == 0) {
            ip.signedBy(ip.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(ip.signers, (IssueTransaction)((IssueTransaction.IssueTransactionNFTBuilder)((IssueTransaction.IssueTransactionNFTBuilder)((IssueTransaction.IssueTransactionNFTBuilder)IssueTransaction.builderNFT((String)ip.name).description(ip.description).script(ip.compiledScript).sender(ip.sender.publicKey())).fee(Amount.of((long)ip.getFee(), (AssetId)ip.feeAssetId))).timestamp(ip.timestamp == 0L ? System.currentTimeMillis() : ip.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), IssueTransaction.class);
    }

    public TxInfo<IssueTransaction> issueNft() {
        return this.issueNft(i -> {});
    }

    public TxInfo<TransferTransaction> transfer(Recipient to, Amount amount, Consumer<TransferParams> params) {
        TransferParams tp = new TransferParams(this);
        params.accept(tp);
        if (tp.signers.size() == 0) {
            tp.signedBy(tp.sender);
        }
        tp.assetId(amount.assetId());
        Transaction signedTx = (Transaction)Account.signAndGet(tp.signers, (TransferTransaction)((TransferTransaction.TransferTransactionBuilder)((TransferTransaction.TransferTransactionBuilder)((TransferTransaction.TransferTransactionBuilder)TransferTransaction.builder((Recipient)to, (Amount)amount).attachment(tp.attachment).sender(tp.sender.publicKey())).fee(Amount.of((long)tp.getFee(), (AssetId)tp.feeAssetId))).timestamp(tp.timestamp == 0L ? System.currentTimeMillis() : tp.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), TransferTransaction.class);
    }

    public TxInfo<TransferTransaction> transfer(Account to, Amount amount, Consumer<TransferParams> params) {
        return this.transfer((Recipient)to.address(), amount, params);
    }

    public TxInfo<TransferTransaction> transfer(Account to, AssetId assetId, long amount, Consumer<TransferParams> params) {
        return this.transfer((Recipient)to.address(), Amount.of((long)amount, (AssetId)assetId), params);
    }

    public TxInfo<TransferTransaction> transfer(Recipient to, Amount amount) {
        return this.transfer(to, amount, (TransferParams opt) -> {});
    }

    public TxInfo<TransferTransaction> transfer(Account to, Amount amount) {
        return this.transfer((Recipient)to.address(), amount, (TransferParams opt) -> {});
    }

    public TxInfo<TransferTransaction> transfer(Account to, AssetId assetId, long amount) {
        return this.transfer((Recipient)to.address(), Amount.of((long)amount, (AssetId)assetId), (TransferParams opt) -> {});
    }

    public TxInfo<ReissueTransaction> reissue(Amount amount, Consumer<ReissueParams> params) {
        ReissueParams rp = new ReissueParams(this);
        params.accept(rp);
        if (rp.signers.size() == 0) {
            rp.signedBy(rp.sender);
        }
        rp.assetId(amount.assetId());
        Transaction signedTx = (Transaction)Account.signAndGet(rp.signers, (ReissueTransaction)((ReissueTransaction.ReissueTransactionBuilder)((ReissueTransaction.ReissueTransactionBuilder)((ReissueTransaction.ReissueTransactionBuilder)ReissueTransaction.builder((Amount)amount).reissuable(rp.reissuable).sender(rp.sender.publicKey())).fee(Amount.of((long)rp.getFee(), (AssetId)rp.feeAssetId))).timestamp(rp.timestamp == 0L ? System.currentTimeMillis() : rp.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), ReissueTransaction.class);
    }

    public TxInfo<ReissueTransaction> reissue(AssetId assetId, long amount, Consumer<ReissueParams> params) {
        return this.reissue(Amount.of((long)amount, (AssetId)assetId), params);
    }

    public TxInfo<ReissueTransaction> reissue(Amount amount) {
        return this.reissue(amount, opt -> {});
    }

    public TxInfo<ReissueTransaction> reissue(AssetId assetId, long amount) {
        return this.reissue(assetId, amount, opt -> {});
    }

    public TxInfo<BurnTransaction> burn(Amount amount, Consumer<CommonParams<?>> params) {
        BurnParams common = new BurnParams(this);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        common.assetId(amount.assetId());
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (BurnTransaction)((BurnTransaction.BurnTransactionBuilder)((BurnTransaction.BurnTransactionBuilder)((BurnTransaction.BurnTransactionBuilder)BurnTransaction.builder((Amount)amount).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), BurnTransaction.class);
    }

    public TxInfo<BurnTransaction> burn(AssetId assetId, long amount, Consumer<CommonParams<?>> params) {
        return this.burn(Amount.of((long)amount, (AssetId)assetId), params);
    }

    public TxInfo<BurnTransaction> burn(Amount amount) {
        return this.burn(amount, opt -> {});
    }

    public TxInfo<BurnTransaction> burn(AssetId assetId, long amount) {
        return this.burn(assetId, amount, opt -> {});
    }

    public TxInfo<ExchangeTransaction> exchange(Order order1, Order order2, long amount, long price, Consumer<ExchangeParams> params) {
        ExchangeParams ep = new ExchangeParams(this);
        params.accept(ep);
        if (ep.signers.size() == 0) {
            ep.signedBy(ep.sender);
        }
        ep.assetPair(order1.assetPair());
        Transaction signedTx = (Transaction)Account.signAndGet(ep.signers, (ExchangeTransaction)((ExchangeTransaction.ExchangeTransactionBuilder)((ExchangeTransaction.ExchangeTransactionBuilder)((ExchangeTransaction.ExchangeTransactionBuilder)ExchangeTransaction.builder((Order)order1, (Order)order2, (long)amount, (long)price, (long)ep.buyMatcherFee, (long)ep.sellMatcherFee).sender(ep.sender.publicKey())).fee(Amount.of((long)ep.getFee(), (AssetId)ep.feeAssetId))).timestamp(ep.timestamp == 0L ? System.currentTimeMillis() : ep.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), ExchangeTransaction.class);
    }

    public TxInfo<ExchangeTransaction> exchange(Order order1, Order order2, long amount, long price) {
        return this.exchange(order1, order2, amount, price, opt -> {});
    }

    public TxInfo<LeaseTransaction> lease(Recipient to, long amount, Consumer<CommonParams<?>> params) {
        CommonParams common = new CommonParams(this, 100000L);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (LeaseTransaction)((LeaseTransaction.LeaseTransactionBuilder)((LeaseTransaction.LeaseTransactionBuilder)((LeaseTransaction.LeaseTransactionBuilder)LeaseTransaction.builder((Recipient)to, (long)amount).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), LeaseTransaction.class);
    }

    public TxInfo<LeaseTransaction> lease(Recipient to, long amount) {
        return this.lease(to, amount, (CommonParams<?> opt) -> {});
    }

    public TxInfo<LeaseTransaction> lease(Account to, long amount, Consumer<CommonParams<?>> params) {
        return this.lease((Recipient)to.address(), amount, params);
    }

    public TxInfo<LeaseTransaction> lease(Account to, long amount) {
        return this.lease((Recipient)to.address(), amount, (CommonParams<?> opt) -> {});
    }

    public TxInfo<LeaseCancelTransaction> cancelLease(Id leaseId, Consumer<CommonParams<?>> params) {
        CommonParams common = new CommonParams(this, 100000L);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (LeaseCancelTransaction)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)LeaseCancelTransaction.builder((Id)leaseId).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), LeaseCancelTransaction.class);
    }

    public TxInfo<LeaseCancelTransaction> cancelLease(Id leaseId) {
        return this.cancelLease(leaseId, opt -> {});
    }

    public TxInfo<CreateAliasTransaction> createAlias(String alias, Consumer<CommonParams<?>> params) {
        CommonParams common = new CommonParams(this, 100000L);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (CreateAliasTransaction)((CreateAliasTransaction.CreateAliasTransactionBuilder)((CreateAliasTransaction.CreateAliasTransactionBuilder)((CreateAliasTransaction.CreateAliasTransactionBuilder)CreateAliasTransaction.builder((String)alias).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), CreateAliasTransaction.class);
    }

    public TxInfo<CreateAliasTransaction> createAlias(String alias) {
        return this.createAlias(alias, opt -> {});
    }

    public TxInfo<CreateAliasTransaction> createAlias(Alias alias) {
        return this.createAlias(alias.toString(), opt -> {});
    }

    public TxInfo<MassTransferTransaction> massTransfer(Consumer<MassTransferParams> params) {
        MassTransferParams mtp = new MassTransferParams(this);
        params.accept(mtp);
        if (mtp.signers.size() == 0) {
            mtp.signedBy(mtp.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(mtp.signers, (MassTransferTransaction)((MassTransferTransaction.MassTransferTransactionBuilder)((MassTransferTransaction.MassTransferTransactionBuilder)((MassTransferTransaction.MassTransferTransactionBuilder)MassTransferTransaction.builder(mtp.transfers).assetId(mtp.assetId).attachment(mtp.attachment).sender(mtp.sender.publicKey())).fee(Amount.of((long)mtp.getFee(), (AssetId)mtp.feeAssetId))).timestamp(mtp.timestamp == 0L ? System.currentTimeMillis() : mtp.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), MassTransferTransaction.class);
    }

    public TxInfo<DataTransaction> writeData(Consumer<DataParams> params) {
        DataParams dp = new DataParams(this);
        params.accept(dp);
        if (dp.signers.size() == 0) {
            dp.signedBy(dp.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(dp.signers, (DataTransaction)((DataTransaction.DataTransactionBuilder)((DataTransaction.DataTransactionBuilder)((DataTransaction.DataTransactionBuilder)DataTransaction.builder(dp.data).sender(dp.sender.publicKey())).fee(Amount.of((long)dp.getFee(), (AssetId)dp.feeAssetId))).timestamp(dp.timestamp == 0L ? System.currentTimeMillis() : dp.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), DataTransaction.class);
    }

    public TxInfo<SetScriptTransaction> setScript(Base64String compiledScript, Consumer<CommonParams<?>> params) {
        CommonParams common = new CommonParams(this, 1000000L);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (SetScriptTransaction)((SetScriptTransaction.SetScriptTransactionBuilder)((SetScriptTransaction.SetScriptTransactionBuilder)((SetScriptTransaction.SetScriptTransactionBuilder)SetScriptTransaction.builder((Base64String)compiledScript).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), SetScriptTransaction.class);
    }

    public TxInfo<SetScriptTransaction> setScript(String script, Consumer<CommonParams<?>> params) {
        return this.setScript(Node.node().compileScript(script).script(), params);
    }

    public TxInfo<SetScriptTransaction> setScript(Base64String compiledScript) {
        return this.setScript(compiledScript, (CommonParams<?> opt) -> {});
    }

    public TxInfo<SetScriptTransaction> setScript(String script) {
        return this.setScript(script, (CommonParams<?> opt) -> {});
    }

    public TxInfo<SponsorFeeTransaction> sponsorFee(AssetId assetId, long minFeeAmount, Consumer<CommonParams<?>> params) {
        CommonParams common = new CommonParams(this, 100000L);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (SponsorFeeTransaction)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)SponsorFeeTransaction.builder((AssetId)assetId, (long)minFeeAmount).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), SponsorFeeTransaction.class);
    }

    public TxInfo<SponsorFeeTransaction> sponsorFee(Amount amount, Consumer<CommonParams<?>> params) {
        return this.sponsorFee(amount.assetId(), amount.value(), params);
    }

    public TxInfo<SponsorFeeTransaction> sponsorFee(AssetId assetId, long minFeeAmount) {
        return this.sponsorFee(assetId, minFeeAmount, opt -> {});
    }

    public TxInfo<SponsorFeeTransaction> sponsorFee(Amount amount) {
        return this.sponsorFee(amount.assetId(), amount.value(), opt -> {});
    }

    public TxInfo<SetAssetScriptTransaction> setAssetScript(AssetId assetId, Base64String compiledScript, Consumer<CommonParams<?>> params) {
        CommonParams common = new CommonParams(this, 100000000L);
        params.accept(common);
        if (common.signers.size() == 0) {
            common.signedBy(common.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(common.signers, (SetAssetScriptTransaction)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)SetAssetScriptTransaction.builder((AssetId)assetId, (Base64String)compiledScript).sender(common.sender.publicKey())).fee(Amount.of((long)common.getFee(), (AssetId)common.feeAssetId))).timestamp(common.timestamp == 0L ? System.currentTimeMillis() : common.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), SetAssetScriptTransaction.class);
    }

    public TxInfo<SetAssetScriptTransaction> setAssetScript(AssetId assetId, String script, Consumer<CommonParams<?>> params) {
        return this.setAssetScript(assetId, Node.node().compileScript(Script.setAssetType(script)).script(), params);
    }

    public TxInfo<SetAssetScriptTransaction> setAssetScript(AssetId assetId, Base64String compiledScript) {
        return this.setAssetScript(assetId, compiledScript, (CommonParams<?> opt) -> {});
    }

    public TxInfo<SetAssetScriptTransaction> setAssetScript(AssetId assetId, String script) {
        return this.setAssetScript(assetId, script, (CommonParams<?> opt) -> {});
    }

    public TxInfo<InvokeScriptTransaction> invoke(Consumer<InvokeScriptParams> params) {
        InvokeScriptParams isp = new InvokeScriptParams(this);
        params.accept(isp);
        if (isp.signers.size() == 0) {
            isp.signedBy(isp.sender);
        }
        Transaction signedTx = (Transaction)Account.signAndGet(isp.signers, (InvokeScriptTransaction)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)InvokeScriptTransaction.builder((Recipient)isp.dApp, (Function)isp.functions).payments(isp.payments).sender(isp.sender.publicKey())).fee(Amount.of((long)isp.getFee(), (AssetId)isp.feeAssetId))).timestamp(isp.timestamp == 0L ? System.currentTimeMillis() : isp.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), InvokeScriptTransaction.class);
    }

    public TxInfo<InvokeScriptTransaction> invoke(DAppCall call, Consumer<InvokeScriptParamsOptional> params) {
        InvokeScriptParamsOptional ispOpt = new InvokeScriptParamsOptional(this);
        params.accept(ispOpt);
        return this.invoke(is -> ((InvokeScriptParamsOptional)is.dApp(call.getDApp()).function(call.getFunction()).payments(ispOpt.payments.toArray(new Amount[0])).additionalFee(ispOpt.additionalFee).feeAssetId(ispOpt.feeAssetId).timestamp(ispOpt.timestamp)).signedBy(ispOpt.signers.toArray(new Account[0])));
    }

    public TxInfo<InvokeScriptTransaction> invoke(DAppCall call, Amount ... payments) {
        return this.invoke(i -> i.dApp(call.getDApp()).function(call.getFunction()).payments(payments));
    }

    public TxInfo<UpdateAssetInfoTransaction> updateAssetInfo(AssetId assetId, String name, String description, Consumer<UpdateAssetInfoParams> params) {
        UpdateAssetInfoParams uap = new UpdateAssetInfoParams(this);
        params.accept(uap);
        if (uap.signers.size() == 0) {
            uap.signedBy(uap.sender);
        }
        uap.assetId(assetId);
        Transaction signedTx = (Transaction)Account.signAndGet(uap.signers, (UpdateAssetInfoTransaction)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)UpdateAssetInfoTransaction.builder((AssetId)assetId, (String)name, (String)description).sender(uap.sender.publicKey())).fee(Amount.of((long)uap.getFee(), (AssetId)uap.feeAssetId))).timestamp(uap.timestamp == 0L ? System.currentTimeMillis() : uap.timestamp)).getUnsigned());
        return Node.node().waitForTransaction(Node.node().broadcast(signedTx).id(), UpdateAssetInfoTransaction.class);
    }

    public TxInfo<UpdateAssetInfoTransaction> updateAssetInfo(AssetId assetId, String name, String description) {
        return this.updateAssetInfo(assetId, name, description, opt -> {});
    }
}

