/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.DataTransaction;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.data.BinaryEntry;
import com.wavesplatform.transactions.data.BooleanEntry;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.transactions.data.DeleteEntry;
import com.wavesplatform.transactions.data.IntegerEntry;
import com.wavesplatform.transactions.data.StringEntry;
import im.mak.paddle.Account;
import im.mak.paddle.CommonParams;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class DataParams
extends CommonParams<DataParams> {
    protected List<DataEntry> data = new LinkedList<DataEntry>();

    protected DataParams(Account sender) {
        super(sender, 100000L);
    }

    @Override
    protected long getFee() {
        long totalWavesFee = super.getFee();
        DataTransaction tx = (DataTransaction)((DataTransaction.DataTransactionBuilder)DataTransaction.builder(this.data).sender(this.sender.publicKey())).getUnsigned();
        int payloadSize = tx.toProtobuf().getTransaction().getDataTransaction().getSerializedSize();
        return totalWavesFee += (long)((payloadSize - 1) / 1024) * 100000L;
    }

    public DataParams binary(String key, Base64String value) {
        this.data.add((DataEntry)BinaryEntry.as((String)key, (Base64String)value));
        return this;
    }

    public DataParams binary(String key, byte[] value) {
        return this.binary(key, new Base64String(value));
    }

    public DataParams bool(String key, boolean value) {
        this.data.add((DataEntry)BooleanEntry.as((String)key, (boolean)value));
        return this;
    }

    public DataParams integer(String key, long value) {
        this.data.add((DataEntry)IntegerEntry.as((String)key, (long)value));
        return this;
    }

    public DataParams string(String key, String value) {
        this.data.add((DataEntry)StringEntry.as((String)key, (String)value));
        return this;
    }

    public DataParams delete(String key) {
        this.data.add((DataEntry)DeleteEntry.as((String)key));
        return this;
    }

    public DataParams data(DataEntry ... data) {
        this.data.addAll(Arrays.asList(data));
        return this;
    }
}

