/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.exchange.AssetPair;
import im.mak.paddle.Account;
import im.mak.paddle.CommonParams;
import im.mak.paddle.Node;

public class ExchangeParams
extends CommonParams<ExchangeParams> {
    protected AssetId amountAssetId;
    protected AssetId priceAssetId;
    protected long buyMatcherFee = 300000L;
    protected long sellMatcherFee = 300000L;

    protected ExchangeParams(Account sender) {
        super(sender, 300000L);
    }

    @Override
    protected long getFee() {
        long totalWavesFee = super.getFee();
        if (!this.amountAssetId.isWaves() && Node.node().getAssetDetails(this.amountAssetId).isScripted()) {
            totalWavesFee += 400000L;
        }
        if (!this.priceAssetId.isWaves() && Node.node().getAssetDetails(this.priceAssetId).isScripted()) {
            totalWavesFee += 400000L;
        }
        return totalWavesFee;
    }

    protected ExchangeParams assetPair(AssetPair assetPair) {
        this.amountAssetId = assetPair.left();
        this.priceAssetId = assetPair.right();
        return this;
    }

    public ExchangeParams buyMatcherFee(long value) {
        this.buyMatcherFee = value;
        return this;
    }

    public ExchangeParams sellMatcherFee(long value) {
        this.sellMatcherFee = value;
        return this;
    }
}

