/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import im.mak.paddle.Account;
import im.mak.paddle.CommonParams;
import im.mak.paddle.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InvokeScriptParamsOptional
extends CommonParams<InvokeScriptParamsOptional> {
    protected List<Amount> payments = new ArrayList<Amount>();

    protected InvokeScriptParamsOptional(Account sender) {
        super(sender, 500000L);
    }

    public InvokeScriptParamsOptional payments(Amount ... amount) {
        this.payments.addAll(Arrays.asList(amount));
        return this;
    }

    public InvokeScriptParamsOptional payment(AssetId assetId, long amount) {
        this.payments.add(Amount.of((long)amount, (AssetId)assetId));
        return this;
    }

    public InvokeScriptParamsOptional additionalFee(long amount, AssetId assetId) {
        this.feeAssetId = assetId;
        if (this.feeAssetId.isWaves()) {
            this.additionalFee = amount;
            return this;
        }
        long sponsoredMinFee = Node.node().getAssetDetails(this.feeAssetId).minSponsoredAssetFee();
        return this.additionalFee(amount * sponsoredMinFee);
    }

    public InvokeScriptParamsOptional additionalFee(Amount amount) {
        return this.additionalFee(amount.value(), amount.assetId());
    }

    @Override
    public InvokeScriptParamsOptional additionalFee(long amount) {
        return this.additionalFee(amount, this.feeAssetId);
    }

    public InvokeScriptParamsOptional feeAssetId(AssetId assetId) {
        this.feeAssetId = assetId;
        return this;
    }
}

