/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.wavesplatform.transactions.LeaseTransaction;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.wavesj.AssetBalance;
import com.wavesplatform.wavesj.AssetDetails;
import com.wavesplatform.wavesj.AssetDistribution;
import com.wavesplatform.wavesj.Balance;
import com.wavesplatform.wavesj.BalanceDetails;
import com.wavesplatform.wavesj.Block;
import com.wavesplatform.wavesj.BlockHeaders;
import com.wavesplatform.wavesj.BlockchainRewards;
import com.wavesplatform.wavesj.HistoryBalance;
import com.wavesplatform.wavesj.ScriptInfo;
import com.wavesplatform.wavesj.ScriptMeta;
import com.wavesplatform.wavesj.TransactionDebugInfo;
import com.wavesplatform.wavesj.TransactionInfo;
import com.wavesplatform.wavesj.TransactionStatus;
import com.wavesplatform.wavesj.Validation;
import com.wavesplatform.wavesj.exceptions.NodeException;
import im.mak.paddle.Account;
import im.mak.paddle.api.TxDebugInfo;
import im.mak.paddle.api.TxInfo;
import im.mak.paddle.exceptions.ApiError;
import im.mak.paddle.exceptions.NodeError;
import im.mak.paddle.internal.Settings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class Node
extends com.wavesplatform.wavesj.Node {
    private static Node instance;
    private final Settings conf = new Settings();
    private Account faucet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node node() {
        if (instance != null) return instance;
        Class<Node> clazz = Node.class;
        synchronized (Node.class) {
            if (instance != null) return instance;
            try {
                instance = new Node();
            }
            catch (IOException | URISyntaxException e) {
                throw new NodeError(e);
            }
            catch (NodeException e) {
                throw new ApiError(e.getErrorCode(), e.getMessage());
            }
            return instance;
        }
    }

    private Node() throws NodeException, IOException, URISyntaxException {
        super(Node.maybeRunDockerContainer());
    }

    private static String maybeRunDockerContainer() {
        Settings conf = new Settings();
        if (conf.dockerImage != null) {
            String containerId;
            DefaultDockerClient docker;
            try {
                docker = DefaultDockerClient.fromEnv().build();
                try {
                    docker.pull(conf.dockerImage);
                }
                catch (DockerException | InterruptedException throwable) {
                    // empty catch block
                }
                URL apiUrl = new URL(conf.apiUrl);
                int port = apiUrl.getPort() <= 0 ? 80 : apiUrl.getPort();
                HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
                portBindings.put("6869", Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)port)));
                HostConfig hostConfig = HostConfig.builder().portBindings(portBindings).build();
                ContainerConfig containerConfig = ContainerConfig.builder().hostConfig(hostConfig).image(conf.dockerImage).exposedPorts(new String[]{"6869"}).build();
                containerId = docker.createContainer(containerConfig).id();
                docker.startContainer(containerId);
                boolean isNodeReady = false;
                for (int repeat = 0; repeat < 60; ++repeat) {
                    try {
                        try {
                            com.wavesplatform.wavesj.Node node = new com.wavesplatform.wavesj.Node(conf.apiUrl);
                        }
                        catch (IOException | URISyntaxException e) {
                            throw new NodeError(e);
                        }
                        catch (NodeException e) {
                            throw new ApiError(e.getErrorCode(), e.getMessage());
                        }
                        isNodeReady = true;
                        break;
                    }
                    catch (ApiError | NodeError e) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (!isNodeReady) {
                    throw new NodeError("Could not wait for node readiness");
                }
            }
            catch (DockerCertificateException | DockerException | InterruptedException | MalformedURLException e) {
                throw new NodeError(e);
            }
            if (conf.autoShutdown) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Node.lambda$maybeRunDockerContainer$1((DockerClient)docker, containerId)));
            }
        }
        return conf.apiUrl;
    }

    private static <T> T throwErrorOrGet(Callable<T> mightThrowException) {
        try {
            return mightThrowException.call();
        }
        catch (IOException e) {
            throw new NodeError(e);
        }
        catch (NodeException e) {
            throw new ApiError(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int minAssetInfoUpdateInterval() {
        return this.conf.minAssetInfoUpdateInterval;
    }

    public Account faucet() {
        if (this.faucet == null) {
            this.faucet = new Account(PrivateKey.fromSeed((String)this.conf.faucetSeed));
        }
        return this.faucet;
    }

    public TransactionInfo waitForTransaction(Id id, int waitingInSeconds) {
        int pollingIntervalInMillis = 100;
        if (waitingInSeconds < 1) {
            throw new NodeError("waitForTransaction: waiting value must be positive. Current: " + waitingInSeconds);
        }
        for (long spentMillis = 0L; spentMillis < (long)waitingInSeconds * 1000L; spentMillis += (long)pollingIntervalInMillis) {
            try {
                return this.getTransactionInfo(id);
            }
            catch (ApiError | NodeError e) {
                try {
                    Thread.sleep(pollingIntervalInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new NodeError("Could not wait for transaction " + id + " in " + waitingInSeconds + " seconds");
    }

    public TransactionInfo waitForTransaction(Id id) {
        return this.waitForTransaction(id, (int)(this.conf.blockInterval / 1000L));
    }

    public <T extends Transaction> TxInfo<T> waitForTransaction(Id id, Class<T> txClass, int waitingInSeconds) {
        TransactionInfo info = this.waitForTransaction(id, waitingInSeconds);
        return new TxInfo(info.tx(), info.applicationStatus(), info.height());
    }

    public <T extends Transaction> TxInfo<T> waitForTransaction(Id id, Class<T> txClass) {
        TransactionInfo info = this.waitForTransaction(id);
        return new TxInfo(info.tx(), info.applicationStatus(), info.height());
    }

    public int waitForHeight(int target, int blockWaitingInSeconds) {
        int start;
        int prev = start = this.getHeight();
        int pollingIntervalInMillis = 100;
        if (blockWaitingInSeconds < 1) {
            throw new NodeError("waitForHeight: waiting value must be positive. Current: " + blockWaitingInSeconds);
        }
        for (long spentMillis = 0L; spentMillis < (long)blockWaitingInSeconds * 1000L; spentMillis += (long)pollingIntervalInMillis) {
            try {
                int current = this.getHeight();
                if (current >= target) {
                    return current;
                }
                if (current > prev) {
                    prev = current;
                    spentMillis = 0L;
                }
            }
            catch (ApiError | NodeError runtimeException) {
                // empty catch block
            }
            try {
                Thread.sleep(pollingIntervalInMillis);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new NodeError("Could not wait for the height to rise from " + start + " to " + target + ": height " + prev + " did not grow for " + blockWaitingInSeconds + " seconds");
    }

    public int waitForHeight(int expectedHeight) {
        return this.waitForHeight(expectedHeight, (int)(this.conf.blockInterval * 3L / 1000L));
    }

    public int waitNBlocks(int blocksCount, int blockWaitingInSeconds) {
        if (blockWaitingInSeconds < 1) {
            throw new NodeError("waitNBlocks: waiting value must be positive. Current: " + blockWaitingInSeconds);
        }
        return this.waitForHeight(this.getHeight() + blocksCount, blockWaitingInSeconds);
    }

    public int waitNBlocks(int blocksCount) {
        return this.waitNBlocks(blocksCount, (int)(this.conf.blockInterval * 3L / 1000L));
    }

    public <T extends Transaction> TxInfo<T> getTransactionInfo(Id txId, Class<T> txClass) {
        try {
            TransactionInfo info = super.getTransactionInfo(txId);
            return new TxInfo(info.tx(), info.applicationStatus(), info.height());
        }
        catch (IOException e) {
            throw new NodeError(e);
        }
        catch (NodeException e) {
            throw new ApiError(e.getErrorCode(), e.getMessage());
        }
    }

    public TxDebugInfo getStateChanges(Id txId) {
        return Node.throwErrorOrGet(() -> {
            TransactionDebugInfo info = super.getStateChanges(txId);
            return new TxDebugInfo(info.tx(), info.applicationStatus(), info.height(), info.stateChanges());
        });
    }

    public <T extends Transaction> T getUnconfirmedTransaction(Id txId, Class<T> txClass) {
        return (T)Node.throwErrorOrGet(() -> {
            Transaction tx = super.getUnconfirmedTransaction(txId);
            return tx;
        });
    }

    public List<Address> getAddresses() {
        return Node.throwErrorOrGet(() -> super.getAddresses());
    }

    public List<Address> getAddresses(int fromIndex, int toIndex) {
        return Node.throwErrorOrGet(() -> super.getAddresses(fromIndex, toIndex));
    }

    public long getBalance(Address address) {
        return Node.throwErrorOrGet(() -> super.getBalance(address));
    }

    public long getBalance(Address address, int confirmations) {
        return Node.throwErrorOrGet(() -> super.getBalance(address, confirmations));
    }

    public List<Balance> getBalances(List<Address> addresses) {
        return Node.throwErrorOrGet(() -> super.getBalances(addresses));
    }

    public List<Balance> getBalances(List<Address> addresses, int height) {
        return Node.throwErrorOrGet(() -> super.getBalances(addresses, height));
    }

    public BalanceDetails getBalanceDetails(Address address) {
        return Node.throwErrorOrGet(() -> super.getBalanceDetails(address));
    }

    public List<DataEntry> getData(Address address) {
        return Node.throwErrorOrGet(() -> super.getData(address));
    }

    public List<DataEntry> getData(Address address, List<String> keys) {
        return Node.throwErrorOrGet(() -> super.getData(address, keys));
    }

    public List<DataEntry> getData(Address address, Pattern regex) {
        return Node.throwErrorOrGet(() -> super.getData(address, regex));
    }

    public DataEntry getData(Address address, String key) {
        return Node.throwErrorOrGet(() -> super.getData(address, key));
    }

    public long getEffectiveBalance(Address address) {
        return Node.throwErrorOrGet(() -> super.getEffectiveBalance(address));
    }

    public long getEffectiveBalance(Address address, int confirmations) {
        return Node.throwErrorOrGet(() -> super.getEffectiveBalance(address, confirmations));
    }

    public ScriptInfo getScriptInfo(Address address) {
        return Node.throwErrorOrGet(() -> super.getScriptInfo(address));
    }

    public ScriptMeta getScriptMeta(Address address) {
        return Node.throwErrorOrGet(() -> super.getScriptMeta(address));
    }

    public List<Alias> getAliasesByAddress(Address address) {
        return Node.throwErrorOrGet(() -> super.getAliasesByAddress(address));
    }

    public Address getAddressByAlias(Alias alias) {
        return Node.throwErrorOrGet(() -> super.getAddressByAlias(alias));
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height) {
        return Node.throwErrorOrGet(() -> super.getAssetDistribution(assetId, height));
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height, int limit) {
        return Node.throwErrorOrGet(() -> super.getAssetDistribution(assetId, height, limit));
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height, int limit, Address after) {
        return Node.throwErrorOrGet(() -> super.getAssetDistribution(assetId, height, limit, after));
    }

    public List<AssetBalance> getAssetsBalance(Address address) {
        return Node.throwErrorOrGet(() -> super.getAssetsBalance(address));
    }

    public long getAssetBalance(Address address, AssetId assetId) {
        return Node.throwErrorOrGet(() -> super.getAssetBalance(address, assetId));
    }

    public AssetDetails getAssetDetails(AssetId assetId) {
        return Node.throwErrorOrGet(() -> super.getAssetDetails(assetId));
    }

    public List<AssetDetails> getAssetsDetails(List<AssetId> assetIds) {
        return Node.throwErrorOrGet(() -> super.getAssetsDetails(assetIds));
    }

    public List<AssetDetails> getNft(Address address) {
        return Node.throwErrorOrGet(() -> super.getNft(address));
    }

    public List<AssetDetails> getNft(Address address, int limit) {
        return Node.throwErrorOrGet(() -> super.getNft(address, limit));
    }

    public List<AssetDetails> getNft(Address address, int limit, AssetId after) {
        return Node.throwErrorOrGet(() -> super.getNft(address, limit, after));
    }

    public BlockchainRewards getBlockchainRewards() {
        return Node.throwErrorOrGet(() -> super.getBlockchainRewards());
    }

    public BlockchainRewards getBlockchainRewards(int height) {
        return Node.throwErrorOrGet(() -> super.getBlockchainRewards(height));
    }

    public int getHeight() {
        return Node.throwErrorOrGet(() -> super.getHeight());
    }

    public int getBlockHeight(Base58String blockId) {
        return Node.throwErrorOrGet(() -> super.getBlockHeight(blockId));
    }

    public int getBlocksDelay(Base58String startBlockId, int blocksNum) {
        return Node.throwErrorOrGet(() -> super.getBlocksDelay(startBlockId, blocksNum));
    }

    public BlockHeaders getBlockHeaders(int height) {
        return Node.throwErrorOrGet(() -> super.getBlockHeaders(height));
    }

    public BlockHeaders getBlockHeaders(Base58String blockId) {
        return Node.throwErrorOrGet(() -> super.getBlockHeaders(blockId));
    }

    public List<BlockHeaders> getBlocksHeaders(int fromHeight, int toHeight) {
        return Node.throwErrorOrGet(() -> super.getBlocksHeaders(fromHeight, toHeight));
    }

    public BlockHeaders getLastBlockHeaders() {
        return Node.throwErrorOrGet(() -> super.getLastBlockHeaders());
    }

    public Block getBlock(int height) {
        return Node.throwErrorOrGet(() -> super.getBlock(height));
    }

    public Block getBlock(Base58String blockId) {
        return Node.throwErrorOrGet(() -> super.getBlock(blockId));
    }

    public List<Block> getBlocks(int fromHeight, int toHeight) {
        return Node.throwErrorOrGet(() -> super.getBlocks(fromHeight, toHeight));
    }

    public Block getGenesisBlock() {
        return Node.throwErrorOrGet(() -> super.getGenesisBlock());
    }

    public Block getLastBlock() {
        return Node.throwErrorOrGet(() -> super.getLastBlock());
    }

    public List<Block> getBlocksGeneratedBy(Address generator, int fromHeight, int toHeight) {
        return Node.throwErrorOrGet(() -> super.getBlocksGeneratedBy(generator, fromHeight, toHeight));
    }

    public String getVersion() {
        return Node.throwErrorOrGet(() -> super.getVersion());
    }

    public List<HistoryBalance> getBalanceHistory(Address address) {
        return Node.throwErrorOrGet(() -> super.getBalanceHistory(address));
    }

    public List<TransactionDebugInfo> getStateChangesByAddress(Address address, int limit, Id afterTxId) {
        return Node.throwErrorOrGet(() -> super.getStateChangesByAddress(address, limit, afterTxId));
    }

    public List<TransactionDebugInfo> getStateChangesByAddress(Address address, int limit) {
        return Node.throwErrorOrGet(() -> super.getStateChangesByAddress(address, limit));
    }

    public List<TransactionDebugInfo> getStateChangesByAddress(Address address) {
        return Node.throwErrorOrGet(() -> super.getStateChangesByAddress(address));
    }

    public <T extends Transaction> Validation validateTransaction(T transaction) {
        return Node.throwErrorOrGet(() -> super.validateTransaction(transaction));
    }

    public List<LeaseTransaction> getActiveLeases(Address address) {
        return Node.throwErrorOrGet(() -> super.getActiveLeases(address));
    }

    public <T extends Transaction> Amount calculateTransactionFee(T transaction) {
        return Node.throwErrorOrGet(() -> super.calculateTransactionFee(transaction));
    }

    public <T extends Transaction> T broadcast(T transaction) {
        return (T)Node.throwErrorOrGet(() -> super.broadcast(transaction));
    }

    public TransactionInfo getTransactionInfo(Id txId) {
        return Node.throwErrorOrGet(() -> super.getTransactionInfo(txId));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address) {
        return Node.throwErrorOrGet(() -> super.getTransactionsByAddress(address));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address, int limit) {
        return Node.throwErrorOrGet(() -> super.getTransactionsByAddress(address, limit));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address, int limit, Id afterTxId) {
        return Node.throwErrorOrGet(() -> super.getTransactionsByAddress(address, limit, afterTxId));
    }

    public TransactionStatus getTransactionStatus(Id txId) {
        return Node.throwErrorOrGet(() -> super.getTransactionStatus(txId));
    }

    public List<TransactionStatus> getTransactionsStatus(List<Id> txIds) {
        return Node.throwErrorOrGet(() -> super.getTransactionsStatus(txIds));
    }

    public List<TransactionStatus> getTransactionsStatus(Id ... txIds) {
        return Node.throwErrorOrGet(() -> super.getTransactionsStatus(txIds));
    }

    public Transaction getUnconfirmedTransaction(Id txId) {
        return Node.throwErrorOrGet(() -> super.getUnconfirmedTransaction(txId));
    }

    public List<Transaction> getUnconfirmedTransactions() {
        return Node.throwErrorOrGet(() -> super.getUnconfirmedTransactions());
    }

    public int getUtxSize() {
        return Node.throwErrorOrGet(() -> super.getUtxSize());
    }

    public ScriptInfo compileScript(String source) {
        return Node.throwErrorOrGet(() -> super.compileScript(source));
    }

    private static /* synthetic */ void lambda$maybeRunDockerContainer$1(DockerClient docker, String containerId) {
        try {
            if (docker.listContainers(new DockerClient.ListContainersParam[0]).stream().anyMatch(c -> c.id().equals(containerId))) {
                docker.killContainer(containerId);
                docker.removeContainer(containerId);
                docker.close();
            }
        }
        catch (DockerException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

