/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle;

import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import im.mak.paddle.Account;
import im.mak.paddle.CommonParams;
import im.mak.paddle.Node;
import java.nio.charset.StandardCharsets;

public class TransferParams
extends CommonParams<TransferParams> {
    protected AssetId assetId = AssetId.WAVES;
    protected Base58String attachment = Base58String.empty();

    protected TransferParams(Account sender) {
        super(sender, 100000L);
        this.feeAssetId = AssetId.WAVES;
    }

    @Override
    protected long getFee() {
        long totalWavesFee = super.getFee();
        if (!this.assetId.isWaves() && Node.node().getAssetDetails(this.assetId).isScripted()) {
            totalWavesFee += 400000L;
        }
        if (this.feeAssetId.isWaves()) {
            return totalWavesFee;
        }
        long minSponsoredFee = Node.node().getAssetDetails(this.feeAssetId).minSponsoredAssetFee();
        long increment = totalWavesFee % 100000L == 0L ? 0L : minSponsoredFee;
        return totalWavesFee / 100000L * minSponsoredFee + increment;
    }

    protected TransferParams assetId(AssetId assetId) {
        this.assetId = assetId;
        return this;
    }

    public TransferParams attachment(Base58String message) {
        this.attachment = message;
        return this;
    }

    public TransferParams attachmentUtf8(String utf8Message) {
        return this.attachment(new Base58String(utf8Message.getBytes(StandardCharsets.UTF_8)));
    }

    public TransferParams additionalFee(long amount, AssetId assetId) {
        this.feeAssetId = assetId;
        if (this.feeAssetId.isWaves()) {
            this.additionalFee = amount;
            return this;
        }
        long sponsoredMinFee = Node.node().getAssetDetails(this.feeAssetId).minSponsoredAssetFee();
        return this.additionalFee(amount * sponsoredMinFee);
    }

    public TransferParams additionalFee(Amount amount) {
        return this.additionalFee(amount.value(), amount.assetId());
    }

    @Override
    public TransferParams additionalFee(long amount) {
        return this.additionalFee(amount, this.feeAssetId);
    }

    public TransferParams feeAssetId(AssetId assetId) {
        this.feeAssetId = assetId;
        return this;
    }
}

