/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;

public class Settings {
    public final String name;
    public final String apiUrl;
    public final char chainId;
    public final long blockInterval;
    public final int minAssetInfoUpdateInterval;
    public final String faucetSeed;
    public final String dockerImage;
    public final boolean autoShutdown;
    public final Config _conf;

    public Settings() {
        String base = "paddle";
        String rootPath = System.getProperty("user.dir") + "/" + base;
        Config overridden = ConfigFactory.parseFileAnySyntax((File)new File(rootPath)).withFallback((ConfigMergeable)ConfigFactory.load((String)base)).withFallback((ConfigMergeable)ConfigFactory.defaultReference());
        this.name = overridden.getString("paddle.profile");
        this._conf = overridden.getObject("paddle." + this.name).toConfig();
        this.apiUrl = this._conf.getString("api-url");
        this.chainId = this._conf.getString("chain-id").charAt(0);
        this.blockInterval = this._conf.getDuration("block-interval").toMillis();
        this.minAssetInfoUpdateInterval = this._conf.getInt("min-asset-info-update-interval");
        this.faucetSeed = this._conf.getString("faucet-seed");
        this.dockerImage = this._conf.hasPath("docker-image") ? this._conf.getString("docker-image") : null;
        this.autoShutdown = !this._conf.hasPath("auto-shutdown") || this._conf.getBoolean("auto-shutdown");
    }
}

