/*
 * Decompiled with CFR 0.152.
 */
package im.mak.paddle.token;

import com.wavesplatform.transactions.InvokeScriptTransaction;
import com.wavesplatform.transactions.IssueTransaction;
import com.wavesplatform.transactions.UpdateAssetInfoTransaction;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.wavesj.AssetDetails;
import com.wavesplatform.wavesj.AssetDistribution;
import com.wavesplatform.wavesj.StateChanges;
import com.wavesplatform.wavesj.TransactionInfo;
import com.wavesplatform.wavesj.actions.IssueAction;
import im.mak.paddle.Node;
import im.mak.paddle.token.Token;
import im.mak.paddle.util.RecipientResolver;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Asset
implements Token {
    private final AssetId id;
    private final int decimals;
    private final PublicKey issuer;
    private final TransactionInfo originTransactionInfo;
    private final boolean isNft;

    public Asset(AssetId assetId) {
        this.id = assetId;
        AssetDetails details = this.getDetails();
        this.decimals = details.decimals();
        this.issuer = details.issuerPublicKey();
        this.originTransactionInfo = Node.node().getTransactionInfo(details.originTransactionId());
        if (this.originTransactionInfo().tx() instanceof IssueTransaction) {
            IssueTransaction issue = (IssueTransaction)this.originTransactionInfo().tx();
            this.isNft = issue.quantity() == 1L && issue.decimals() == 0 && !issue.reissuable();
        } else if (this.originTransactionInfo().tx() instanceof InvokeScriptTransaction) {
            StateChanges stateChanges = Node.node().getStateChanges(this.originTransactionInfo().tx().id()).stateChanges();
            IssueAction issue = stateChanges.issues().stream().filter(i -> i.assetId().equals((Object)this.id)).findFirst().orElseThrow(IllegalStateException::new);
            this.isNft = issue.quantity() == 1L && issue.decimals() == 0 && !issue.isReissuable();
        } else {
            throw new IllegalStateException("Can't find transaction which issued asset \"" + this.id + "\"");
        }
    }

    @Override
    public AssetId id() {
        return this.id;
    }

    @Override
    public int decimals() {
        return this.decimals;
    }

    public PublicKey issuer() {
        return this.issuer;
    }

    public TransactionInfo originTransactionInfo() {
        return this.originTransactionInfo;
    }

    public boolean isNft() {
        return this.isNft;
    }

    public long amountSponsored(long wavesAmount) {
        long minSponsoredFee = this.getDetails().minSponsoredAssetFee();
        long increment = wavesAmount % 100000L == 0L ? 0L : minSponsoredFee;
        return wavesAmount / 100000L * minSponsoredFee + increment;
    }

    public Amount ofSponsored(long wavesAmount) {
        return Amount.of((long)this.amountSponsored(wavesAmount), (AssetId)this.id);
    }

    public AssetDetails getDetails() {
        return Node.node().getAssetDetails(this.id);
    }

    @Override
    public long getQuantity() {
        return this.getDetails().quantity();
    }

    @Override
    public long getBalanceOf(Recipient recipient) {
        return Node.node().getAssetBalance(RecipientResolver.toAddress(recipient), this.id);
    }

    public AssetDistribution getDistribution(int height, int limit, Address after) {
        return Node.node().getAssetDistribution(this.id, height, limit, after);
    }

    public AssetDistribution getDistribution(int height, int limit) {
        return Node.node().getAssetDistribution(this.id, height, limit);
    }

    public AssetDistribution getDistribution(int height) {
        return Node.node().getAssetDistribution(this.id, height);
    }

    public AssetDistribution getDistribution() {
        return Node.node().getAssetDistribution(this.id, Node.node().getHeight());
    }

    public int getNextHeightToUpdateInfo() {
        int listSize;
        int issueHeight = this.originTransactionInfo.height();
        int currentHeight = Node.node().getHeight();
        int oneIntervalAgoHeight = currentHeight - Node.node().minAssetInfoUpdateInterval();
        AtomicInteger lastUpdateHeight = new AtomicInteger();
        Id afterTx = null;
        do {
            List<TransactionInfo> txs = Node.node().getTransactionsByAddress(this.issuer.address(), 1000, afterTx);
            listSize = txs.size();
            if (txs.get(0).height() < oneIntervalAgoHeight) {
                return currentHeight;
            }
            txs.stream().filter(i -> i.tx() instanceof UpdateAssetInfoTransaction && ((UpdateAssetInfoTransaction)i.tx()).assetId().equals((Object)this.id)).findFirst().ifPresent(i -> lastUpdateHeight.set(i.height()));
            if (lastUpdateHeight.get() > 0) break;
            if (txs.get(listSize - 1).height() < issueHeight) {
                lastUpdateHeight.set(issueHeight);
                break;
            }
            afterTx = txs.get(listSize - 1).tx().id();
        } while (listSize == 1000);
        if (lastUpdateHeight.get() == 0) {
            throw new IllegalStateException("Can't find height at last update info of asset \"" + this.id + "\"");
        }
        return lastUpdateHeight.get() + Node.node().minAssetInfoUpdateInterval();
    }
}

