/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.clientauthutils;

import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.CredentialsCache;
import gov.nist.javax.sip.clientauthutils.MessageDigestAlgorithm;
import gov.nist.javax.sip.clientauthutils.UserCredentials;
import java.text.ParseException;
import java.util.Collection;
import java.util.ListIterator;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipSecurityManager {
    private static final Logger logger = Logger.getLogger(SipSecurityManager.class);
    private CredentialsCache cachedCredentials = new CredentialsCache();
    private AccountManager accountManager = null;
    private HeaderFactory headerFactory;

    public SipSecurityManager(AccountManager accountManager, HeaderFactory headerFactory) {
        this.accountManager = accountManager;
        this.headerFactory = headerFactory;
    }

    public ClientTransaction handleChallenge(Response challenge, ClientTransaction challengedTransaction, SipProvider transactionCreator) throws SipException, InvalidArgumentException, ParseException, NullPointerException {
        Request challengedRequest = challengedTransaction.getRequest();
        Request reoriginatedRequest = (Request)challengedRequest.clone();
        this.removeBranchID(reoriginatedRequest);
        if (challenge == null || reoriginatedRequest == null) {
            throw new NullPointerException("A null argument was passed to handle challenge.");
        }
        ListIterator authHeaders = null;
        if (challenge.getStatusCode() == 401) {
            authHeaders = challenge.getHeaders("WWW-Authenticate");
        } else if (challenge.getStatusCode() == 407) {
            authHeaders = challenge.getHeaders("Proxy-Authenticate");
        } else {
            throw new IllegalArgumentException("Unexpected status code ");
        }
        if (authHeaders == null) {
            throw new IllegalArgumentException("Could not find WWWAuthenticate or ProxyAuthenticate headers");
        }
        reoriginatedRequest.removeHeader("Authorization");
        reoriginatedRequest.removeHeader("Proxy-Authorization");
        CSeqHeader cSeq = (CSeqHeader)reoriginatedRequest.getHeader("CSeq");
        cSeq.setSeqNumber(cSeq.getSeqNumber() + 1L);
        ClientTransaction retryTran = transactionCreator.getNewClientTransaction(reoriginatedRequest);
        WWWAuthenticateHeader authHeader = null;
        while (authHeaders.hasNext()) {
            authHeader = (WWWAuthenticateHeader)authHeaders.next();
            String realm = authHeader.getRealm();
            UserCredentials userCreds = this.accountManager.getCredentials(realm);
            if (userCreds == null) {
                throw new SipException("Cannot find user creds for the given user name and realm");
            }
            AuthorizationHeader authorization = this.getAuthorization(reoriginatedRequest.getMethod(), reoriginatedRequest.getRequestURI().toString(), reoriginatedRequest.getContent() == null ? "" : new String(reoriginatedRequest.getRawContent()), authHeader, userCreds);
            logger.debug((Object)("Created authorization header: " + authorization.toString()));
            this.cachedCredentials.cacheAuthorizationHeader(userCreds.getSipDomain(), authorization);
            reoriginatedRequest.addHeader((Header)authorization);
        }
        logger.debug((Object)"Returning authorization transaction.");
        return retryTran;
    }

    private AuthorizationHeader getAuthorization(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, UserCredentials userCredentials) {
        String response = null;
        String qopList = authHeader.getQop();
        String qop = qopList != null ? "auth" : null;
        String nc_value = "00000001";
        String cnonce = "xyz";
        response = MessageDigestAlgorithm.calculateResponse(authHeader.getAlgorithm(), userCredentials.getUserName(), authHeader.getRealm(), userCredentials.getPassword(), authHeader.getNonce(), nc_value, cnonce, method, uri, requestBody, qop);
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? this.headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : this.headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(userCredentials.getUserName());
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to create an authorization header!");
        }
        return authorization;
    }

    private void removeBranchID(Request request) throws ParseException, InvalidArgumentException {
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        viaHeader.removeParameter("branch");
    }

    public Collection<AuthorizationHeader> getCachedAuthorizationHeaders(UserCredentials accountInfo, String userName) {
        return this.cachedCredentials.getCachedAuthorizationHeaders(accountInfo.getSipDomain(), userName);
    }
}

