/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RequireList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sip.message.Response;

public final class SIPResponse
extends SIPMessage
implements Response {
    protected StatusLine statusLine;

    public static String getReasonPhrase(int rc) {
        String retval = null;
        switch (rc) {
            case 100: {
                retval = "Trying";
                break;
            }
            case 180: {
                retval = "Ringing";
                break;
            }
            case 181: {
                retval = "Call is being forwarded";
                break;
            }
            case 182: {
                retval = "Queued";
                break;
            }
            case 183: {
                retval = "Session progress";
                break;
            }
            case 200: {
                retval = "OK";
                break;
            }
            case 202: {
                retval = "Accepted";
                break;
            }
            case 300: {
                retval = "Multiple choices";
                break;
            }
            case 301: {
                retval = "Moved permanently";
                break;
            }
            case 302: {
                retval = "Moved Temporarily";
                break;
            }
            case 305: {
                retval = "Use proxy";
                break;
            }
            case 380: {
                retval = "Alternative service";
                break;
            }
            case 400: {
                retval = "Bad request";
                break;
            }
            case 401: {
                retval = "Unauthorized";
                break;
            }
            case 402: {
                retval = "Payment required";
                break;
            }
            case 403: {
                retval = "Forbidden";
                break;
            }
            case 404: {
                retval = "Not found";
                break;
            }
            case 405: {
                retval = "Method not allowed";
                break;
            }
            case 406: {
                retval = "Not acceptable";
                break;
            }
            case 407: {
                retval = "Proxy Authentication required";
                break;
            }
            case 408: {
                retval = "Request timeout";
                break;
            }
            case 410: {
                retval = "Gone";
                break;
            }
            case 480: {
                retval = "Temporarily Unavailable";
                break;
            }
            case 413: {
                retval = "Request entity too large";
                break;
            }
            case 414: {
                retval = "Request-URI too large";
                break;
            }
            case 415: {
                retval = "Unsupported media type";
                break;
            }
            case 416: {
                retval = "Unsupported URI Scheme";
                break;
            }
            case 420: {
                retval = "Bad extension";
                break;
            }
            case 421: {
                retval = "Etension Required";
                break;
            }
            case 423: {
                retval = "Interval too brief";
                break;
            }
            case 481: {
                retval = "Call leg/Transaction does not exist";
                break;
            }
            case 482: {
                retval = "Loop detected";
                break;
            }
            case 483: {
                retval = "Too many hops";
                break;
            }
            case 484: {
                retval = "Address incomplete";
                break;
            }
            case 485: {
                retval = "Ambiguous";
                break;
            }
            case 486: {
                retval = "Busy here";
                break;
            }
            case 487: {
                retval = "Request Terminated";
                break;
            }
            case 488: {
                retval = "Not Accpetable here";
                break;
            }
            case 489: {
                retval = "Bad Event";
                break;
            }
            case 491: {
                retval = "Request Pending";
                break;
            }
            case 500: {
                retval = "Server Internal Error";
                break;
            }
            case 493: {
                retval = "Undecipherable";
                break;
            }
            case 501: {
                retval = "Not implemented";
                break;
            }
            case 502: {
                retval = "Bad gateway";
                break;
            }
            case 503: {
                retval = "Service unavailable";
                break;
            }
            case 504: {
                retval = "Gateway timeout";
                break;
            }
            case 505: {
                retval = "SIP version not supported";
                break;
            }
            case 513: {
                retval = "Message Too Large";
                break;
            }
            case 600: {
                retval = "Busy everywhere";
                break;
            }
            case 603: {
                retval = "Decline";
                break;
            }
            case 604: {
                retval = "Does not exist anywhere";
                break;
            }
            case 606: {
                retval = "Session Not acceptable";
                break;
            }
            case 412: {
                retval = "Conditional request failed";
                break;
            }
            default: {
                retval = "Unkown Reason";
            }
        }
        return retval;
    }

    public void setStatusCode(int statusCode) throws ParseException {
        if (statusCode < 100 || statusCode > 800) {
            throw new ParseException("bad status code", 0);
        }
        if (this.statusLine == null) {
            this.statusLine = new StatusLine();
        }
        this.statusLine.setStatusCode(statusCode);
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public void setReasonPhrase(String reasonPhrase) {
        if (reasonPhrase == null) {
            throw new IllegalArgumentException("Bad reason phrase");
        }
        if (this.statusLine == null) {
            this.statusLine = new StatusLine();
        }
        this.statusLine.setReasonPhrase(reasonPhrase);
    }

    public String getReasonPhrase() {
        if (this.statusLine == null || this.statusLine.getReasonPhrase() == null) {
            return "";
        }
        return this.statusLine.getReasonPhrase();
    }

    public static boolean isFinalResponse(int rc) {
        return rc >= 200 && rc < 700;
    }

    public boolean isFinalResponse() {
        return SIPResponse.isFinalResponse(this.statusLine.getStatusCode());
    }

    public void setStatusLine(StatusLine sl) {
        this.statusLine = sl;
    }

    public String debugDump() {
        String superstring = super.debugDump();
        this.stringRepresentation = "";
        this.sprint(SIPResponse.class.getCanonicalName());
        this.sprint("{");
        if (this.statusLine != null) {
            this.sprint(this.statusLine.debugDump());
        }
        this.sprint(superstring);
        this.sprint("}");
        return this.stringRepresentation;
    }

    public void checkHeaders() throws ParseException {
        if (this.getCSeq() == null) {
            throw new ParseException("CSeq Is missing ", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException("To Is missing ", 0);
        }
        if (this.getFrom() == null) {
            throw new ParseException("From Is missing ", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException("Via Is missing ", 0);
        }
        if (this.getCallId() == null) {
            throw new ParseException("Call-ID Is missing ", 0);
        }
        if (this.getStatusCode() > 699) {
            throw new ParseException("Unknown error code!" + this.getStatusCode(), 0);
        }
    }

    public String encode() {
        String retval = this.statusLine != null ? this.statusLine.encode() + super.encode() : super.encode();
        return retval;
    }

    public String encodeMessage() {
        String retval = this.statusLine != null ? this.statusLine.encode() + super.encodeSIPHeaders() : super.encodeSIPHeaders();
        return retval;
    }

    public LinkedList getMessageAsEncodedStrings() {
        LinkedList<String> retval = super.getMessageAsEncodedStrings();
        if (this.statusLine != null) {
            retval.addFirst(this.statusLine.encode());
        }
        return retval;
    }

    public Object clone() {
        SIPResponse retval = (SIPResponse)super.clone();
        if (this.statusLine != null) {
            retval.statusLine = (StatusLine)this.statusLine.clone();
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SIPResponse that = (SIPResponse)other;
        return this.statusLine.equals(that.statusLine) && super.equals(other);
    }

    public boolean match(Object matchObj) {
        if (matchObj == null) {
            return true;
        }
        if (!matchObj.getClass().equals(this.getClass())) {
            return false;
        }
        if (matchObj == this) {
            return true;
        }
        SIPResponse that = (SIPResponse)matchObj;
        StatusLine rline = that.statusLine;
        if (this.statusLine == null && rline != null) {
            return false;
        }
        if (this.statusLine == rline) {
            return super.match(matchObj);
        }
        return this.statusLine.match(that.statusLine) && super.match(matchObj);
    }

    public byte[] encodeAsBytes() {
        byte[] slbytes = null;
        if (this.statusLine != null) {
            try {
                slbytes = this.statusLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        byte[] superbytes = super.encodeAsBytes();
        byte[] retval = new byte[slbytes.length + superbytes.length];
        System.arraycopy(slbytes, 0, retval, 0, slbytes.length);
        System.arraycopy(superbytes, 0, retval, slbytes.length, superbytes.length);
        return retval;
    }

    public String getDialogId(boolean isServer) {
        CallID cid = (CallID)this.getCallId();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            if (to.getTag() != null) {
                retval.append(":");
                retval.append(to.getTag());
            }
        } else {
            if (to.getTag() != null) {
                retval.append(":");
                retval.append(to.getTag());
            }
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public String getDialogId(boolean isServer, String toTag) {
        CallID cid = (CallID)this.getCallId();
        From from = (From)this.getFrom();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
        } else {
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    private final void setBranch(Via via, String method) {
        String branch;
        if (method.equals("ACK")) {
            branch = this.statusLine.getStatusCode() >= 300 ? this.getTopmostVia().getBranch() : Utils.generateBranchId();
        } else if (method.equals("CANCEL")) {
            branch = this.getTopmostVia().getBranch();
        } else {
            return;
        }
        try {
            via.setBranch(branch);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getFirstLine() {
        if (this.statusLine == null) {
            return null;
        }
        return this.statusLine.encode();
    }

    public void setSIPVersion(String sipVersion) {
        this.statusLine.setSipVersion(sipVersion);
    }

    public String getSIPVersion() {
        return this.statusLine.getSipVersion();
    }

    public String toString() {
        if (this.statusLine == null) {
            return "";
        }
        return this.statusLine.encode() + super.encode();
    }

    public SIPRequest createRequest(SipUri requestURI, Via via, CSeq cseq, From from, To to) {
        SIPRequest newRequest = new SIPRequest();
        String method = cseq.getMethod();
        newRequest.setMethod(method);
        newRequest.setRequestURI(requestURI);
        this.setBranch(via, method);
        newRequest.setHeader(via);
        newRequest.setHeader(cseq);
        Iterator<SIPHeader> headerIterator = this.getHeaders();
        while (headerIterator.hasNext()) {
            SIPHeader nextHeader = headerIterator.next();
            if (SIPMessage.isResponseHeader(nextHeader) || nextHeader instanceof ViaList || nextHeader instanceof CSeq || nextHeader instanceof ContentType || nextHeader instanceof ContentLength || nextHeader instanceof RecordRouteList || nextHeader instanceof RequireList || nextHeader instanceof ContactList || nextHeader instanceof ContentLength) continue;
            if (nextHeader instanceof To) {
                nextHeader = to;
            } else if (nextHeader instanceof From) {
                nextHeader = from;
            }
            try {
                newRequest.attachHeader(nextHeader, false);
            }
            catch (SIPDuplicateHeaderException e) {
                e.printStackTrace();
            }
        }
        try {
            newRequest.attachHeader(new MaxForwards(70), false);
        }
        catch (Exception d) {
            // empty catch block
        }
        return newRequest;
    }
}

