/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.MultiHashMap;
import gov.nist.core.NameValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateNameValueList
implements Serializable {
    MultiHashMap m = new MultiHashMap();
    private String separator = ";";
    private static final long serialVersionUID = -5611332957903796952L;

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer buffer) {
        Iterator iterator;
        if (!this.m.isEmpty() && (iterator = this.m.values().iterator()).hasNext()) {
            while (true) {
                Object obj;
                if ((obj = iterator.next()) instanceof GenericObject) {
                    GenericObject gobj = (GenericObject)obj;
                    gobj.encode(buffer);
                } else {
                    buffer.append(obj.toString());
                }
                if (!iterator.hasNext()) break;
                buffer.append(this.separator);
            }
        }
        return buffer;
    }

    public String toString() {
        return this.encode();
    }

    public void set(NameValue nv) {
        this.m.put(nv.getName().toLowerCase(), nv);
    }

    public void set(String name, Object value) {
        NameValue nameValue = new NameValue(name, value);
        this.m.put(name.toLowerCase(), nameValue);
    }

    public boolean equals(Object otherObject) {
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        DuplicateNameValueList other = (DuplicateNameValueList)otherObject;
        if (this.m.size() != other.m.size()) {
            return false;
        }
        for (String key : this.m.keySet()) {
            Collection nv1 = this.getNameValue(key);
            Collection nv2 = (Collection)other.m.get(key);
            if (nv2 == null) {
                return false;
            }
            if (((Object)nv2).equals(nv1)) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String name) {
        Collection nv = this.getNameValue(name.toLowerCase());
        if (nv != null) {
            return nv;
        }
        return null;
    }

    public Collection getNameValue(String name) {
        return (Collection)this.m.get(name.toLowerCase());
    }

    public boolean hasNameValue(String name) {
        return this.m.containsKey(name.toLowerCase());
    }

    public boolean delete(String name) {
        String lcName = name.toLowerCase();
        if (this.m.containsKey(lcName)) {
            this.m.remove(lcName);
            return true;
        }
        return false;
    }

    public Object clone() {
        DuplicateNameValueList retval = new DuplicateNameValueList();
        retval.setSeparator(this.separator);
        Iterator it = this.m.values().iterator();
        while (it.hasNext()) {
            retval.set((NameValue)((NameValue)it.next()).clone());
        }
        return retval;
    }

    public Iterator<NameValue> iterator() {
        return this.m.values().iterator();
    }

    public Iterator<String> getNames() {
        return this.m.keySet().iterator();
    }

    public String getParameter(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey(key.toString().toLowerCase());
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public NameValue get(Object key) {
        return (NameValue)this.m.get(key);
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<String> keySet() {
        return this.m.keySet();
    }

    public NameValue put(String key, NameValue value) {
        return (NameValue)this.m.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends NameValue> t) {
        this.m.putAll(t);
    }

    public NameValue remove(Object key) {
        return (NameValue)this.m.remove(key);
    }

    public int size() {
        return this.m.size();
    }

    public Collection<NameValue> values() {
        return this.m.values();
    }
}

