/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.RAck;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Reason;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Require;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialogErrorEvent;
import gov.nist.javax.sip.stack.SIPDialogEventListener;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.OptionTag;
import javax.sip.header.RequireHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPDialog
implements Dialog,
DialogExt {
    private static final long serialVersionUID = -1429794423085204069L;
    private transient boolean dialogTerminatedEventDelivered;
    private transient String stackTrace;
    private String method;
    private transient boolean isAssigned;
    private boolean reInviteFlag;
    private transient Object applicationData;
    private transient SIPRequest originalRequest;
    private SIPResponse lastResponse;
    private transient SIPTransaction firstTransaction;
    private transient SIPTransaction lastTransaction;
    private String dialogId;
    private transient String earlyDialogId;
    private long localSequenceNumber = 0L;
    private long remoteSequenceNumber = -1L;
    protected String myTag;
    protected String hisTag;
    private RouteList routeList;
    private transient SIPTransactionStack sipStack;
    private int dialogState = -1;
    private transient SIPRequest lastAckSent;
    private SIPRequest lastAckReceived;
    protected transient boolean ackProcessed;
    protected transient DialogTimerTask timerTask;
    protected transient Long nextSeqno;
    private transient int retransmissionTicksLeft;
    private transient int prevRetransmissionTicks;
    private long originalLocalSequenceNumber;
    private transient int ackLine;
    public transient long auditTag = 0L;
    protected Address localParty;
    protected Address remoteParty;
    protected CallIdHeader callIdHeader;
    public static final int NULL_STATE = -1;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int TERMINATED_STATE = 3;
    private static final int DIALOG_LINGER_TIME = 8;
    private boolean serverTransactionFlag;
    private transient SipProviderImpl sipProvider;
    private boolean terminateOnBye = true;
    private transient boolean byeSent;
    private Address remoteTarget;
    private EventHeader eventHeader;
    private transient long lastInviteOkReceived;
    private transient Semaphore ackSem = new Semaphore(1);
    private transient int reInviteWaitTime = 100;
    private transient DialogDeleteTask dialogDeleteTask;
    private transient DialogDeleteIfNoAckSentTask dialogDeleteIfNoAckSentTask;
    private transient boolean isAcknowledged;
    private transient long highestSequenceNumberAcknowledged = -1L;
    private boolean isBackToBackUserAgent;
    private boolean sequenceNumberValidation = true;
    private transient Set<SIPDialogEventListener> eventListeners;
    private Semaphore timerTaskLock = new Semaphore(1);
    protected boolean firstTransactionSecure;
    protected boolean firstTransactionSeen;
    protected String firstTransactionMethod;
    protected String firstTransactionId;
    protected boolean firstTransactionIsServerTransaction;
    protected String firstTransactionMergeId;
    protected int firstTransactionPort = 5060;
    protected Contact contactHeader;

    private SIPDialog(SipProviderImpl provider) {
        this.routeList = new RouteList();
        this.sipProvider = provider;
        this.eventListeners = new CopyOnWriteArraySet<SIPDialogEventListener>();
    }

    private void recordStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        new Exception().printStackTrace(writer);
        this.stackTrace = stringWriter.getBuffer().toString();
    }

    public SIPDialog(SIPTransaction transaction) {
        this(transaction.getSipProvider());
        SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
        this.callIdHeader = sipRequest.getCallId();
        this.earlyDialogId = sipRequest.getDialogId(false);
        if (transaction == null) {
            throw new NullPointerException("Null tx");
        }
        this.sipStack = transaction.sipStack;
        this.sipProvider = transaction.getSipProvider();
        if (this.sipProvider == null) {
            throw new NullPointerException("Null Provider!");
        }
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
        this.addTransaction(transaction);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Creating a dialog : " + this);
            this.sipStack.getStackLogger().logDebug("provider port = " + this.sipProvider.getListeningPoint().getPort());
            this.sipStack.getStackLogger().logStackTrace();
        }
        this.addEventListener(this.sipStack);
    }

    public SIPDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        this(transaction);
        if (sipResponse == null) {
            throw new NullPointerException("Null SipResponse");
        }
        this.setLastResponse(transaction, sipResponse);
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
    }

    public SIPDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        this(sipProvider);
        this.sipStack = (SIPTransactionStack)sipProvider.getSipStack();
        this.setLastResponse(null, sipResponse);
        this.originalLocalSequenceNumber = this.localSequenceNumber = sipResponse.getCSeq().getSeqNumber();
        this.myTag = sipResponse.getFrom().getTag();
        this.hisTag = sipResponse.getTo().getTag();
        this.localParty = sipResponse.getFrom().getAddress();
        this.remoteParty = sipResponse.getTo().getAddress();
        this.method = sipResponse.getCSeq().getMethod();
        this.callIdHeader = sipResponse.getCallId();
        this.serverTransactionFlag = false;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Creating a dialog : " + this);
            this.sipStack.getStackLogger().logStackTrace();
        }
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
        this.addEventListener(this.sipStack);
    }

    private void printRouteList() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("this : " + this);
            this.sipStack.getStackLogger().logDebug("printRouteList : " + this.routeList.encode());
        }
    }

    private boolean isClientDialog() {
        SIPTransaction transaction = (SIPTransaction)this.getFirstTransaction();
        return transaction instanceof SIPClientTransaction;
    }

    private void raiseIOException(String host, int port, String protocol) {
        IOExceptionEvent ioError = new IOExceptionEvent((Object)this, host, port, protocol);
        this.sipProvider.handleEvent((EventObject)ioError, null);
        this.setState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseErrorEvent(int dialogTimeoutError) {
        SIPDialogErrorEvent newErrorEvent = new SIPDialogErrorEvent(this, dialogTimeoutError);
        Set<SIPDialogEventListener> set = this.eventListeners;
        synchronized (set) {
            for (SIPDialogEventListener nextListener : this.eventListeners) {
                nextListener.dialogErrorEvent(newErrorEvent);
            }
        }
        this.eventListeners.clear();
        if (dialogTimeoutError != 2 && dialogTimeoutError != 1 && dialogTimeoutError != 3) {
            this.delete();
        }
        this.stopTimer();
    }

    private void setRemoteParty(SIPMessage sipMessage) {
        this.remoteParty = !this.isServer() ? sipMessage.getTo().getAddress() : sipMessage.getFrom().getAddress();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("settingRemoteParty " + this.remoteParty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRoute(RecordRouteList recordRouteList) {
        try {
            AddressImpl address;
            Route route;
            RecordRoute rr;
            boolean addRoute;
            ListIterator li;
            if (this.isClientDialog()) {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator(recordRouteList.size());
                addRoute = true;
                while (li.hasPrevious()) {
                    rr = (RecordRoute)li.previous();
                    if (!addRoute) continue;
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress(address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            } else {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator();
                addRoute = true;
                while (li.hasNext()) {
                    rr = (RecordRoute)li.next();
                    if (!addRoute) continue;
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress(address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            }
            Object var8_7 = null;
            if (!this.sipStack.getStackLogger().isLoggingEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!this.sipStack.getStackLogger().isLoggingEnabled()) throw throwable;
            Iterator it = this.routeList.iterator();
            while (it.hasNext()) {
                SipURI sipUri = (SipURI)((Route)it.next()).getAddress().getURI();
                if (sipUri.hasLrParam() || !this.sipStack.isLoggingEnabled()) continue;
                this.sipStack.getStackLogger().logWarning("NON LR route in Route set detected for dialog : " + this);
                this.sipStack.getStackLogger().logStackTrace();
            }
            throw throwable;
        }
        Iterator it = this.routeList.iterator();
        while (it.hasNext()) {
            SipURI sipUri = (SipURI)((Route)it.next()).getAddress().getURI();
            if (sipUri.hasLrParam() || !this.sipStack.isLoggingEnabled()) continue;
            this.sipStack.getStackLogger().logWarning("NON LR route in Route set detected for dialog : " + this);
            this.sipStack.getStackLogger().logStackTrace();
        }
        return;
    }

    void setRemoteTarget(ContactHeader contact) {
        this.remoteTarget = contact.getAddress();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Dialog.setRemoteTarget: " + this.remoteTarget);
            this.sipStack.getStackLogger().logStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void addRoute(SIPResponse sipResponse) {
        block13: {
            block12: {
                block11: {
                    try {
                        ContactList contactList;
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("setContact: dialogState: " + this + "state = " + this.getState());
                        }
                        if (sipResponse.getStatusCode() == 100) {
                            Object var4_2 = null;
                            if (!this.sipStack.isLoggingEnabled()) return;
                            this.sipStack.getStackLogger().logStackTrace();
                            return;
                        }
                        if (this.dialogState == 3) {
                            break block11;
                        }
                        if (this.dialogState == 1) {
                            ContactList contactList2;
                            if (sipResponse.getStatusCode() / 100 == 2 && !this.isServer() && (contactList2 = sipResponse.getContactHeaders()) != null && SIPRequest.isTargetRefresh(sipResponse.getCSeq().getMethod())) {
                                this.setRemoteTarget((ContactHeader)contactList2.getFirst());
                            }
                            break block12;
                        }
                        if (this.isServer()) break block13;
                        if (this.getState() != DialogState.CONFIRMED && this.getState() != DialogState.TERMINATED) {
                            RecordRouteList rrlist = sipResponse.getRecordRouteHeaders();
                            if (rrlist != null) {
                                this.addRoute(rrlist);
                            } else {
                                this.routeList = new RouteList();
                            }
                        }
                        if ((contactList = sipResponse.getContactHeaders()) != null) {
                            this.setRemoteTarget((ContactHeader)contactList.getFirst());
                        }
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        if (!this.sipStack.isLoggingEnabled()) throw throwable;
                        this.sipStack.getStackLogger().logStackTrace();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.getStackLogger().logStackTrace();
                return;
            }
            Object var4_4 = null;
            if (!this.sipStack.isLoggingEnabled()) return;
            this.sipStack.getStackLogger().logStackTrace();
            return;
        }
        Object var4_5 = null;
        if (!this.sipStack.isLoggingEnabled()) return;
        this.sipStack.getStackLogger().logStackTrace();
    }

    private synchronized RouteList getRouteList() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("getRouteList " + this);
        }
        RouteList retval = new RouteList();
        retval = new RouteList();
        if (this.routeList != null) {
            ListIterator li = this.routeList.listIterator();
            while (li.hasNext()) {
                Route route = (Route)li.next();
                retval.add((Route)route.clone());
            }
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("----- ");
            this.sipStack.getStackLogger().logDebug("getRouteList for " + this);
            if (retval != null) {
                this.sipStack.getStackLogger().logDebug("RouteList = " + retval.encode());
            }
            if (this.routeList != null) {
                this.sipStack.getStackLogger().logDebug("myRouteList = " + this.routeList.encode());
            }
            this.sipStack.getStackLogger().logDebug("----- ");
        }
        return retval;
    }

    void setRouteList(RouteList routeList) {
        this.routeList = routeList;
    }

    private void sendAck(Request request, boolean throwIOExceptionAsSipException) throws SipException {
        SIPRequest ackRequest = (SIPRequest)request;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("sendAck" + this);
        }
        if (!ackRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (this.getState() == null || this.getState().getValue() == 0) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Bad Dialog State for " + this + " dialogID = " + this.getDialogId());
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("CallID " + this.getCallId());
                this.sipStack.getStackLogger().logError("RequestCallID = " + ackRequest.getCallId().getCallId());
                this.sipStack.getStackLogger().logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        try {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("setting from tag For outgoing ACK= " + this.getLocalTag());
                this.sipStack.getStackLogger().logDebug("setting To tag for outgoing ACK = " + this.getRemoteTag());
                this.sipStack.getStackLogger().logDebug("ack = " + ackRequest);
            }
            if (this.getLocalTag() != null) {
                ackRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                ackRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        Hop hop = this.sipStack.getNextHop(ackRequest);
        if (hop == null) {
            throw new SipException("No route!");
        }
        try {
            ListeningPointImpl lp;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("hop = " + hop);
            }
            if ((lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(hop.getTransport())) == null) {
                throw new SipException("No listening point for this provider registered at " + hop);
            }
            InetAddress inetAddress = InetAddress.getByName(hop.getHost());
            MessageChannel messageChannel = lp.getMessageProcessor().createMessageChannel(inetAddress, hop.getPort());
            boolean releaseAckSem = false;
            long cseqNo = ((SIPRequest)request).getCSeq().getSeqNumber();
            if (!this.isAckSent(cseqNo)) {
                releaseAckSem = true;
            }
            this.setLastAckSent(ackRequest);
            messageChannel.sendMessage(ackRequest);
            this.isAcknowledged = true;
            this.highestSequenceNumberAcknowledged = Math.max(this.highestSequenceNumberAcknowledged, ackRequest.getCSeq().getSeqNumber());
            if (releaseAckSem && this.isBackToBackUserAgent) {
                this.releaseAckSem();
            } else if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Not releasing ack sem for " + this + " isAckSent " + releaseAckSem);
            }
        }
        catch (IOException ex) {
            if (throwIOExceptionAsSipException) {
                throw new SipException("Could not send ack", (Throwable)ex);
            }
            this.raiseIOException(hop.getHost(), hop.getPort(), hop.getTransport());
        }
        catch (SipException ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        if (this.dialogDeleteTask != null) {
            this.dialogDeleteTask.cancel();
            this.dialogDeleteTask = null;
        }
    }

    void setStack(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    SIPTransactionStack getStack() {
        return this.sipStack;
    }

    boolean isTerminatedOnBye() {
        return this.terminateOnBye;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ackReceived(SIPRequest sipRequest) {
        if (this.isAckSeen()) {
            this.sipStack.getStackLogger().logDebug("Ack already seen for response -- dropping");
            return;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        if (tr != null) {
            if (tr.getCSeq() == sipRequest.getCSeq().getSeqNumber()) {
                this.acquireTimerTaskSem();
                try {
                    if (this.timerTask != null) {
                        this.timerTask.cancel();
                        this.timerTask = null;
                    }
                    Object var4_3 = null;
                    this.releaseTimerTaskSem();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.releaseTimerTaskSem();
                    throw throwable;
                }
                if (this.dialogDeleteTask != null) {
                    this.dialogDeleteTask.cancel();
                    this.dialogDeleteTask = null;
                }
                this.setLastAckReceived(sipRequest);
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("ackReceived for " + tr.getMethod());
                    this.ackLine = this.sipStack.getStackLogger().getLineCount();
                    this.printDebugInfo();
                }
                if (this.isBackToBackUserAgent) {
                    this.releaseAckSem();
                }
                this.setState(1);
            }
        } else {
            this.sipStack.getStackLogger().logDebug("tr is null -- not updating the ack state");
        }
    }

    synchronized boolean testAndSetIsDialogTerminatedEventDelivered() {
        boolean retval = this.dialogTerminatedEventDelivered;
        this.dialogTerminatedEventDelivered = true;
        return retval;
    }

    public void addEventListener(SIPDialogEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPDialogEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public synchronized void requestConsumed() {
        this.nextSeqno = this.getRemoteSeqNumber() + 1L;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Request Consumed -- next consumable Request Seqno = " + this.nextSeqno);
        }
    }

    public synchronized boolean isRequestConsumable(SIPRequest dialogRequest) {
        if (dialogRequest.getMethod().equals("ACK")) {
            throw new RuntimeException("Illegal method");
        }
        if (!this.isSequnceNumberValidation()) {
            return true;
        }
        return this.remoteSequenceNumber < dialogRequest.getCSeq().getSeqNumber();
    }

    public void doDeferredDelete() {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else {
            this.dialogDeleteTask = new DialogDeleteTask();
            this.sipStack.getTimer().schedule((TimerTask)this.dialogDeleteTask, 32000L);
        }
    }

    public void setState(int state) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Setting dialog state for " + this + "newState = " + state);
            this.sipStack.getStackLogger().logStackTrace();
            if (state != -1 && state != this.dialogState && this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug(this + "  old dialog state is " + this.getState());
                this.sipStack.getStackLogger().logDebug(this + "  New dialog state is " + DialogState.getObject((int)state));
            }
        }
        this.dialogState = state;
        if (state == 3) {
            if (this.sipStack.getTimer() != null) {
                this.sipStack.getTimer().schedule((TimerTask)new LingerTimer(), 8000L);
            }
            this.stopTimer();
        }
    }

    public void printDebugInfo() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("isServer = " + this.isServer());
            this.sipStack.getStackLogger().logDebug("localTag = " + this.getLocalTag());
            this.sipStack.getStackLogger().logDebug("remoteTag = " + this.getRemoteTag());
            this.sipStack.getStackLogger().logDebug("localSequenceNumer = " + this.getLocalSeqNumber());
            this.sipStack.getStackLogger().logDebug("remoteSequenceNumer = " + this.getRemoteSeqNumber());
            this.sipStack.getStackLogger().logDebug("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public boolean isAckSeen() {
        if (this.lastAckReceived == null && this.lastResponse.getStatusCode() == 200) {
            if (this.sipStack.getStackLogger().isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug(this + "lastAckReceived is null -- returning false");
            }
            return false;
        }
        if (this.lastResponse == null) {
            if (this.sipStack.getStackLogger().isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug(this + "lastResponse is null -- returning false");
            }
            return false;
        }
        if (this.lastAckReceived == null && this.lastResponse.getStatusCode() / 100 > 2) {
            if (this.sipStack.getStackLogger().isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug(this + "lastResponse statusCode " + this.lastResponse.getStatusCode());
            }
            return true;
        }
        return this.lastAckReceived != null && this.lastAckReceived.getCSeq().getSeqNumber() >= this.getRemoteSeqNumber();
    }

    public SIPRequest getLastAckSent() {
        return this.lastAckSent;
    }

    public boolean isAckSent(long cseqNo) {
        if (this.getLastTransaction() == null) {
            return true;
        }
        if (this.getLastTransaction() instanceof ClientTransaction) {
            if (this.getLastAckSent() == null) {
                return false;
            }
            return cseqNo <= this.getLastAckSent().getCSeq().getSeqNumber();
        }
        return true;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    public synchronized void addRoute(SIPRequest sipRequest) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("setContact: dialogState: " + this + "state = " + this.getState());
        }
        if (this.dialogState == 1 && SIPRequest.isTargetRefresh(sipRequest.getMethod())) {
            this.doTargetRefresh(sipRequest);
        }
        if (this.dialogState == 1 || this.dialogState == 3) {
            return;
        }
        if (sipRequest.getToTag() != null) {
            return;
        }
        RecordRouteList rrlist = sipRequest.getRecordRouteHeaders();
        if (rrlist != null) {
            this.addRoute(rrlist);
        } else {
            this.routeList = new RouteList();
        }
        ContactList contactList = sipRequest.getContactHeaders();
        if (contactList != null) {
            this.setRemoteTarget((ContactHeader)contactList.getFirst());
        }
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public static SIPDialog createFromNOTIFY(SIPClientTransaction subscribeTx, SIPTransaction notifyST) {
        SIPDialog d = new SIPDialog(notifyST);
        d.serverTransactionFlag = false;
        d.lastTransaction = subscribeTx;
        SIPDialog.storeFirstTransactionInfo(d, subscribeTx);
        d.terminateOnBye = false;
        d.localSequenceNumber = subscribeTx.getCSeq();
        SIPRequest not = (SIPRequest)notifyST.getRequest();
        d.remoteSequenceNumber = not.getCSeq().getSeqNumber();
        d.setDialogId(not.getDialogId(true));
        d.setLocalTag(not.getToTag());
        d.setRemoteTag(not.getFromTag());
        d.setLastResponse(subscribeTx, subscribeTx.getLastResponse());
        d.localParty = not.getTo().getAddress();
        d.remoteParty = not.getFrom().getAddress();
        d.addRoute(not);
        d.setState(1);
        return d;
    }

    public boolean isServer() {
        if (!this.firstTransactionSeen) {
            return this.serverTransactionFlag;
        }
        return this.firstTransactionIsServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.dialogId == null && this.lastResponse != null) {
            this.dialogId = this.lastResponse.getDialogId(this.isServer());
        }
        return this.dialogId;
    }

    private static void storeFirstTransactionInfo(SIPDialog dialog, SIPTransaction transaction) {
        dialog.firstTransaction = transaction;
        dialog.firstTransactionSeen = true;
        dialog.firstTransactionIsServerTransaction = transaction.isServerTransaction();
        dialog.firstTransactionSecure = transaction.getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips");
        dialog.firstTransactionPort = transaction.getPort();
        dialog.firstTransactionId = transaction.getBranchId();
        dialog.firstTransactionMethod = transaction.getMethod();
        if (transaction instanceof SIPServerTransaction && dialog.firstTransactionMethod.equals("INVITE")) {
            dialog.firstTransactionMergeId = ((SIPRequest)transaction.getRequest()).getMergeId();
        }
        if (dialog.isServer()) {
            SIPServerTransaction st = (SIPServerTransaction)transaction;
            SIPResponse response = st.getLastResponse();
            dialog.contactHeader = response != null ? response.getContactHeader() : null;
        } else {
            SIPClientTransaction ct = (SIPClientTransaction)transaction;
            if (ct != null) {
                SIPRequest sipRequest = ct.getOriginalRequest();
                dialog.contactHeader = sipRequest.getContactHeader();
            }
        }
    }

    public boolean addTransaction(SIPTransaction transaction) {
        SIPRequest sipRequest = transaction.getOriginalRequest();
        if (this.firstTransactionSeen && !this.firstTransactionId.equals(transaction.getBranchId()) && transaction.getMethod().equals(this.firstTransactionMethod)) {
            this.reInviteFlag = true;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("SipDialog.addTransaction() " + this + " transaction = " + transaction);
        }
        if (!this.firstTransactionSeen) {
            SIPDialog.storeFirstTransactionInfo(this, transaction);
            if (sipRequest.getMethod().equals("SUBSCRIBE")) {
                this.eventHeader = (EventHeader)sipRequest.getHeader("Event");
            }
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            if (this.originalRequest == null) {
                this.originalRequest = sipRequest;
            }
            if (this.method == null) {
                this.method = sipRequest.getMethod();
            }
            if (transaction instanceof SIPServerTransaction) {
                this.hisTag = sipRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeq().getSeqNumber());
                this.originalLocalSequenceNumber = this.localSequenceNumber;
                this.myTag = sipRequest.getFrom().getTag();
                if (this.myTag == null && this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logError("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (transaction.getMethod().equals(this.firstTransactionMethod) && this.firstTransactionIsServerTransaction != transaction.isServerTransaction()) {
            SIPDialog.storeFirstTransactionInfo(this, transaction);
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            this.originalRequest = sipRequest;
            this.method = sipRequest.getMethod();
        }
        if (transaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeq().getSeqNumber());
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("isBackToBackUserAgent = " + this.isBackToBackUserAgent);
        }
        this.lastTransaction = transaction;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            this.sipStack.getStackLogger().logDebug("TID = " + transaction.getTransactionId() + "/" + transaction.isServerTransaction());
            this.sipStack.getStackLogger().logStackTrace();
        }
        return true;
    }

    private void setRemoteTag(String hisTag) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("setRemoteTag(): " + this + " remoteTag = " + this.hisTag + " new tag = " + hisTag);
        }
        if (this.hisTag != null && hisTag != null && !hisTag.equals(this.hisTag)) {
            if (this.getState() != DialogState.EARLY) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Dialog is already established -- ignoring remote tag re-assignment");
                }
                return;
            }
            if (this.sipStack.isRemoteTagReassignmentAllowed()) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("UNSAFE OPERATION !  tag re-assignment " + this.hisTag + " trying to set to " + hisTag + " can cause unexpected effects ");
                }
                boolean removed = false;
                if (this.sipStack.getDialog(this.dialogId) == this) {
                    this.sipStack.removeDialog(this.dialogId);
                    removed = true;
                }
                this.dialogId = null;
                this.hisTag = hisTag;
                if (removed) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("ReInserting Dialog");
                    }
                    this.sipStack.putDialog(this);
                }
            }
        } else if (hisTag != null) {
            this.hisTag = hisTag;
        } else if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logWarning("setRemoteTag : called with null argument ");
        }
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        DialogTimerTask t = this.timerTask;
        if (t != null) {
            return t.transaction;
        }
        return null;
    }

    private void setLocalSequenceNumber(long lCseq) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("setLocalSequenceNumber: original  " + this.localSequenceNumber + " new  = " + lCseq);
        }
        if (lCseq <= this.localSequenceNumber) {
            throw new RuntimeException("Sequence number should not decrease !");
        }
        this.localSequenceNumber = lCseq;
    }

    public void setRemoteSequenceNumber(long rCseq) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("setRemoteSeqno " + this + "/" + rCseq);
        }
        this.remoteSequenceNumber = rCseq;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return (int)this.localSequenceNumber;
    }

    public long getOriginalLocalSequenceNumber() {
        return this.originalLocalSequenceNumber;
    }

    public long getLocalSeqNumber() {
        return this.localSequenceNumber;
    }

    public long getRemoteSeqNumber() {
        return this.remoteSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    private void setLocalTag(String mytag) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("set Local tag " + mytag + " " + this.dialogId);
            this.sipStack.getStackLogger().logStackTrace();
        }
        this.myTag = mytag;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sipRequest) {
        this.callIdHeader = sipRequest.getCallId();
    }

    public Address getLocalParty() {
        return this.localParty;
    }

    private void setLocalParty(SIPMessage sipMessage) {
        this.localParty = !this.isServer() ? sipMessage.getFrom().getAddress() : sipMessage.getTo().getAddress();
    }

    public Address getRemoteParty() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("gettingRemoteParty " + this.remoteParty);
        }
        return this.remoteParty;
    }

    public Address getRemoteTarget() {
        return this.remoteTarget;
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject((int)this.dialogState);
    }

    public boolean isSecure() {
        return this.firstTransactionSecure;
    }

    public void sendAck(Request request) throws SipException {
        this.sendAck(request, true);
    }

    public Request createRequest(String method) throws SipException {
        if (method.equals("ACK") || method.equals("PRACK")) {
            throw new SipException("Invalid method specified for createRequest:" + method);
        }
        if (this.lastResponse != null) {
            return this.createRequest(method, this.lastResponse);
        }
        throw new SipException("Dialog not yet established -- no response!");
    }

    private Request createRequest(String method, SIPResponse sipResponse) throws SipException {
        if (method == null || sipResponse == null) {
            throw new NullPointerException("null argument");
        }
        if (method.equals("CANCEL")) {
            throw new SipException("Dialog.createRequest(): Invalid request");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !method.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && method.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        SipUri sipUri = null;
        if (this.getRemoteTarget() != null) {
            sipUri = (SipUri)this.getRemoteTarget().getURI().clone();
        } else {
            sipUri = (SipUri)this.getRemoteParty().getURI().clone();
            sipUri.clearUriParms();
        }
        CSeq cseq = new CSeq();
        try {
            cseq.setMethod(method);
            cseq.setSeqNumber(this.getLocalSeqNumber());
        }
        catch (Exception ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Unexpected error");
            }
            InternalErrorHandler.handleException(ex);
        }
        ListeningPointImpl lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(sipResponse.getTopmostVia().getTransport());
        if (lp == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Cannot find listening point for transport " + sipResponse.getTopmostVia().getTransport());
            }
            throw new SipException("Cannot find listening point for transport " + sipResponse.getTopmostVia().getTransport());
        }
        Via via = lp.getViaHeader();
        From from = new From();
        from.setAddress(this.localParty);
        To to = new To();
        to.setAddress(this.remoteParty);
        SIPRequest sipRequest = sipResponse.createRequest(sipUri, via, cseq, from, to);
        if (SIPRequest.isTargetRefresh(method)) {
            ContactHeader contactHeader = ((ListeningPointImpl)this.sipProvider.getListeningPoint(lp.getTransport())).createContactHeader();
            ((SipURI)contactHeader.getAddress().getURI()).setSecure(this.isSecure());
            sipRequest.setHeader((Header)contactHeader);
        }
        try {
            cseq = (CSeq)sipRequest.getCSeq();
            cseq.setSeqNumber(this.localSequenceNumber + 1L);
        }
        catch (InvalidArgumentException ex) {
            InternalErrorHandler.handleException((Exception)((Object)ex));
        }
        if (method.equals("SUBSCRIBE") && this.eventHeader != null) {
            sipRequest.addHeader((Header)this.eventHeader);
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            } else {
                from.removeTag();
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            } else {
                to.removeTag();
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        this.updateRequest(sipRequest);
        return sipRequest;
    }

    public void sendRequest(ClientTransaction clientTransactionId) throws TransactionDoesNotExistException, SipException {
        this.sendRequest(clientTransactionId, !this.isBackToBackUserAgent);
    }

    public void sendRequest(ClientTransaction clientTransactionId, boolean allowInterleaving) throws TransactionDoesNotExistException, SipException {
        if (!allowInterleaving && clientTransactionId.getRequest().getMethod().equals("INVITE")) {
            this.sipStack.getReinviteExecutor().execute(new ReInviteSender(clientTransactionId));
            return;
        }
        SIPRequest dialogRequest = ((SIPClientTransaction)clientTransactionId).getOriginalRequest();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + dialogRequest);
        }
        if (clientTransactionId == null) {
            throw new NullPointerException("null parameter");
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (this.byeSent && this.isTerminatedOnBye() && !dialogRequest.getMethod().equals("BYE")) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("BYE already sent for " + this);
            }
            throw new SipException("Cannot send request; BYE already sent");
        }
        if (dialogRequest.getTopmostVia() == null) {
            Via via = ((SIPClientTransaction)clientTransactionId).getOutgoingViaHeader();
            dialogRequest.addHeader(via);
        }
        if (!this.getCallId().getCallId().equalsIgnoreCase(dialogRequest.getCallId().getCallId())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("CallID " + this.getCallId());
                this.sipStack.getStackLogger().logError("RequestCallID = " + dialogRequest.getCallId().getCallId());
                this.sipStack.getStackLogger().logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransactionId).setDialog(this, this.dialogId);
        this.addTransaction((SIPTransaction)clientTransactionId);
        ((SIPClientTransaction)clientTransactionId).isMapped = true;
        From from = (From)dialogRequest.getFrom();
        To to = (To)dialogRequest.getTo();
        if (this.getLocalTag() != null && from.getTag() != null && !from.getTag().equals(this.getLocalTag())) {
            throw new SipException("From tag mismatch expecting  " + this.getLocalTag());
        }
        if (this.getRemoteTag() != null && to.getTag() != null && !to.getTag().equals(this.getRemoteTag()) && this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logWarning("To header tag mismatch expecting " + this.getRemoteTag());
        }
        if (this.getLocalTag() == null && dialogRequest.getMethod().equals("NOTIFY")) {
            if (!this.getMethod().equals("SUBSCRIBE")) {
                throw new SipException("Trying to send NOTIFY without SUBSCRIBE Dialog!");
            }
            this.setLocalTag(from.getTag());
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Hop hop = ((SIPClientTransaction)clientTransactionId).getNextHop();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Using hop = " + hop.getHost() + " : " + hop.getPort());
        }
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.firstTransactionPort, hop);
            MessageChannel oldChannel = ((SIPClientTransaction)clientTransactionId).getMessageChannel();
            oldChannel.uncache();
            if (!this.sipStack.cacheClientConnections) {
                --oldChannel.useCount;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("oldChannel: useCount " + oldChannel.useCount);
                }
            }
            if (messageChannel == null) {
                Hop outboundProxy;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Null message channel using outbound proxy !");
                }
                if ((outboundProxy = this.sipStack.getRouter(dialogRequest).getOutboundProxy()) == null) {
                    throw new SipException("No route found! hop=" + hop);
                }
                messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(outboundProxy.getTransport()).getIPAddress(), this.firstTransactionPort, outboundProxy);
                if (messageChannel != null) {
                    ((SIPClientTransaction)clientTransactionId).setEncapsulatedChannel(messageChannel);
                }
            } else {
                ((SIPClientTransaction)clientTransactionId).setEncapsulatedChannel(messageChannel);
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("using message channel " + messageChannel);
                }
            }
            if (messageChannel != null) {
                ++messageChannel.useCount;
            }
            if (!this.sipStack.cacheClientConnections && oldChannel != null && oldChannel.useCount <= 0) {
                oldChannel.close();
            }
        }
        catch (Exception ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        try {
            ++this.localSequenceNumber;
            dialogRequest.getCSeq().setSeqNumber(this.getLocalSeqNumber());
        }
        catch (InvalidArgumentException ex) {
            this.sipStack.getStackLogger().logFatalError(ex.getMessage());
        }
        try {
            ((SIPClientTransaction)clientTransactionId).sendMessage(dialogRequest);
            if (dialogRequest.getMethod().equals("BYE")) {
                this.byeSent = true;
                if (this.isTerminatedOnBye()) {
                    this.setState(3);
                }
            }
        }
        catch (IOException ex) {
            throw new SipException("error sending message", (Throwable)ex);
        }
    }

    private boolean toRetransmitFinalResponse(int T2) {
        if (--this.retransmissionTicksLeft == 0) {
            this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks <= T2 ? 2 * this.prevRetransmissionTicks : this.prevRetransmissionTicks;
            this.prevRetransmissionTicks = this.retransmissionTicksLeft;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.getLastAckSent() != null) {
            if (this.getLastAckSent().getHeader("Timestamp") != null && this.sipStack.generateTimeStampHeader) {
                TimeStamp ts = new TimeStamp();
                try {
                    ts.setTimeStamp(System.currentTimeMillis());
                    this.getLastAckSent().setHeader(ts);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
            this.sendAck(this.getLastAckSent(), false);
        }
    }

    public String getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTimer(SIPServerTransaction transaction) {
        if (this.timerTask != null && this.timerTask.transaction == transaction) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Timer already running for " + this.getDialogId());
            }
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Starting dialog timer for " + this.getDialogId());
        }
        this.acquireTimerTaskSem();
        try {
            if (this.timerTask != null) {
                this.timerTask.transaction = transaction;
            } else {
                this.timerTask = new DialogTimerTask(transaction);
                this.sipStack.getTimer().schedule((TimerTask)this.timerTask, 500L, 500L);
            }
            Object var3_2 = null;
            this.releaseTimerTaskSem();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseTimerTaskSem();
            throw throwable;
        }
        this.setRetransmissionTicks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimer() {
        try {
            this.acquireTimerTaskSem();
            try {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                    this.timerTask = null;
                }
                Object var2_1 = null;
                this.releaseTimerTaskSem();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.releaseTimerTaskSem();
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request createPrack(Response relResponse) throws DialogDoesNotExistException, SipException {
        if (this.getState() == null || this.getState().equals((Object)DialogState.TERMINATED)) {
            throw new DialogDoesNotExistException("Dialog not initialized or terminated");
        }
        if ((RSeq)relResponse.getHeader("RSeq") == null) {
            throw new SipException("Missing RSeq Header");
        }
        try {
            SIPResponse sipResponse = (SIPResponse)relResponse;
            SIPRequest sipRequest = (SIPRequest)this.createRequest("PRACK", (SIPResponse)relResponse);
            String toHeaderTag = sipResponse.getTo().getTag();
            sipRequest.setToTag(toHeaderTag);
            RAck rack = new RAck();
            RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
            rack.setMethod(sipResponse.getCSeq().getMethod());
            rack.setCSequenceNumber((int)sipResponse.getCSeq().getSeqNumber());
            rack.setRSequenceNumber(rseq.getSeqNumber());
            sipRequest.setHeader(rack);
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    private void updateRequest(SIPRequest sipRequest) {
        RouteList rl = this.getRouteList();
        if (rl.size() > 0) {
            sipRequest.setHeader((Header)rl);
        } else {
            sipRequest.removeHeader("Route");
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            sipRequest.setHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
        }
    }

    public Request createAck(long cseqno) throws InvalidArgumentException, SipException {
        if (!this.method.equals("INVITE")) {
            throw new SipException("Dialog was not created with an INVITE" + this.method);
        }
        if (cseqno <= 0L) {
            throw new InvalidArgumentException("bad cseq <= 0 ");
        }
        if (cseqno > 0xFFFFFFFFL) {
            throw new InvalidArgumentException("bad cseq > 4294967295");
        }
        if (this.remoteTarget == null) {
            throw new SipException("Cannot create ACK - no remote Target!");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("createAck " + this + " cseqno " + cseqno);
        }
        if (this.lastInviteOkReceived < cseqno) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("WARNING : Attempt to crete ACK without OK " + this);
                this.sipStack.getStackLogger().logDebug("LAST RESPONSE = " + this.lastResponse);
            }
            throw new SipException("Dialog not yet established -- no OK response!");
        }
        try {
            Authorization authorization;
            NameValueList originalRequestParameters;
            ListeningPointImpl lp;
            SipURI uri4transport = null;
            if (this.routeList != null && !this.routeList.isEmpty()) {
                Route r = (Route)this.routeList.getFirst();
                uri4transport = (SipURI)r.getAddress().getURI();
            } else {
                uri4transport = (SipURI)this.remoteTarget.getURI();
            }
            String transport = uri4transport.getTransportParam();
            if (transport == null) {
                String string = transport = uri4transport.isSecure() ? "TLS" : "UDP";
            }
            if ((lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(transport)) == null) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logError("remoteTargetURI " + this.remoteTarget.getURI());
                    this.sipStack.getStackLogger().logError("uri4transport = " + uri4transport);
                    this.sipStack.getStackLogger().logError("No LP found for transport=" + transport);
                }
                throw new SipException("Cannot create ACK - no ListeningPoint for transport towards next hop found:" + transport);
            }
            SIPRequest sipRequest = new SIPRequest();
            sipRequest.setMethod("ACK");
            sipRequest.setRequestURI((SipUri)this.getRemoteTarget().getURI().clone());
            sipRequest.setCallId(this.callIdHeader);
            sipRequest.setCSeq(new CSeq(cseqno, "ACK"));
            ArrayList<Via> vias = new ArrayList<Via>();
            Via via = this.lastResponse.getTopmostVia();
            via.removeParameters();
            if (this.originalRequest != null && this.originalRequest.getTopmostVia() != null && (originalRequestParameters = this.originalRequest.getTopmostVia().getParameters()) != null && originalRequestParameters.size() > 0) {
                via.setParameters((NameValueList)originalRequestParameters.clone());
            }
            via.setBranch(Utils.getInstance().generateBranchId());
            vias.add(via);
            sipRequest.setVia(vias);
            From from = new From();
            from.setAddress(this.localParty);
            from.setTag(this.myTag);
            sipRequest.setFrom(from);
            To to = new To();
            to.setAddress(this.remoteParty);
            if (this.hisTag != null) {
                to.setTag(this.hisTag);
            }
            sipRequest.setTo(to);
            sipRequest.setMaxForwards(new MaxForwards(70));
            if (this.originalRequest != null && (authorization = this.originalRequest.getAuthorization()) != null) {
                sipRequest.setHeader(authorization);
            }
            this.updateRequest(sipRequest);
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            throw new SipException("unexpected exception ", (Throwable)ex);
        }
    }

    public SipProviderImpl getSipProvider() {
        return this.sipProvider;
    }

    public void setSipProvider(SipProviderImpl sipProvider) {
        this.sipProvider = sipProvider;
    }

    public void setResponseTags(SIPResponse sipResponse) {
        if (this.getLocalTag() != null || this.getRemoteTag() != null) {
            return;
        }
        String responseFromTag = sipResponse.getFromTag();
        if (responseFromTag != null) {
            if (responseFromTag.equals(this.getLocalTag())) {
                sipResponse.setToTag(this.getRemoteTag());
            } else if (responseFromTag.equals(this.getRemoteTag())) {
                sipResponse.setToTag(this.getLocalTag());
            }
        } else if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logWarning("No from tag in response! Not RFC 3261 compatible.");
        }
    }

    public void setLastResponse(SIPTransaction transaction, SIPResponse sipResponse) {
        this.callIdHeader = sipResponse.getCallId();
        int statusCode = sipResponse.getStatusCode();
        if (statusCode == 100) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logWarning("Invalid status code - 100 in setLastResponse - ignoring");
            }
            return;
        }
        this.lastResponse = sipResponse;
        this.setAssigned();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("sipDialog: setLastResponse:" + this + " lastResponse = " + this.lastResponse.getFirstLine());
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("sipDialog: setLastResponse -- dialog is terminated - ignoring ");
            }
            if (sipResponse.getCSeq().getMethod().equals("INVITE") && statusCode == 200) {
                this.lastInviteOkReceived = Math.max(sipResponse.getCSeq().getSeqNumber(), this.lastInviteOkReceived);
            }
            return;
        }
        String cseqMethod = sipResponse.getCSeq().getMethod();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logStackTrace();
            this.sipStack.getStackLogger().logDebug("cseqMethod = " + cseqMethod);
            this.sipStack.getStackLogger().logDebug("dialogState = " + this.getState());
            this.sipStack.getStackLogger().logDebug("method = " + this.getMethod());
            this.sipStack.getStackLogger().logDebug("statusCode = " + statusCode);
            this.sipStack.getStackLogger().logDebug("transaction = " + transaction);
        }
        if (transaction == null || transaction instanceof ClientTransaction) {
            if (SIPTransactionStack.isDialogCreated(cseqMethod)) {
                RecordRouteList rrList;
                if (this.getState() == null && statusCode / 100 == 1) {
                    this.setState(0);
                    if ((sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getRemoteTag() == null) {
                        this.setRemoteTag(sipResponse.getToTag());
                        this.setDialogId(sipResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sipResponse);
                    }
                } else if (this.getState() != null && this.getState().equals((Object)DialogState.EARLY) && statusCode / 100 == 1) {
                    if (cseqMethod.equals(this.getMethod()) && transaction != null && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported)) {
                        this.setRemoteTag(sipResponse.getToTag());
                        this.setDialogId(sipResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sipResponse);
                    }
                } else if (statusCode / 100 == 2) {
                    if (cseqMethod.equals(this.getMethod()) && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getState() != DialogState.CONFIRMED) {
                        this.setRemoteTag(sipResponse.getToTag());
                        this.setDialogId(sipResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sipResponse);
                        this.setState(1);
                    }
                    if (cseqMethod.equals("INVITE")) {
                        this.lastInviteOkReceived = Math.max(sipResponse.getCSeq().getSeqNumber(), this.lastInviteOkReceived);
                    }
                } else if (statusCode >= 300 && statusCode <= 699 && (this.getState() == null || cseqMethod.equals(this.getMethod()) && this.getState().getValue() == 0)) {
                    this.setState(3);
                }
                if (this.getState() != DialogState.CONFIRMED && this.getState() != DialogState.TERMINATED && this.originalRequest != null && (rrList = this.originalRequest.getRecordRouteHeaders()) != null) {
                    ListIterator it = rrList.listIterator(rrList.size());
                    while (it.hasPrevious()) {
                        RecordRoute rr = (RecordRoute)it.previous();
                        Route route = (Route)this.routeList.getFirst();
                        if (route != null && rr.getAddress().equals(route.getAddress())) {
                            this.routeList.removeFirst();
                            continue;
                        }
                        break;
                    }
                }
            } else if (cseqMethod.equals("NOTIFY") && (this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER")) && sipResponse.getStatusCode() / 100 == 2 && this.getState() == null) {
                this.setDialogId(sipResponse.getDialogId(true));
                this.sipStack.putDialog(this);
                this.setState(1);
            } else if (cseqMethod.equals("BYE") && statusCode / 100 == 2 && this.isTerminatedOnBye()) {
                this.setState(3);
            }
        } else if (cseqMethod.equals("BYE") && statusCode / 100 == 2 && this.isTerminatedOnBye()) {
            this.setState(3);
        } else {
            boolean doPutDialog = false;
            if (this.getLocalTag() == null && sipResponse.getTo().getTag() != null) {
                if (SIPTransactionStack.isDialogCreated(cseqMethod) && cseqMethod.equals(this.getMethod())) {
                    this.setLocalTag(sipResponse.getTo().getTag());
                    doPutDialog = true;
                }
            }
            if (statusCode / 100 != 2) {
                if (statusCode / 100 == 1) {
                    if (doPutDialog) {
                        this.setState(0);
                        this.setDialogId(sipResponse.getDialogId(true));
                        this.sipStack.putDialog(this);
                    }
                } else if (statusCode == 489 && (cseqMethod.equals("NOTIFY") || cseqMethod.equals("SUBSCRIBE"))) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("RFC 3265 : Not setting dialog to TERMINATED for 489");
                    }
                } else if (!this.isReInvite() && this.getState() != DialogState.CONFIRMED) {
                    this.setState(3);
                }
            } else {
                if (this.dialogState <= 0 && (cseqMethod.equals("INVITE") || cseqMethod.equals("SUBSCRIBE") || cseqMethod.equals("REFER"))) {
                    this.setState(1);
                }
                if (doPutDialog) {
                    this.setDialogId(sipResponse.getDialogId(true));
                    this.sipStack.putDialog(this);
                }
                if (transaction.getState() != TransactionState.TERMINATED && sipResponse.getStatusCode() == 200 && cseqMethod.equals("INVITE") && this.isBackToBackUserAgent && !this.takeAckSem()) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("Delete dialog -- cannot acquire ackSem");
                    }
                    this.delete();
                    return;
                }
            }
        }
    }

    public void startRetransmitTimer(SIPServerTransaction sipServerTx, Response response) {
        if (this.sipStack.getStackLogger().isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("startRetransmitTimer() " + response.getStatusCode() + " method " + sipServerTx.getRequest().getMethod());
        }
        if (sipServerTx.getRequest().getMethod().equals("INVITE") && response.getStatusCode() / 100 == 2) {
            this.startTimer(sipServerTx);
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    private void doTargetRefresh(SIPMessage sipMessage) {
        ContactList contactList = sipMessage.getContactHeaders();
        if (contactList != null) {
            Contact contact = (Contact)contactList.getFirst();
            this.setRemoteTarget(contact);
        }
    }

    private static final boolean optionPresent(ListIterator l, String option) {
        while (l.hasNext()) {
            OptionTag opt = (OptionTag)l.next();
            if (opt == null || !option.equalsIgnoreCase(opt.getOptionTag())) continue;
            return true;
        }
        return false;
    }

    public Response createReliableProvisionalResponse(int statusCode) throws InvalidArgumentException, SipException {
        if (!this.firstTransactionIsServerTransaction) {
            throw new SipException("Not a Server Dialog!");
        }
        if (statusCode <= 100 || statusCode > 199) {
            throw new InvalidArgumentException("Bad status code ");
        }
        SIPRequest request = this.originalRequest;
        if (!request.getMethod().equals("INVITE")) {
            throw new SipException("Bad method");
        }
        ListIterator<SIPHeader> list = request.getHeaders("Supported");
        if (!(list != null && SIPDialog.optionPresent(list, "100rel") || (list = request.getHeaders("Require")) != null && SIPDialog.optionPresent(list, "100rel"))) {
            throw new SipException("No Supported/Require 100rel header in the request");
        }
        SIPResponse response = request.createResponse(statusCode);
        Require require = new Require();
        try {
            require.setOptionTag("100rel");
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
        response.addHeader(require);
        RSeq rseq = new RSeq();
        rseq.setSeqNumber(1L);
        RecordRouteList rrl = request.getRecordRouteHeaders();
        if (rrl != null) {
            RecordRouteList rrlclone = (RecordRouteList)rrl.clone();
            response.setHeader((Header)rrlclone);
        }
        return response;
    }

    public boolean handlePrack(SIPRequest prackRequest) {
        if (!this.isServer()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping Prack -- not a server Dialog");
            }
            return false;
        }
        SIPServerTransaction sipServerTransaction = (SIPServerTransaction)this.getFirstTransaction();
        SIPResponse sipResponse = sipServerTransaction.getReliableProvisionalResponse();
        if (sipResponse == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping Prack -- ReliableResponse not found");
            }
            return false;
        }
        RAck rack = (RAck)prackRequest.getHeader("RAck");
        if (rack == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping Prack -- rack header not found");
            }
            return false;
        }
        CSeq cseq = (CSeq)sipResponse.getCSeq();
        if (!rack.getMethod().equals(cseq.getMethod())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rack.getCSeqNumberLong() != cseq.getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        RSeq rseq = (RSeq)sipResponse.getHeader("RSeq");
        if (rack.getRSequenceNumber() != rseq.getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping Prack -- RSeq Header does not match PRACK");
            }
            return false;
        }
        return sipServerTransaction.prackRecieved();
    }

    public void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (!this.isServer()) {
            throw new SipException("Not a Server Dialog");
        }
        SIPResponse sipResponse = (SIPResponse)relResponse;
        if (relResponse.getStatusCode() == 100) {
            throw new SipException("Cannot send 100 as a reliable provisional response");
        }
        if (relResponse.getStatusCode() / 100 > 2) {
            throw new SipException("Response code is not a 1xx response - should be in the range 101 to 199 ");
        }
        if (sipResponse.getToTag() == null) {
            throw new SipException("Badly formatted response -- To tag mandatory for Reliable Provisional Response");
        }
        ListIterator requireList = relResponse.getHeaders("Require");
        boolean found = false;
        if (requireList != null) {
            while (requireList.hasNext() && !found) {
                RequireHeader rh = (RequireHeader)requireList.next();
                if (!rh.getOptionTag().equalsIgnoreCase("100rel")) continue;
                found = true;
            }
        }
        if (!found) {
            Require require = new Require("100rel");
            relResponse.addHeader((Header)require);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Require header with optionTag 100rel is needed -- adding one");
            }
        }
        SIPServerTransaction serverTransaction = (SIPServerTransaction)this.getFirstTransaction();
        this.setLastResponse(serverTransaction, sipResponse);
        this.setDialogId(sipResponse.getDialogId(true));
        serverTransaction.sendReliableProvisionalResponse(relResponse);
        this.startRetransmitTimer(serverTransaction, relResponse);
    }

    public void terminateOnBye(boolean terminateFlag) throws SipException {
        this.terminateOnBye = terminateFlag;
    }

    public void setAssigned() {
        this.isAssigned = true;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public Contact getMyContactHeader() {
        return this.contactHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleAck(SIPServerTransaction ackTransaction) {
        SIPResponse sipResponse;
        SIPRequest sipRequest = ackTransaction.getOriginalRequest();
        if (this.isAckSeen() && this.getRemoteSeqNumber() == sipRequest.getCSeq().getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("ACK already seen by dialog -- dropping Ack retransmission");
            }
            this.acquireTimerTaskSem();
            try {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                    this.timerTask = null;
                }
                Object var4_3 = null;
                this.releaseTimerTaskSem();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.releaseTimerTaskSem();
                throw throwable;
            }
            return false;
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dialog is terminated -- dropping ACK");
            }
            return false;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        SIPResponse sIPResponse = sipResponse = tr != null ? tr.getLastResponse() : null;
        if (tr != null && sipResponse != null && sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeq().getMethod().equals("INVITE") && sipResponse.getCSeq().getSeqNumber() == sipRequest.getCSeq().getSeqNumber()) {
            ackTransaction.setDialog(this, sipResponse.getDialogId(false));
            this.ackReceived(sipRequest);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("ACK for 2XX response --- sending to TU ");
            }
            return true;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug(" INVITE transaction not found  -- Discarding ACK");
        }
        return false;
    }

    void setEarlyDialogId(String earlyDialogId) {
        this.earlyDialogId = earlyDialogId;
    }

    String getEarlyDialogId() {
        return this.earlyDialogId;
    }

    void releaseAckSem() {
        if (this.isBackToBackUserAgent) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("releaseAckSem]" + this);
            }
            this.ackSem.release();
        }
    }

    boolean takeAckSem() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("[takeAckSem " + this);
        }
        try {
            if (!this.ackSem.tryAcquire(2L, TimeUnit.SECONDS)) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logError("Cannot aquire ACK semaphore");
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Semaphore previously acquired at " + this.stackTrace);
                    this.sipStack.getStackLogger().logStackTrace();
                }
                return false;
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.recordStackTrace();
            }
        }
        catch (InterruptedException ex) {
            this.sipStack.getStackLogger().logError("Cannot aquire ACK semaphore");
            return false;
        }
        return true;
    }

    private void setLastAckReceived(SIPRequest lastAckReceived) {
        this.lastAckReceived = lastAckReceived;
    }

    protected SIPRequest getLastAckReceived() {
        return this.lastAckReceived;
    }

    private void setLastAckSent(SIPRequest lastAckSent) {
        this.lastAckSent = lastAckSent;
    }

    public boolean isAtleastOneAckSent() {
        return this.isAcknowledged;
    }

    public boolean isBackToBackUserAgent() {
        return this.isBackToBackUserAgent;
    }

    public synchronized void doDeferredDeleteIfNoAckSent(long seqno) {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else if (this.dialogDeleteIfNoAckSentTask == null) {
            this.dialogDeleteIfNoAckSentTask = new DialogDeleteIfNoAckSentTask(seqno);
            this.sipStack.getTimer().schedule((TimerTask)this.dialogDeleteIfNoAckSentTask, this.sipStack.getAckTimeoutFactor() * 500);
        }
    }

    public void setBackToBackUserAgent() {
        this.isBackToBackUserAgent = true;
    }

    EventHeader getEventHeader() {
        return this.eventHeader;
    }

    void setEventHeader(EventHeader eventHeader) {
        this.eventHeader = eventHeader;
    }

    void setServerTransactionFlag(boolean serverTransactionFlag) {
        this.serverTransactionFlag = serverTransactionFlag;
    }

    void setReInviteFlag(boolean reInviteFlag) {
        this.reInviteFlag = reInviteFlag;
    }

    public boolean isSequnceNumberValidation() {
        return this.sequenceNumberValidation;
    }

    public void disableSequenceNumberValidation() {
        this.sequenceNumberValidation = false;
    }

    public void acquireTimerTaskSem() {
        boolean acquired = false;
        try {
            acquired = this.timerTaskLock.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            acquired = false;
        }
        if (!acquired) {
            throw new IllegalStateException("Impossible to acquire the dialog timer task lock");
        }
    }

    public void releaseTimerTaskSem() {
        this.timerTaskLock.release();
    }

    public String getMergeId() {
        return this.firstTransactionMergeId;
    }

    class DialogDeleteIfNoAckSentTask
    extends SIPStackTimerTask
    implements Serializable {
        private long seqno;

        public DialogDeleteIfNoAckSentTask(long seqno) {
            this.seqno = seqno;
        }

        protected void runTask() {
            if (SIPDialog.this.highestSequenceNumberAcknowledged < this.seqno) {
                SIPDialog.this.dialogDeleteIfNoAckSentTask = null;
                if (!SIPDialog.this.isBackToBackUserAgent) {
                    if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                        SIPDialog.this.sipStack.getStackLogger().logError("ACK Was not sent. killing dialog");
                    }
                    if (SIPDialog.this.sipProvider.getSipListener() instanceof SipListenerExt) {
                        SIPDialog.this.raiseErrorEvent(2);
                    } else {
                        SIPDialog.this.delete();
                    }
                } else {
                    if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                        SIPDialog.this.sipStack.getStackLogger().logError("ACK Was not sent. Sending BYE");
                    }
                    if (SIPDialog.this.sipProvider.getSipListener() instanceof SipListenerExt) {
                        SIPDialog.this.raiseErrorEvent(2);
                    } else {
                        try {
                            Request byeRequest = SIPDialog.this.createRequest("BYE");
                            if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
                                byeRequest.addHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
                            }
                            Reason reasonHeader = new Reason();
                            reasonHeader.setProtocol("SIP");
                            reasonHeader.setCause(1025);
                            reasonHeader.setText("Timed out waiting to send ACK");
                            byeRequest.addHeader((Header)reasonHeader);
                            ClientTransaction byeCtx = SIPDialog.this.getSipProvider().getNewClientTransaction(byeRequest);
                            SIPDialog.this.sendRequest(byeCtx);
                            return;
                        }
                        catch (Exception ex) {
                            SIPDialog.this.delete();
                        }
                    }
                }
            }
        }
    }

    class DialogDeleteTask
    extends SIPStackTimerTask
    implements Serializable {
        DialogDeleteTask() {
        }

        protected void runTask() {
            SIPDialog.this.delete();
        }
    }

    class DialogTimerTask
    extends SIPStackTimerTask
    implements Serializable {
        int nRetransmissions;
        SIPServerTransaction transaction;
        long cseqNumber;

        public DialogTimerTask(SIPServerTransaction transaction) {
            this.transaction = transaction;
            this.nRetransmissions = 0;
            this.cseqNumber = transaction.getLastResponse().getCSeq().getSeqNumber();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTask() {
            SIPResponse response;
            SIPDialog dialog = SIPDialog.this;
            if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                SIPDialog.this.sipStack.getStackLogger().logDebug("Running dialog timer");
            }
            ++this.nRetransmissions;
            SIPServerTransaction transaction = this.transaction;
            if (this.nRetransmissions > SIPDialog.this.sipStack.getAckTimeoutFactor() * 1) {
                if (SIPDialog.this.getSipProvider().getSipListener() != null && SIPDialog.this.getSipProvider().getSipListener() instanceof SipListenerExt) {
                    SIPDialog.this.raiseErrorEvent(1);
                } else {
                    SIPDialog.this.delete();
                }
                if (transaction != null && transaction.getState() != TransactionState.TERMINATED) {
                    transaction.raiseErrorEvent(1);
                }
            } else if (transaction != null && !dialog.isAckSeen() && (response = transaction.getLastResponse()).getStatusCode() == 200) {
                try {
                    if (dialog.toRetransmitFinalResponse(transaction.T2)) {
                        transaction.sendMessage(response);
                    }
                }
                catch (IOException ex) {
                    SIPDialog.this.raiseIOException(transaction.getPeerAddress(), transaction.getPeerPort(), transaction.getPeerProtocol());
                }
                finally {
                    SIPTransactionStack stack = dialog.sipStack;
                    if (stack.isLoggingEnabled()) {
                        stack.getStackLogger().logDebug("resend 200 response from " + dialog);
                    }
                    transaction.fireTimer();
                }
            }
            if (dialog.isAckSeen() || dialog.dialogState == 3) {
                this.transaction = null;
                this.cancel();
            }
        }
    }

    class LingerTimer
    extends SIPStackTimerTask
    implements Serializable {
        protected void runTask() {
            SIPDialog dialog = SIPDialog.this;
            if (SIPDialog.this.eventListeners != null) {
                SIPDialog.this.eventListeners.clear();
            }
            SIPDialog.this.timerTaskLock = null;
            SIPDialog.this.sipStack.removeDialog(dialog);
        }
    }

    public class ReInviteSender
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1019346148741070635L;
        ClientTransaction ctx;

        public void terminate() {
            try {
                this.ctx.terminate();
                Thread.currentThread().interrupt();
            }
            catch (ObjectInUseException e) {
                SIPDialog.this.sipStack.getStackLogger().logError("unexpected error", (Exception)((Object)e));
            }
        }

        public ReInviteSender(ClientTransaction ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long timeToWait = 0L;
                long startTime = System.currentTimeMillis();
                if (!SIPDialog.this.takeAckSem()) {
                    if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                        SIPDialog.this.sipStack.getStackLogger().logError("Could not send re-INVITE time out ClientTransaction");
                    }
                    ((SIPClientTransaction)this.ctx).fireTimeoutTimer();
                    if (SIPDialog.this.sipProvider.getSipListener() != null && SIPDialog.this.sipProvider.getSipListener() instanceof SipListenerExt) {
                        SIPDialog.this.raiseErrorEvent(3);
                    } else {
                        Request byeRequest = SIPDialog.this.createRequest("BYE");
                        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
                            byeRequest.addHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
                        }
                        Reason reasonHeader = new Reason();
                        reasonHeader.setCause(1024);
                        reasonHeader.setText("Timed out waiting to re-INVITE");
                        byeRequest.addHeader((Header)reasonHeader);
                        ClientTransaction byeCtx = SIPDialog.this.getSipProvider().getNewClientTransaction(byeRequest);
                        SIPDialog.this.sendRequest(byeCtx);
                        return;
                    }
                }
                if (SIPDialog.this.getState() != DialogState.TERMINATED) {
                    timeToWait = System.currentTimeMillis() - startTime;
                }
                try {
                    if (timeToWait != 0L) {
                        Thread.sleep(SIPDialog.this.reInviteWaitTime);
                    }
                }
                catch (InterruptedException ex) {
                    if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                        SIPDialog.this.sipStack.getStackLogger().logDebug("Interrupted sleep");
                    }
                    this.ctx = null;
                    return;
                }
                if (SIPDialog.this.getState() != DialogState.TERMINATED) {
                    SIPDialog.this.sendRequest(this.ctx, true);
                }
                if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                    SIPDialog.this.sipStack.getStackLogger().logDebug("re-INVITE successfully sent");
                }
            }
            catch (Exception ex) {
                SIPDialog.this.sipStack.getStackLogger().logError("Error sending re-INVITE", ex);
            }
            finally {
                this.ctx = null;
            }
        }
    }
}

