/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;

class IOHandler {
    private SipStackImpl sipStack;
    private static final String TCP = "tcp";
    private static final String TLS = "tls";
    private final ConcurrentHashMap<String, Socket> socketTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Semaphore> socketCreationMap = new ConcurrentHashMap();

    protected static String makeKey(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    protected IOHandler(SIPTransactionStack sipStack) {
        this.sipStack = (SipStackImpl)sipStack;
    }

    protected void putSocket(String key, Socket sock) {
        this.socketTable.put(key, sock);
    }

    protected Socket getSocket(String key) {
        return this.socketTable.get(key);
    }

    protected void removeSocket(String key) {
        this.socketTable.remove(key);
        this.socketCreationMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] bytes, int length) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int chunksize = 8192;
            for (int p = 0; p < length; p += chunksize) {
                int chunk = p + chunksize < length ? chunksize : length - p;
                outputStream.write(bytes, p, chunk);
            }
        }
        outputStream.flush();
    }

    public SocketAddress obtainLocalAddress(InetAddress dst, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        String key = IOHandler.makeKey(dst, dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSocket(dst, dstPort, localAddress, localPort);
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket sendBytes(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, String transport, byte[] bytes, boolean retry, MessageChannel messageChannel) throws IOException {
        int retry_count = 0;
        int max_retry = retry ? 2 : 1;
        int length = bytes.length;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " length = " + length);
        }
        if (this.sipStack.isLoggingEnabled() && this.sipStack.isLogStackTraceOnMessageSend()) {
            this.sipStack.getStackLogger().logStackTrace(16);
        }
        if (transport.compareToIgnoreCase(TCP) == 0) {
            String key = IOHandler.makeKey(receiverAddress, contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("inaddr = " + receiverAddress);
                            this.sipStack.getStackLogger().logDebug("port = " + contactPort);
                        }
                        clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, contactPort, senderAddress);
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("IOException occured retryCount " + retry_count);
                        }
                        this.removeSocket(key);
                        try {
                            clientSock.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                    }
                }
                Object var16_26 = null;
                this.leaveIOCriticalSection(key);
            }
            catch (Throwable throwable) {
                Object var16_27 = null;
                this.leaveIOCriticalSection(key);
                throw throwable;
            }
            if (clientSock == null) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug(this.socketTable.toString());
                    this.sipStack.getStackLogger().logError("Could not connect to " + receiverAddress + ":" + contactPort);
                }
                throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            return clientSock;
        }
        if (transport.compareToIgnoreCase(TLS) == 0) {
            String key = IOHandler.makeKey(receiverAddress, contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        clientSock = this.sipStack.getNetworkLayer().createSSLSocket(receiverAddress, contactPort, senderAddress);
                        SSLSocket sslsock = (SSLSocket)clientSock;
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("inaddr = " + receiverAddress);
                            this.sipStack.getStackLogger().logDebug("port = " + contactPort);
                        }
                        HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((TLSMessageChannel)messageChannel);
                        ((TLSMessageChannel)messageChannel).setHandshakeCompletedListener(listner);
                        sslsock.addHandshakeCompletedListener(listner);
                        sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
                        sslsock.startHandshake();
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("Handshake passed");
                        }
                        try {
                            this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy(messageChannel.getEncapsulatedClientTransaction());
                        }
                        catch (SecurityException ex) {
                            throw new IOException(ex.getMessage());
                        }
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("TLS Security policy passed");
                        }
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logException(ex);
                        }
                        this.removeSocket(key);
                        try {
                            clientSock.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                    }
                }
                Object var18_31 = null;
                this.leaveIOCriticalSection(key);
            }
            catch (Throwable throwable) {
                Object var18_32 = null;
                this.leaveIOCriticalSection(key);
                throw throwable;
            }
            if (clientSock == null) {
                throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            return clientSock;
        }
        DatagramSocket datagramSock = this.sipStack.getNetworkLayer().createDatagramSocket();
        datagramSock.connect(receiverAddress, contactPort);
        DatagramPacket dgPacket = new DatagramPacket(bytes, 0, length, receiverAddress, contactPort);
        datagramSock.send(dgPacket);
        datagramSock.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveIOCriticalSection(String key) {
        ConcurrentHashMap<String, Semaphore> concurrentHashMap = this.socketCreationMap;
        synchronized (concurrentHashMap) {
            Semaphore creationSemaphore = this.socketCreationMap.get(key);
            if (creationSemaphore != null) {
                creationSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterIOCriticalSection(String key) throws IOException {
        Semaphore creationSemaphore = null;
        ConcurrentHashMap<String, Semaphore> concurrentHashMap = this.socketCreationMap;
        synchronized (concurrentHashMap) {
            creationSemaphore = this.socketCreationMap.get(key);
            if (creationSemaphore == null) {
                creationSemaphore = new Semaphore(1, true);
                this.socketCreationMap.put(key, creationSemaphore);
            }
        }
        try {
            boolean retval = creationSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!retval) {
                throw new IOException("Could not acquire IO Semaphore'" + key + "' after 10 seconds -- giving up ");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("exception in acquiring sem");
        }
    }

    public void closeAll() {
        Enumeration<Socket> values = this.socketTable.elements();
        while (values.hasMoreElements()) {
            Socket s = values.nextElement();
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

