/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack.timers;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.timers.SipTimer;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorSipTimer
implements SipTimer {
    protected SipStackImpl sipStackImpl;
    ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(1);
    private volatile int numCancelled = 0;

    public void stop() {
        this.threadPoolExecutor.shutdown();
        this.sipStackImpl.getStackLogger().logStackTrace(32);
        if (this.sipStackImpl.getStackLogger().isLoggingEnabled(16)) {
            this.sipStackImpl.getStackLogger().logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    public boolean schedule(SIPStackTimerTask task, long delay) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        ScheduledFuture<?> future = this.threadPoolExecutor.schedule(new ScheduledSipTimerTask(task), delay, TimeUnit.MILLISECONDS);
        task.setSipTimerTask(future);
        return true;
    }

    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        ScheduledFuture<?> future = this.threadPoolExecutor.scheduleWithFixedDelay(new ScheduledSipTimerTask(task), delay, period, TimeUnit.MILLISECONDS);
        task.setSipTimerTask(future);
        return true;
    }

    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.threadPoolExecutor.prestartAllCoreThreads();
        if (this.sipStackImpl.getStackLogger().isLoggingEnabled(16)) {
            this.sipStackImpl.getStackLogger().logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    public boolean cancel(SIPStackTimerTask task) {
        boolean cancelled = false;
        ScheduledFuture sipTimerTask = (ScheduledFuture)task.getSipTimerTask();
        if (sipTimerTask != null) {
            task.cleanUpBeforeCancel();
            task.setSipTimerTask(null);
            this.threadPoolExecutor.remove((Runnable)((Object)sipTimerTask));
            cancelled = sipTimerTask.cancel(false);
        }
        ++this.numCancelled;
        if (this.numCancelled % 50 == 0) {
            this.threadPoolExecutor.purge();
        }
        return cancelled;
    }

    public boolean isStarted() {
        return this.threadPoolExecutor.isTerminated();
    }

    private class ScheduledSipTimerTask
    implements Runnable {
        private SIPStackTimerTask task;

        public ScheduledSipTimerTask(SIPStackTimerTask task) {
            this.task = task;
        }

        public void run() {
            try {
                if (this.task != null) {
                    this.task.runTask();
                }
            }
            catch (Throwable e) {
                System.out.println("SIP stack timer task failed due to exception:");
                e.printStackTrace();
            }
        }
    }
}

