package performance.uas_uac;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.Vector;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;


public class Two implements SipListener{
	private static SipStack sipStack;
	private static ListeningPoint listeningPoint;
	private static SipProvider sipProvider;
	private static AddressFactory addressFactory;
	private static MessageFactory messageFactory;
	private static HeaderFactory headerFactory;
	private static Vector<String> busyNumbers = new Vector<String>();
	private static Vector<RequestEvent> requestEvents = new Vector<RequestEvent>();
	private static Vector<Dialog> DialogsOfB = new Vector<Dialog>();
	private static Vector<Dialog> DialogsOfA = new Vector<Dialog>();
	private static Vector<CallIdHeader> callIDheaders = new Vector<CallIdHeader>();
	private static Vector<CallIdHeader> callIDheadersDia = new Vector<CallIdHeader>();
	private static Vector<ServerTransaction> serverTransactions = new Vector<ServerTransaction>();
	private static long countId = 0;
	private static ContactHeader contactHeader = null;
	private static String transport="udp";
	
	public static void main(String[] args) {
		//Factorys
		SipFactory sipFactory = SipFactory.getInstance();
		sipFactory.setPathName("gov.nist");
		
		try {
		headerFactory = sipFactory.createHeaderFactory();
		addressFactory = sipFactory.createAddressFactory();
		messageFactory = sipFactory.createMessageFactory();
		} catch (PeerUnavailableException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		//Stack
		try{
			Properties properties = new Properties();
			
			properties.setProperty("javax.sip.STACK_NAME", "empf");
//			properties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
//			properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "2");
//			properties.setProperty("gov.nist.javax.sip.DEBUG_LOG","debug.txt");
			properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "NONE");
//			properties.setProperty("gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_ACK", "false");
//			properties.setProperty("gov.nist.javax.sip.MAX_LISTENER_RESPONSE_TIME", "60");
			
			sipStack = sipFactory.createSipStack(properties);
		}
		catch (PeerUnavailableException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		//Listening Point
		try{
			listeningPoint = sipStack.createListeningPoint("127.0.0.1", 5080, transport);
		}
		catch(InvalidArgumentException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		catch(TransportNotSupportedException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		//SIP Provider
		try{
			sipProvider = sipStack.createSipProvider(listeningPoint);
		}
		catch(ObjectInUseException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		try
		{
			sipProvider.addSipListener(new Two());
		}
		catch(TooManyListenersException e)
		{
			e.printStackTrace();
			System.err.println(e.getMessage());
		}

		//Set reroute numbers
		busyNumbers.add("003244");
		busyNumbers.add("0703344552");
		
		//Lists
//		while(true){
//			try {
//				Thread.sleep(1000);
//			} catch (InterruptedException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//			System.out.println(requestEvents);
//			System.out.println(DialogsOfA);
//			System.out.println(DialogsOfB);
//			System.out.println(callIDheadersDia);
//			System.out.println(callIDheaders);
//			System.out.println(serverTransactions);
//		}
		
	}
	
	private static Request createMessage(String from, String to, CallIdHeader callId){
		Request request = null;
		countId += 1;//increase it for new hash
		//Invite
		try {	
			// create From Header
			SipURI fromAddress = addressFactory.createSipURI(from, "send.com");
			Address fromNameAddress = addressFactory.createAddress(fromAddress);
			fromNameAddress.setDisplayName(from);
			FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress,"12345");

			// create To Header
			SipURI toAddress = addressFactory.createSipURI(to, "empf.com");
			Address toNameAddress = addressFactory.createAddress(toAddress);
			toNameAddress.setDisplayName(to);
			ToHeader toHeader = headerFactory.createToHeader(toNameAddress, null);

			// create Request URI
			SipURI requestURI = addressFactory.createSipURI(from, "127.0.0.1:5070");

			// Create ViaHeaders
			ArrayList viaHeaders = new ArrayList();
			ViaHeader viaHeader = headerFactory.createViaHeader("127.0.0.1",
					sipProvider.getListeningPoint(transport).getPort(), transport, null);
			viaHeaders.add(viaHeader);

			// Create a new CallId header
			CallIdHeader callIdHeader = callId;
			//callIdHeader.setCallId("1");
			// Create a new Cseq header
			CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(countId, Request.INVITE);

			// Create a new MaxForwardsHeader
			MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
			// Create the request.
			request = messageFactory.createRequest(requestURI,Request.INVITE,
					callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
			// Create contact headers
			String host = "127.0.0.1";
			SipURI contactUrl = addressFactory.createSipURI(from, host);
			contactUrl.setPort(listeningPoint.getPort());

			// Create the contact name address.
			SipURI contactURI = addressFactory.createSipURI(from, host);
			contactURI.setPort(sipProvider.getListeningPoint(transport).getPort());
			contactURI.setTransportParam(transport);
			Address contactAddress = addressFactory.createAddress(contactURI);

			// Add the contact address.
			contactAddress.setDisplayName(from);
			contactHeader = headerFactory.createContactHeader(contactAddress);
			request.addHeader(contactHeader);
			
		} catch (ParseException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		} catch (InvalidArgumentException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		return request;
	}
	

	public void processDialogTerminated(DialogTerminatedEvent arg0) {	
		callIDheadersDia.remove(DialogsOfA.indexOf(arg0.getDialog()));
		DialogsOfA.remove(arg0.getDialog());
	}

	public void processIOException(IOExceptionEvent arg0) {
	    System.err.println("processIOException----------------------------------");
	}

	public void processRequest(RequestEvent requestEvent) {
		//Invite received
		if(requestEvent.getRequest().getMethod().equals(Request.INVITE)){
			//System.out.println("INVITE bekommen");
			
			//send new invite
			FromHeader fromHeader = (FromHeader) requestEvent.getRequest().getHeader(FromHeader.NAME);
			String fromHeaderName = fromHeader.getAddress().getDisplayName();
			
			//Get callID
			CallIdHeader callID = (CallIdHeader) requestEvent.getRequest().getHeader(CallIdHeader.NAME);
//			invitesDone.add(callID);
//			invitesSent++;
			
			//Save Event for responding later
			
			callIDheaders.add(callID);
			requestEvents.add(callIDheaders.size()-1,requestEvent);
			
			Request request = createMessage(fromHeaderName, "reroute", callID);
			try{
				ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(request);
//				clientTransaction.setRetransmitTimer(990000);
				clientTransaction.sendRequest();
				//System.out.println("Invite sent");
			} catch(TransactionUnavailableException e){	
				e.printStackTrace();
				System.err.println(e.getMessage());
			} catch(SipException e){	
				e.printStackTrace();
				System.err.println(e.getMessage());
			}
						
				ServerTransaction serverTransaction = requestEvent.getServerTransaction();
				if(serverTransaction==null){
					try {
						serverTransaction = sipProvider.getNewServerTransaction(requestEvent.getRequest());
					} catch (TransactionAlreadyExistsException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (TransactionUnavailableException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				serverTransactions.add(callIDheaders.size()-1,serverTransaction);
				
		}
		if(requestEvent.getRequest().getMethod().equals(Request.ACK))
		{
			//System.out.println("ACK bekommen");
			//System.out.println(requestEvent.getDialog());
			//DialogsOfA for BYE User B
			//DialogsOfA.add(requestEvent.getDialog());
		}
		if(requestEvent.getRequest().getMethod().equals(Request.BYE))
		{
			//System.out.println("Bye bekommen");
			//System.out.println(requestEvent.getDialog());
			Response responseOk;
			try {
				responseOk = messageFactory.createResponse(Response.OK, requestEvent.getRequest());
				ServerTransaction serverTransaction = requestEvent.getServerTransaction();
				serverTransaction.sendResponse(responseOk);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SipException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvalidArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}	
			//System.out.println("Ok (bye) sent");
			
			Dialog dialog = null;
			try{
			for (int i = 0; i < callIDheadersDia.size(); i++) {
				if(callIDheadersDia.get(i).equals(requestEvent.getRequest().getHeader(CallIdHeader.NAME))){
					dialog = DialogsOfB.get(i);
					DialogsOfB.remove(dialog);
					callIDheadersDia.remove(requestEvent.getRequest().getHeader(CallIdHeader.NAME));
					break;
				}
			}
		}catch(Exception e){
			System.out.println("For-loop Exception:" + e);
		}
			
			Request byeRequest;
			try {
				byeRequest = dialog.createRequest(Request.BYE);
				dialog.sendRequest(sipProvider.getNewClientTransaction(byeRequest));
			} catch (SipException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			//System.out.println("Bye sent");
		}
	}

	public void sendResponse(ServerTransaction serverTransaction,Response response){
		response.addHeader(contactHeader);
		try {
			serverTransaction.sendResponse(response);
			//System.out.println(response.getStatusCode()+" gesendet");
		} catch (SipException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvalidArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void processResponse(ResponseEvent responseEvent) {
		if(responseEvent.getResponse().getStatusCode() == 180){
			//System.out.println("Ringing bekommen");
			RequestEvent requestEventz = null;
			ServerTransaction serverTransactiond = null;
			try{
				//For Loop again
				for (int i = 0; i < callIDheaders.size(); i++) {
					if(callIDheaders.get(i).equals(responseEvent.getResponse().getHeader(CallIdHeader.NAME))){
						requestEventz = (RequestEvent) requestEvents.get(i);
						serverTransactiond = (ServerTransaction) serverTransactions.get(callIDheaders.indexOf(callIDheaders.get(i)));
						break;
					}
				}
			}catch(Exception e){
				System.out.println("For-loop Exception:" + e);
			}

			try {
					sendResponse(serverTransactiond,messageFactory.createResponse(Response.RINGING, requestEventz.getRequest()));
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		CSeqHeader cseq2 = (CSeqHeader) responseEvent.getResponse().getHeader(CSeqHeader.NAME);
		//OK BEKOMMEN
		if(responseEvent.getResponse().getStatusCode() == 200 && cseq2.getMethod().equals("INVITE")){
			//System.out.println("confirmed OK bekommen");
			DialogsOfB.add(responseEvent.getDialog());
			callIDheadersDia.add((CallIdHeader) responseEvent.getResponse().getHeader(CallIdHeader.NAME));
			
			CSeqHeader cseq = (CSeqHeader) responseEvent.getResponse().getHeader(CSeqHeader.NAME);
			try{
				Dialog dialog = responseEvent.getClientTransaction().getDialog();
				Request ack = dialog.createAck(cseq.getSeqNumber());
				//System.out.println("Ack sent");
				dialog.sendAck(ack);
			}catch (SipException e) {
				e.printStackTrace();
				System.err.println(e.getMessage());
			}catch (InvalidArgumentException e) {
				e.printStackTrace();
				System.err.println(e.getMessage());
			}
			
			RequestEvent requestEventz = null;
			ServerTransaction serverTransactiond = null;
			try{
				//For Loop again
				for (int i = 0; i < callIDheaders.size(); i++) {	
					if(callIDheaders.get(i).equals(responseEvent.getResponse().getHeader(CallIdHeader.NAME))){
						requestEventz = (RequestEvent) requestEvents.get(i);
						serverTransactiond = (ServerTransaction) serverTransactions.get(i);
						break;
					}
				}
			}catch(Exception e){
				System.out.println("For-loop Exception:" + e);
			}
			requestEvents.remove(requestEventz);
			serverTransactions.remove(serverTransactiond);
			callIDheaders.remove(responseEvent.getResponse().getHeader(CallIdHeader.NAME));
			try {
					sendResponse(serverTransactiond,messageFactory.createResponse(Response.OK, requestEventz.getRequest()));
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if(responseEvent.getResponse().getStatusCode() == 200 && cseq2.getMethod().equals("BYE")){
			//System.out.println("Terminated Ok bekommen");
		}
	}


	public void processTimeout(TimeoutEvent arg0) {
		if(arg0.isServerTransaction())
		{
			serverTransactions.remove(arg0.getServerTransaction());
			requestEvents.remove(callIDheaders.indexOf(arg0.getServerTransaction().getRequest().getHeader(CallIdHeader.NAME)));
			callIDheaders.remove(arg0.getServerTransaction().getRequest().getHeader(CallIdHeader.NAME));
		}
		System.err.println("Timeout----------------------------------");
	}

	public void processTransactionTerminated(TransactionTerminatedEvent arg0) {
	}
}
