/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.sip.address.Hop;

public class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable,
RawMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(TCPMessageChannel.class);
    private Socket mySock;
    private PipelinedMsgParser myParser;
    protected InputStream myClientInputStream;
    protected OutputStream myClientOutputStream;
    protected String key;
    protected boolean isCached;
    protected boolean isRunning = true;
    private Thread mythread;
    protected SIPTransactionStack sipStack;
    protected String myAddress;
    protected int myPort;
    protected InetAddress peerAddress;
    protected int peerPortAdvertisedInHeaders = -1;
    protected int peerPort;
    protected String peerProtocol;
    private TCPMessageProcessor tcpMessageProcessor;

    protected TCPMessageChannel(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    protected TCPMessageChannel(Socket sock, SIPTransactionStack sipStack, TCPMessageProcessor msgProcessor, String threadName) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TCPMessageChannel ");
            logger.logStackTrace();
        }
        this.mySock = sock;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName(threadName);
        this.sipStack = sipStack;
        this.peerPort = this.mySock.getPort();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.tcpMessageProcessor = msgProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TCPMessageProcessor messageProcessor) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TCPMessageChannel ");
            logger.logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.sipStack = sipStack;
        this.tcpMessageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.messageProcessor = messageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean removeSocket) {
        String ioHandlerKey;
        block16: {
            block15: {
                this.isRunning = false;
                if (this.mySock != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Closing socket " + this.key);
                    }
                    try {
                        this.mySock.close();
                        this.mySock = null;
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggingEnabled(32)) break block15;
                        logger.logDebug("Error closing socket " + ex);
                    }
                }
            }
            if (this.myParser != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing my parser " + this.myParser);
                }
                this.myParser.close();
            }
            if (this.myClientOutputStream != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing client output stream " + this.myClientOutputStream);
                }
                try {
                    this.myClientOutputStream.close();
                }
                catch (IOException ex) {
                    if (!logger.isLoggingEnabled(32)) break block16;
                    logger.logDebug("Error closing client output stream" + ex);
                }
            }
        }
        if (removeSocket) {
            ioHandlerKey = this.key.substring(4);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing TCP socket " + ioHandlerKey);
            }
            this.sipStack.ioHandler.removeSocket(ioHandlerKey);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing message Channel " + this);
            }
        } else if (logger.isLoggingEnabled(32)) {
            ioHandlerKey = this.key.substring(4);
            logger.logDebug("not removing socket key from the cached map since it has already been updated by the iohandler.sendBytes " + ioHandlerKey);
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient);
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, isClient, this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + this.peerPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
        }
        if (sock == null) {
            if (this.peerPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                logger.logWarning("Couldn't connect to peerAddress = " + this.peerAddress + " peerPort = " + this.peerPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPortAdvertisedInHeaders, this.peerProtocol, msg, isClient, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
                logger.logWarning("retry suceeded to peerAddress = " + this.peerAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null && logger.isLoggingEnabled(32)) {
                logger.logDebug("Old socket different than new socket");
                logger.logStackTrace();
                logger.logDebug("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                logger.logDebug("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                logger.logDebug("New socket local ip address " + sock.getLocalSocketAddress());
                logger.logDebug("New socket remote ip address " + sock.getRemoteSocketAddress());
            }
            this.close(false);
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(final SIPMessage sipMessage) throws IOException {
        SIPResponse sipResponse;
        Via via;
        if (logger.isLoggingEnabled(32) && !sipMessage.isNullRequest()) {
            logger.logDebug("sendMessage:: " + sipMessage.getFirstLine() + " cseq method = " + sipMessage.getCSeq().getMethod());
        }
        for (MessageProcessor messageProcessor : this.getSIPStack().getMessageProcessors()) {
            if (!messageProcessor.getIpAddress().getHostAddress().equals(this.getPeerAddress()) || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
            Runnable processMessageTask = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            TCPMessageChannel.this.processMessage((SIPMessage)sipMessage.clone());
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggingEnabled(4)) break block2;
                            logger.logError("Error self routing message cause by: ", ex);
                        }
                    }
                }
            };
            this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Self routing message");
            }
            return;
        }
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        long time = System.currentTimeMillis();
        if (this.peerPortAdvertisedInHeaders <= 0 && sipMessage instanceof SIPResponse && (via = (sipResponse = (SIPResponse)sipMessage).getTopmostVia()).getRPort() > 0) {
            this.peerPortAdvertisedInHeaders = via.getPort() <= 0 ? 5060 : via.getPort();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("1.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for via port = " + via.getPort() + " via rport = " + via.getRPort() + " and peer port = " + this.peerPort + " for this channel " + this + " key " + this.key);
            }
        }
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        sipMessage.setRemoteAddress(this.peerAddress);
        sipMessage.setRemotePort(this.peerPort);
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        sipMessage.setLocalPort(this.getPort());
        if (logger.isLoggingEnabled(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (this.peerPortAdvertisedInHeaders <= 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            }
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
            }
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TCP", message, retry, this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + receiverPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
            logger.logError("Error is ", any);
        }
        if (sock == null) {
            if (receiverPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                this.sipStack.getStackLogger().logWarning("Couldn't connect to receiverAddress = " + receiverAddress + " receiverPort = " + receiverPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, this.peerPortAdvertisedInHeaders, "TCP", message, retry, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPortAdvertisedInHeaders, "TCP");
                this.sipStack.getStackLogger().logWarning("retry suceeded to receiverAddress = " + receiverAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Old socket different than new socket");
                    logger.logStackTrace();
                    logger.logDebug("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    logger.logDebug("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    logger.logDebug("New socket local ip address " + sock.getLocalSocketAddress());
                    logger.logDebug("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.sipStack.getTimer().schedule(new SIPStackTimerTask(){

                    public void cleanUpBeforeCancel() {
                        TCPMessageChannel.this.close(false);
                    }

                    public void runTask() {
                        TCPMessageChannel.this.close(false);
                    }
                }, 8000L);
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread mythread = new Thread(this);
            mythread.setDaemon(true);
            mythread.setName("TCPMessageChannelThread");
            mythread.start();
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled()) {
            logger.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            block7: {
                String msgString;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Encountered Bad Message \n" + sipMessage.toString());
                }
                if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ") && this.mySock != null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("Malformed mandatory headers: closing socket! :" + this.mySock.toString());
                    }
                    try {
                        this.mySock.close();
                    }
                    catch (IOException ie) {
                        if (!logger.isLoggingEnabled(4)) break block7;
                        logger.logError("Exception while closing socket! :" + this.mySock.toString() + ":" + ie.toString());
                    }
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void processMessage(SIPMessage sipMessage, InetAddress address) {
        block2: {
            this.peerAddress = address;
            try {
                this.processMessage(sipMessage);
            }
            catch (Exception e) {
                if (!logger.isLoggingEnabled(4)) break block2;
                logger.logError("ERROR processing self routing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(SIPMessage sipMessage) throws Exception {
        try {
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = sipMessage.encode();
                if (!logger.isLoggingEnabled(32)) return;
                logger.logDebug(">>> Dropped Bad Msg");
                logger.logDebug(badmsg);
                return;
            }
            sipMessage.setRemoteAddress(this.peerAddress);
            sipMessage.setRemotePort(this.getPeerPort());
            sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
            sipMessage.setLocalPort(this.getPort());
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                this.peerProtocol = v.getTransport();
                if (this.peerPortAdvertisedInHeaders <= 0) {
                    int hopPort = v.getPort();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("hop port = " + hopPort + " for request " + sipMessage + " for this channel " + this + " key " + this.key);
                    }
                    this.peerPortAdvertisedInHeaders = hopPort <= 0 ? 5060 : hopPort;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("3.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
                    }
                }
                try {
                    if (this.mySock != null) {
                        this.peerAddress = this.mySock.getInetAddress();
                    }
                    if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        v.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    v.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex, logger);
                }
                if (!this.isCached && this.mySock != null) {
                    this.isCached = true;
                    int remotePort = ((InetSocketAddress)this.mySock.getRemoteSocketAddress()).getPort();
                    String key = IOHandler.makeKey(this.mySock.getInetAddress(), remotePort);
                    this.sipStack.ioHandler.putSocket(key, this.mySock);
                    ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                }
            }
            long receptionTime = System.currentTimeMillis();
            if (sipMessage instanceof SIPRequest) {
                String cseqMethod;
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("----Processing Message---");
                }
                if (logger.isLoggingEnabled(16)) {
                    this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getMessageProcessor().getIpAddress().getHostAddress() + ":" + this.getMessageProcessor().getPort(), false, receptionTime);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sipResponse = sipRequest.createResponse(513);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Message size exceeded");
                }
                String sipVersion = ((SIPRequest)sipMessage).getRequestLine().getSipVersion();
                if (!sipVersion.equals("SIP/2.0")) {
                    SIPResponse versionNotSupported = ((SIPRequest)sipMessage).createResponse(505, "Bad version " + sipVersion);
                    this.sendMessage(versionNotSupported.encodeAsBytes(this.getTransport()), false);
                    throw new Exception("Bad sip version");
                }
                String method = ((SIPRequest)sipMessage).getMethod();
                if (!method.equalsIgnoreCase(cseqMethod = ((SIPRequest)sipMessage).getCSeqHeader().getMethod())) {
                    SIPResponse sipResponse = sipRequest.createResponse(400);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Bad CSeq method");
                }
                ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest != null) {
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        Object var12_27 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) return;
                        SIPServerTransaction sipServerTx = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx.passToListener()) return;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var12_28 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) throw throwable;
                        SIPServerTransaction sipServerTx = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx.passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        throw throwable;
                    }
                } else {
                    if (!logger.isLoggingEnabled()) return;
                    logger.logWarning("Dropping request -- could not acquire semaphore in 10 sec");
                }
                return;
            }
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (!logger.isLoggingEnabled()) return;
                logger.logError("Dropping Badly formatted response message >>> " + sipResponse);
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (!logger.isLoggingEnabled(32)) return;
                logger.logDebug("Message size exceeded");
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                block30: {
                    try {
                        if (!(sipServerResponse instanceof SIPClientTransaction) || ((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) break block30;
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        Object var15_32 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_34 = null;
                        if (!(sipServerResponse instanceof SIPTransaction)) throw throwable;
                        if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                        throw throwable;
                    }
                    if (!(sipServerResponse instanceof SIPTransaction)) return;
                    if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
                    ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    return;
                }
                sipServerResponse.processResponse(sipResponse, this);
                Object var15_33 = null;
                if (!(sipServerResponse instanceof SIPTransaction)) return;
                if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
                ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                return;
            }
            logger.logWarning("Application is blocked -- could not acquire semaphore -- dropping response");
            return;
        }
        catch (Throwable throwable) {
            Object var17_9 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Pipeline hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.getTimer());
        this.myParser = new PipelinedMsgParser(this.sipStack, this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        int bufferSize = 4096;
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
        try {
            while (true) {
                int nbytes;
                byte[] msg;
                try {
                    msg = new byte[bufferSize];
                    nbytes = this.myClientInputStream.read(msg, 0, bufferSize);
                    if (nbytes == -1) {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TCPMessageProcessor tCPMessageProcessor = this.tcpMessageProcessor;
                                synchronized (tCPMessageProcessor) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            hispipe.close();
                            this.close();
                        }
                        catch (IOException ioex) {
                        }
                        Object var9_13 = null;
                        this.isRunning = false;
                        this.tcpMessageProcessor.remove(this);
                        --this.tcpMessageProcessor.useCount;
                        if (this.myParser == null) return;
                        this.myParser.close();
                        return;
                    }
                }
                catch (IOException ex) {
                    try {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("IOException  closing sock " + ex);
                        }
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TCPMessageProcessor e = this.tcpMessageProcessor;
                                synchronized (e) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            this.close();
                            hispipe.close();
                        }
                        catch (IOException ioex) {}
                    }
                    catch (Exception ex1) {
                    }
                    Object var9_14 = null;
                    this.isRunning = false;
                    this.tcpMessageProcessor.remove(this);
                    --this.tcpMessageProcessor.useCount;
                    if (this.myParser == null) return;
                    this.myParser.close();
                    return;
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex, logger);
                    continue;
                }
                {
                    hispipe.write(msg, 0, nbytes);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.isRunning = false;
            this.tcpMessageProcessor.remove(this);
            --this.tcpMessageProcessor.useCount;
            if (this.myParser == null) throw throwable;
            this.myParser.close();
            throw throwable;
        }
    }

    protected void uncache() {
        if (this.isCached && !this.isRunning) {
            this.tcpMessageProcessor.remove(this);
        }
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return false;
    }

    public void sendSingleCLRF() throws Exception {
        if (this.mySock != null && !this.mySock.isClosed()) {
            this.mySock.getOutputStream().write("\r\n".getBytes("UTF-8"));
        }
    }
}

