/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.util.EventObject;
import java.util.LinkedList;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;

class EventScanner
implements Runnable {
    private boolean isStopped;
    private int refCount;
    private LinkedList pendingEvents = new LinkedList();
    private int[] eventMutex = new int[]{0};
    private SipStackImpl sipStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefcount() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            ++this.refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public EventScanner(SipStackImpl sipStackImpl) {
        this.pendingEvents = new LinkedList();
        Thread myThread = new Thread(this);
        myThread.setDaemon(false);
        this.sipStack = sipStackImpl;
        myThread.setName("EventScannerThread");
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        this.sipStack.getLogWriter().logDebug("addEvent " + eventWrapper);
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.pendingEvents.add(eventWrapper);
            this.eventMutex.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            if (this.refCount > 0) {
                --this.refCount;
            }
            if (this.refCount == 0) {
                this.isStopped = true;
                this.eventMutex.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStop() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.isStopped = true;
            this.refCount = 0;
            this.eventMutex.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliverEvent(EventWrapper eventWrapper) {
        SipListener sipListener;
        EventObject sipEvent;
        block60: {
            block59: {
                block58: {
                    block57: {
                        sipEvent = eventWrapper.sipEvent;
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getLogWriter().logDebug("sipEvent = " + sipEvent + "source = " + sipEvent.getSource());
                        }
                        sipListener = null;
                        sipListener = !(sipEvent instanceof IOExceptionEvent) ? ((SipProviderImpl)sipEvent.getSource()).sipListener : this.sipStack.getSipListener();
                        if (!(sipEvent instanceof RequestEvent)) break block60;
                        try {
                            SIPRequest sipRequest;
                            block62: {
                                block61: {
                                    SIPServerTransaction tx;
                                    sipRequest = (SIPRequest)((RequestEvent)sipEvent).getRequest();
                                    if (this.sipStack.isLoggingEnabled()) {
                                        this.sipStack.getLogWriter().logDebug("deliverEvent : " + sipRequest.getFirstLine() + " transaction " + eventWrapper.transaction + " sipEvent.serverTx = " + ((RequestEvent)sipEvent).getServerTransaction());
                                    }
                                    if ((tx = (SIPServerTransaction)this.sipStack.findTransaction(sipRequest, true)) == null || tx.passToListener()) break block61;
                                    if (sipRequest.getMethod().equals("ACK") && tx.isInviteTransaction() && (tx.getLastResponse().getStatusCode() / 100 == 2 || this.sipStack.isNon2XXAckPassedToListener())) {
                                        if (this.sipStack.isLoggingEnabled()) {
                                            this.sipStack.getLogWriter().logDebug("Detected broken client sending ACK with same branch! Passing...");
                                        }
                                        break block62;
                                    } else {
                                        if (this.sipStack.isLoggingEnabled()) {
                                            this.sipStack.getLogWriter().logDebug("transaction already exists! " + tx);
                                        }
                                        Object var8_14 = null;
                                        break block57;
                                    }
                                }
                                if (this.sipStack.findPendingTransaction(sipRequest) != null) {
                                    if (this.sipStack.isLoggingEnabled()) {
                                        this.sipStack.getLogWriter().logDebug("transaction already exists!!");
                                    }
                                    break block58;
                                }
                                SIPServerTransaction st = (SIPServerTransaction)eventWrapper.transaction;
                                this.sipStack.putPendingTransaction(st);
                            }
                            sipRequest.setTransaction(eventWrapper.transaction);
                            try {
                                SIPDialog dialog;
                                if (this.sipStack.isLoggingEnabled()) {
                                    this.sipStack.getLogWriter().logDebug("Calling listener " + sipRequest.getFirstLine());
                                    this.sipStack.getLogWriter().logDebug("Calling listener " + eventWrapper.transaction);
                                }
                                if (sipListener != null) {
                                    sipListener.processRequest((RequestEvent)sipEvent);
                                }
                                if (this.sipStack.isLoggingEnabled()) {
                                    this.sipStack.getLogWriter().logDebug("Done processing Message " + sipRequest.getFirstLine());
                                }
                                if (eventWrapper.transaction != null && (dialog = (SIPDialog)eventWrapper.transaction.getDialog()) != null) {
                                    dialog.requestConsumed();
                                }
                                break block59;
                            }
                            catch (Exception ex) {
                                this.sipStack.getLogWriter().logException(ex);
                            }
                            break block59;
                        }
                        catch (Throwable throwable) {
                            Object var8_17 = null;
                            if (this.sipStack.isLoggingEnabled()) {
                                this.sipStack.getLogWriter().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                            }
                            if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                                ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                            }
                            if (eventWrapper.transaction != null) {
                                this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                            }
                            if (!eventWrapper.transaction.getOriginalRequest().getMethod().equals("ACK")) throw throwable;
                            eventWrapper.transaction.setState(TransactionState.TERMINATED);
                            throw throwable;
                        }
                    }
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                    }
                    if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                        ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                    }
                    if (eventWrapper.transaction != null) {
                        this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                    }
                    if (!eventWrapper.transaction.getOriginalRequest().getMethod().equals("ACK")) return;
                    eventWrapper.transaction.setState(TransactionState.TERMINATED);
                    return;
                }
                Object var8_15 = null;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                }
                if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                    ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                }
                if (eventWrapper.transaction != null) {
                    this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                }
                if (!eventWrapper.transaction.getOriginalRequest().getMethod().equals("ACK")) return;
                eventWrapper.transaction.setState(TransactionState.TERMINATED);
                return;
            }
            Object var8_16 = null;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
            }
            if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
            }
            if (eventWrapper.transaction != null) {
                this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
            }
            if (!eventWrapper.transaction.getOriginalRequest().getMethod().equals("ACK")) return;
            eventWrapper.transaction.setState(TransactionState.TERMINATED);
            return;
        }
        if (sipEvent instanceof ResponseEvent) {
            try {
                ResponseEvent responseEvent = (ResponseEvent)sipEvent;
                SIPResponse sipResponse = (SIPResponse)responseEvent.getResponse();
                SIPDialog sipDialog = (SIPDialog)responseEvent.getDialog();
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("Calling listener for " + sipResponse.getFirstLine());
                    }
                    if (sipListener != null) {
                        SIPTransaction tx = eventWrapper.transaction;
                        if (tx != null) {
                            tx.setPassToListener();
                        }
                        sipListener.processResponse((ResponseEvent)sipEvent);
                    }
                    if (!(sipDialog == null || sipDialog.getState() != null && sipDialog.getState().equals((Object)DialogState.TERMINATED) || sipResponse.getStatusCode() != 481 && sipResponse.getStatusCode() != 408)) {
                        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                            this.sipStack.getLogWriter().logDebug("Removing dialog on 408 or 481 response");
                        }
                        sipDialog.doDeferredDelete();
                    }
                    if (sipResponse.getCSeq().getMethod().equals("INVITE") && sipDialog != null && sipResponse.getStatusCode() == 200 && sipDialog.getLastAck() == null) {
                        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                            this.sipStack.getLogWriter().logDebug("Garbage collecting unacknowledged dialog");
                        }
                        sipDialog.doDeferredDelete();
                    }
                }
                catch (Exception ex) {
                    this.sipStack.getLogWriter().logException(ex);
                }
                SIPClientTransaction ct = (SIPClientTransaction)eventWrapper.transaction;
                if (ct == null) return;
                if (TransactionState.COMPLETED != ct.getState()) return;
                if (ct.getOriginalRequest() == null) return;
                if (ct.getOriginalRequest().getMethod().equals("INVITE")) return;
                ct.clearState();
                return;
            }
            finally {
                if (eventWrapper.transaction != null && eventWrapper.transaction.passToListener()) {
                    eventWrapper.transaction.releaseSem();
                }
            }
        }
        if (sipEvent instanceof TimeoutEvent) {
            try {
                if (sipListener == null) return;
                sipListener.processTimeout((TimeoutEvent)sipEvent);
                return;
            }
            catch (Exception ex) {
                this.sipStack.getLogWriter().logException(ex);
                return;
            }
        }
        if (sipEvent instanceof IOExceptionEvent) {
            try {
                if (sipListener == null) return;
                sipListener.processIOException((IOExceptionEvent)sipEvent);
                return;
            }
            catch (Exception ex) {
                this.sipStack.getLogWriter().logException(ex);
                return;
            }
        }
        if (sipEvent instanceof TransactionTerminatedEvent) {
            try {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("About to deliver transactionTerminatedEvent");
                    this.sipStack.getLogWriter().logDebug("tx = " + ((TransactionTerminatedEvent)sipEvent).getClientTransaction());
                    this.sipStack.getLogWriter().logDebug("tx = " + ((TransactionTerminatedEvent)sipEvent).getServerTransaction());
                }
                if (sipListener == null) return;
                sipListener.processTransactionTerminated((TransactionTerminatedEvent)sipEvent);
                return;
            }
            catch (AbstractMethodError ame) {
                this.sipStack.getLogWriter().logWarning("Unable to call sipListener.processTransactionTerminated");
                return;
            }
            catch (Exception ex) {
                this.sipStack.getLogWriter().logException(ex);
                return;
            }
        }
        if (!(sipEvent instanceof DialogTerminatedEvent)) {
            this.sipStack.getLogWriter().logFatalError("bad event" + sipEvent);
            return;
        }
        try {
            if (sipListener == null) return;
            sipListener.processDialogTerminated((DialogTerminatedEvent)sipEvent);
            return;
        }
        catch (AbstractMethodError ame) {
            this.sipStack.getLogWriter().logWarning("Unable to call sipListener.processDialogTerminated");
            return;
        }
        catch (Exception ex) {
            this.sipStack.getLogWriter().logException(ex);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

