/*
* Conditions Of Use 
* 
* This software was developed by employees of the National Institute of
* Standards and Technology (NIST), an agency of the Federal Government.
* Pursuant to title 15 Untied States Code Section 105, works of NIST
* employees are not subject to copyright protection in the United States
* and are considered to be in the public domain.  As a result, a formal
* license is not needed to use the software.
* 
* This software is provided by NIST as a service and is expressly
* provided "AS IS."  NIST MAKES NO WARRANTY OF ANY KIND, EXPRESS, IMPLIED
* OR STATUTORY, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT
* AND DATA ACCURACY.  NIST does not warrant or make any representations
* regarding the use of the software or the results thereof, including but
* not limited to the correctness, accuracy, reliability or usefulness of
* the software.
* 
* Permission to use this software is contingent upon your acceptance
* of the terms of this agreement
*  
* .
* 
*/
/*******************************************
 * PRODUCT OF PT INOVACAO - EST DEPARTMENT *
 *******************************************/

package gov.nist.javax.sip.parser.ims;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.ims.Path;
import gov.nist.javax.sip.header.ims.PathList;
import gov.nist.javax.sip.parser.AddressParametersParser;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.TokenTypes;

import java.text.ParseException;

/**
 * @author ALEXANDRE MIGUEL SILVA SANTOS 
 */


public class PathParser extends AddressParametersParser implements TokenTypes {
	
	/**
	 * Constructor
	 */
	public PathParser(String path) {
		super(path);
		
	}

	protected PathParser(Lexer lexer) {
		super(lexer);
		
	}

	
	
	
	/**
	 * parse the String message and generate the RecordRoute List Object
	 * @return SIPHeader the RecordRoute List object
	 * @throws ParseException if errors occur during the parsing
	 */
		
	public SIPHeader parse() throws ParseException {
		
		PathList pathList = new PathList();

		if (debug)
			dbg_enter("PathParser.parse");

		try {
			this.lexer.match(TokenTypes.PATH);
			this.lexer.SPorHT();
			this.lexer.match(':');
			this.lexer.SPorHT();
			while (true) {
				Path path = new Path();
				super.parse(path);
				pathList.add(path);
				this.lexer.SPorHT();
				char la = lexer.lookAhead(0);
				if (la == ',') {
					this.lexer.match(',');
					this.lexer.SPorHT();
				} else if (la == '\n')
					break;
				else
					throw createParseException("unexpected char");
			}
			return pathList;
		} finally {
			if (debug)
				dbg_leave("PathParser.parse");
		}

	}
	

	
}
