/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.Parser;
import java.text.ParseException;

public class StatusLineParser
extends Parser {
    public StatusLineParser(String statusLine) {
        this.lexer = new Lexer("status_lineLexer", statusLine);
    }

    public StatusLineParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("status_lineLexer");
    }

    protected int statusCode() throws ParseException {
        String scode = this.lexer.number();
        try {
            int retval;
            int n = retval = Integer.parseInt(scode);
            Object var5_5 = null;
            return n;
        }
        catch (NumberFormatException ex) {
            try {
                throw new ParseException(this.lexer.getBuffer() + ":" + ex.getMessage(), this.lexer.getPtr());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    protected String reasonPhrase() throws ParseException {
        return this.lexer.getRest().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine parse() throws ParseException {
        try {
            StatusLine retval = new StatusLine();
            String version = this.sipVersion();
            retval.setSipVersion(version);
            this.lexer.SPorHT();
            int scode = this.statusCode();
            retval.setStatusCode(scode);
            this.lexer.SPorHT();
            String rp = this.reasonPhrase();
            retval.setReasonPhrase(rp);
            this.lexer.SPorHT();
            StatusLine statusLine = retval;
            Object var7_6 = null;
            return statusLine;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }
}

