/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.UserAgent;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.Lexer;
import java.text.ParseException;

public class UserAgentParser
extends HeaderParser {
    public UserAgentParser(String userAgent) {
        super(userAgent);
    }

    protected UserAgentParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPHeader parse() throws ParseException {
        UserAgent userAgent = new UserAgent();
        try {
            this.headerName(2065);
            if (this.lexer.lookAhead(0) == '\n') {
                throw this.createParseException("empty header");
            }
            while (this.lexer.lookAhead(0) != '\n' && this.lexer.lookAhead(0) != '\u0000') {
                if (this.lexer.lookAhead(0) == '(') {
                    String comment = this.lexer.comment();
                    userAgent.addProductToken('(' + comment + ')');
                } else {
                    this.getLexer().SPorHT();
                    String product = this.lexer.byteStringNoSlash();
                    if (product == null) {
                        throw this.createParseException("Expected product string");
                    }
                    StringBuffer productSb = new StringBuffer(product);
                    if (this.lexer.peekNextToken().getTokenType() == 47) {
                        this.lexer.match(47);
                        this.getLexer().SPorHT();
                        String productVersion = this.lexer.byteStringNoSlash();
                        if (productVersion == null) {
                            throw this.createParseException("Expected product version");
                        }
                        productSb.append("/");
                        productSb.append(productVersion);
                    }
                    userAgent.addProductToken(productSb.toString());
                }
                this.lexer.SPorHT();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
        return userAgent;
    }

    public static void main(String[] args) throws ParseException {
        String[] userAgent = new String[]{"User-Agent: Softphone/Beta1.5 \n", "User-Agent:Nist/Beta1 (beta version) \n", "User-Agent: Nist UA (beta version)\n", "User-Agent: Nist1.0/Beta2 Ubi/vers.1.0 (very cool) \n", "User-Agent: SJphone/1.60.299a/L (SJ Labs)\n", "User-Agent: sipXecs/3.5.11 sipXecs/sipxbridge (Linux)\n"};
        for (int i = 0; i < userAgent.length; ++i) {
            UserAgentParser parser = new UserAgentParser(userAgent[i]);
            UserAgent ua = (UserAgent)parser.parse();
            System.out.println("encoded = " + ua.encode());
        }
    }
}

