/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;

public class LogWriter {
    private Logger logger;
    private String stackName;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_MESSAGES = 16;
    public static final int TRACE_EXCEPTION = 17;
    public static final int TRACE_DEBUG = 32;
    private String logFileName;
    private volatile boolean needsLogging;
    private int lineCount;
    protected int traceLevel;
    private String buildTimeStamp;
    private Properties configurationProperties;

    public void logStackTrace() {
        if (this.needsLogging) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceElement[] ste = new Exception().getStackTrace();
            for (int i = 1; i < ste.length; ++i) {
                String callFrame = "[" + ste[i].getFileName() + ":" + ste[i].getLineNumber() + "]";
                pw.print(callFrame);
            }
            pw.close();
            String stackTrace = sw.getBuffer().toString();
            this.logDebug(stackTrace);
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addAppender(Appender appender) {
        this.logger.addAppender(appender);
    }

    public void logException(Throwable ex) {
        if (this.needsLogging) {
            this.getLogger().error((Object)ex.getMessage(), ex);
        }
    }

    private void countLines(String message) {
        char[] chars = message.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            ++this.lineCount;
        }
    }

    private String enhanceMessage(String message) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        StackTraceElement elem = stackTrace[2];
        String className = elem.getClassName();
        String methodName = elem.getMethodName();
        String fileName = elem.getFileName();
        int lineNumber = elem.getLineNumber();
        String newMessage = className + "." + methodName + "(" + fileName + ":" + lineNumber + ") [" + message + "]";
        return newMessage;
    }

    public void logDebug(String message) {
        if (this.needsLogging) {
            String newMessage = this.enhanceMessage(message);
            if (this.lineCount == 0) {
                this.getLogger().debug((Object)("BUILD TIMESTAMP = " + this.buildTimeStamp));
                this.getLogger().debug((Object)("Config Propeties = " + this.configurationProperties));
            }
            this.countLines(newMessage);
            this.getLogger().debug((Object)newMessage);
        }
    }

    private void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void logFatalError(String message) {
        Logger logger = this.getLogger();
        String newMsg = this.enhanceMessage(message);
        this.countLines(newMsg);
        logger.fatal((Object)newMsg);
    }

    public void logError(String message) {
        Logger logger = this.getLogger();
        String newMsg = this.enhanceMessage(message);
        this.countLines(newMsg);
        logger.error((Object)newMsg);
    }

    public LogWriter(Properties configurationProperties) {
        block25: {
            this.logFileName = null;
            this.needsLogging = false;
            this.traceLevel = 0;
            this.configurationProperties = configurationProperties;
            String logLevel = configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
            this.logFileName = configurationProperties.getProperty("gov.nist.javax.sip.DEBUG_LOG");
            this.stackName = configurationProperties.getProperty("javax.sip.STACK_NAME");
            String category = configurationProperties.getProperty("gov.nist.javax.sip.LOG4J_LOGGER_NAME", this.stackName);
            this.logger = Logger.getLogger((String)category);
            if (logLevel != null) {
                if (logLevel.equals("LOG4J")) {
                    Level level = this.logger.getEffectiveLevel();
                    this.needsLogging = true;
                    if (level == Level.OFF) {
                        this.needsLogging = false;
                    }
                    this.traceLevel = 0;
                    if (level.isGreaterOrEqual((Priority)Level.DEBUG)) {
                        this.traceLevel = 32;
                    } else if (level.isGreaterOrEqual((Priority)Level.INFO)) {
                        this.traceLevel = 16;
                    } else if (level.isGreaterOrEqual((Priority)Level.WARN)) {
                        this.traceLevel = 17;
                    }
                } else {
                    try {
                        int ll = 0;
                        ll = logLevel.equals("DEBUG") ? 32 : (logLevel.equals("TRACE") || logLevel.equals("INFO") ? 16 : (logLevel.equals("ERROR") ? 17 : (logLevel.equals("NONE") || logLevel.equals("OFF") ? 0 : Integer.parseInt(logLevel))));
                        this.setTraceLevel(ll);
                        this.needsLogging = true;
                        if (this.traceLevel == 32) {
                            this.logger.setLevel(Level.DEBUG);
                        } else if (this.traceLevel == 16) {
                            this.logger.setLevel(Level.INFO);
                        } else if (this.traceLevel == 17) {
                            this.logger.setLevel(Level.ERROR);
                        } else if (this.traceLevel == 0) {
                            this.logger.setLevel(Level.OFF);
                            this.needsLogging = false;
                        }
                        if (!this.needsLogging || this.logFileName == null) break block25;
                        FileAppender fa = null;
                        try {
                            fa = new FileAppender((Layout)new SimpleLayout(), this.logFileName);
                        }
                        catch (FileNotFoundException fnf) {
                            File logfile = new File(this.logFileName);
                            logfile.getParentFile().mkdirs();
                            logfile.delete();
                            try {
                                fa = new FileAppender((Layout)new SimpleLayout(), this.logFileName);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        if (fa != null) {
                            this.logger.addAppender((Appender)fa);
                        }
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                        System.err.println("LogWriter: Bad integer " + logLevel);
                        System.err.println("logging dislabled ");
                        this.needsLogging = false;
                    }
                }
            } else {
                this.needsLogging = false;
            }
        }
    }

    public boolean isLoggingEnabled() {
        return this.needsLogging;
    }

    public boolean isLoggingEnabled(int logLevel) {
        return this.needsLogging && logLevel <= this.traceLevel;
    }

    public void logError(String message, Exception ex) {
        Logger logger = this.getLogger();
        logger.error((Object)message, (Throwable)ex);
    }

    public void logWarning(String string) {
        this.getLogger().warn((Object)string);
    }

    public void logInfo(String string) {
        this.getLogger().info((Object)string);
    }

    public void disableLogging() {
        this.needsLogging = false;
    }

    public void enableLogging() {
        this.needsLogging = true;
    }

    public void setBuildTimeStamp(String buildTimeStamp) {
        this.buildTimeStamp = buildTimeStamp;
    }
}

