/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LogWriter;
import gov.nist.core.ThreadAuditor;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.DefaultAddressResolver;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.LogRecordFactory;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.extensions.JoinHeader;
import gov.nist.javax.sip.header.extensions.ReplacesHeader;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SIPTransactionStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 8;
    protected ConcurrentHashMap<String, SIPServerTransaction> retransmissionAlertTransactions;
    protected ConcurrentHashMap<String, SIPDialog> earlyDialogTable;
    protected ConcurrentHashMap<String, SIPDialog> dialogTable;
    protected HashSet<String> dialogCreatingMethods;
    private Timer timer;
    private ConcurrentHashMap<String, SIPServerTransaction> pendingTransactions;
    private ConcurrentHashMap<String, SIPClientTransaction> clientTransactionTable;
    private boolean unlimitedServerTransactionTableSize = false;
    protected boolean unlimitedClientTransactionTableSize = true;
    protected int serverTransactionTableHighwaterMark = 5000;
    protected int serverTransactionTableLowaterMark = 4000;
    protected int clientTransactionTableHiwaterMark = 1000;
    protected int clientTransactionTableLowaterMark = 800;
    private AtomicInteger activeClientTransactionCount = new AtomicInteger(0);
    private ConcurrentHashMap<String, SIPServerTransaction> serverTransactionTable;
    private ConcurrentHashMap<String, SIPServerTransaction> mergeTable;
    protected LogWriter logWriter;
    protected ServerLog serverLog;
    boolean udpFlag;
    protected DefaultRouter defaultRouter;
    protected boolean needsLogging;
    private boolean non2XXAckPassedToListener;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected boolean useRouterForAll;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection<MessageProcessor> messageProcessors;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;
    protected String outboundProxy;
    protected String routerPath;
    protected boolean isAutomaticDialogSupportEnabled;
    protected HashSet<String> forkedEvents;
    protected boolean generateTimeStampHeader;
    protected AddressResolver addressResolver;
    protected int maxListenerResponseTime = -1;
    protected boolean useTlsAccelerator = false;
    protected boolean rfc2543Supported = true;
    protected ThreadAuditor threadAuditor = new ThreadAuditor();
    protected LogRecordFactory logRecordFactory;
    protected boolean cancelClientTransactionChecked = true;
    protected boolean remoteTagReassignmentAllowed = true;

    protected SIPTransactionStack() {
        this.forkedEvents = new HashSet();
        this.messageProcessors = new ArrayList<MessageProcessor>();
        this.ioHandler = new IOHandler(this);
        this.dialogCreatingMethods = new HashSet();
        this.dialogCreatingMethods.add("REFER");
        this.dialogCreatingMethods.add("INVITE");
        this.dialogCreatingMethods.add("SUBSCRIBE");
        this.addressResolver = new DefaultAddressResolver();
        this.dialogTable = new ConcurrentHashMap();
        this.earlyDialogTable = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.timer = new Timer();
        this.pendingTransactions = new ConcurrentHashMap();
        if (this.getThreadAuditor().isEnabled()) {
            this.timer.schedule((TimerTask)new PingTimer(null), 0L);
        }
    }

    protected void reInit() {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Re-initializing !");
        }
        this.messageProcessors = new ArrayList<MessageProcessor>();
        this.ioHandler = new IOHandler(this);
        this.pendingTransactions = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.dialogTable = new ConcurrentHashMap();
        this.earlyDialogTable = new ConcurrentHashMap();
        this.timer = new Timer();
        this.activeClientTransactionCount = new AtomicInteger(0);
    }

    public void disableLogging() {
        this.getLogWriter().disableLogging();
    }

    public void enableLogging() {
        this.getLogWriter().enableLogging();
    }

    public void printDialogTable() {
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("dialog table  = " + this.dialogTable);
            System.out.println("dialog table = " + this.dialogTable);
        }
    }

    public SIPServerTransaction getRetransmissionAlertTransaction(String dialogId) {
        return this.retransmissionAlertTransactions.get(dialogId);
    }

    public boolean isDialogCreated(String method) {
        boolean retval = this.dialogCreatingMethods.contains(method);
        if (this.isLoggingEnabled()) {
            this.getLogWriter().logDebug("isDialogCreated : " + method + " returning " + retval);
        }
        return retval;
    }

    public void addExtensionMethod(String extensionMethod) {
        if (extensionMethod.equals("NOTIFY")) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("NOTIFY Supported Natively");
            }
        } else {
            this.dialogCreatingMethods.add(extensionMethod.trim().toUpperCase());
        }
    }

    public void putDialog(SIPDialog dialog) {
        String dialogId = dialog.getDialogId();
        if (this.dialogTable.containsKey(dialogId)) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("putDialog: dialog already exists" + dialogId + " in table = " + this.dialogTable.get(dialogId));
            }
            return;
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("putDialog dialogId=" + dialogId + " dialog = " + dialog);
        }
        dialog.setStack(this);
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logStackTrace();
        }
        this.dialogTable.put(dialogId, dialog);
    }

    public SIPDialog createDialog(SIPTransaction transaction) {
        SIPDialog retval = null;
        if (transaction instanceof SIPClientTransaction) {
            String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
            if (this.earlyDialogTable.get(dialogId) != null) {
                SIPDialog dialog = this.earlyDialogTable.get(dialogId);
                if (dialog.getState() == null || dialog.getState() == DialogState.EARLY) {
                    retval = dialog;
                } else {
                    retval = new SIPDialog(transaction);
                    this.earlyDialogTable.put(dialogId, retval);
                }
            } else {
                retval = new SIPDialog(transaction);
                this.earlyDialogTable.put(dialogId, retval);
            }
        } else {
            retval = new SIPDialog(transaction);
        }
        return retval;
    }

    public SIPDialog createDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
        SIPDialog retval = null;
        if (this.earlyDialogTable.get(dialogId) != null) {
            retval = this.earlyDialogTable.get(dialogId);
            if (sipResponse.isFinalResponse()) {
                this.earlyDialogTable.remove(dialogId);
            }
        } else {
            retval = new SIPDialog(transaction, sipResponse);
        }
        return retval;
    }

    public void removeDialog(SIPDialog dialog) {
        String id = dialog.getDialogId();
        String earlyId = dialog.getEarlyDialogId();
        if (earlyId != null) {
            this.earlyDialogTable.remove(earlyId);
            this.dialogTable.remove(earlyId);
        }
        if (id != null) {
            SIPDialog old = this.dialogTable.get(id);
            if (old == dialog) {
                this.dialogTable.remove(id);
            }
            if (!dialog.testAndSetIsDialogTerminatedEventDelivered()) {
                DialogTerminatedEvent event = new DialogTerminatedEvent((Object)dialog.getSipProvider(), (Dialog)dialog);
                dialog.getSipProvider().handleEvent((EventObject)event, null);
            }
        }
    }

    public SIPDialog getDialog(String dialogId) {
        SIPDialog sipDialog = this.dialogTable.get(dialogId);
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("getDialog(" + dialogId + ") : returning " + sipDialog);
        }
        return sipDialog;
    }

    public void removeDialog(String dialogId) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logWarning("Silently removing dialog from table");
        }
        if (this.dialogTable.containsKey(dialogId)) {
            this.dialogTable.remove(dialogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest notifyMessage, ListeningPointImpl listeningPoint) {
        SIPClientTransaction sIPClientTransaction;
        SIPClientTransaction retval;
        block12: {
            SIPClientTransaction sIPClientTransaction2;
            block11: {
                SIPClientTransaction sIPClientTransaction3;
                block10: {
                    retval = null;
                    try {
                        Iterator<SIPClientTransaction> it = this.clientTransactionTable.values().iterator();
                        this.logWriter.logDebug("ct table size = " + this.clientTransactionTable.size());
                        String thisToTag = notifyMessage.getTo().getTag();
                        if (thisToTag == null) {
                            SIPClientTransaction sIPClientTransaction4 = retval;
                            Object var19_8 = null;
                            if (!this.isLoggingEnabled()) return sIPClientTransaction4;
                            this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
                            return sIPClientTransaction4;
                        }
                        Event eventHdr = (Event)notifyMessage.getHeader("Event");
                        if (eventHdr == null) {
                            if (this.logWriter.isLoggingEnabled()) {
                                this.logWriter.logDebug("event Header is null -- returning null");
                            }
                            sIPClientTransaction3 = retval;
                            break block10;
                        }
                        while (it.hasNext()) {
                            SIPClientTransaction ct = it.next();
                            if (!ct.getMethod().equals("SUBSCRIBE")) continue;
                            SIPRequest sipRequest = ct.getOriginalRequest();
                            Contact contact = sipRequest.getContactHeader();
                            Address address = contact.getAddress();
                            SipURI uri = (SipURI)address.getURI();
                            String host = uri.getHost();
                            int port = uri.getPort();
                            String transport = uri.getTransportParam();
                            if (transport == null) {
                                transport = "udp";
                            }
                            if (port == -1) {
                                port = transport.equals("udp") || transport.equals("tcp") ? 5060 : 5061;
                            }
                            String fromTag = ct.from.getTag();
                            Event hisEvent = ct.event;
                            if (hisEvent == null) continue;
                            if (this.isLoggingEnabled()) {
                                this.logWriter.logDebug("ct.fromTag = " + fromTag);
                                this.logWriter.logDebug("thisToTag = " + thisToTag);
                                this.logWriter.logDebug("hisEvent = " + hisEvent);
                                this.logWriter.logDebug("eventHdr " + eventHdr);
                            }
                            if (listeningPoint.getPort() != port || !listeningPoint.getIPAddress().equals(host) || !fromTag.equalsIgnoreCase(thisToTag) || hisEvent == null || !eventHdr.match(hisEvent) || !notifyMessage.getCallId().getCallId().equalsIgnoreCase(ct.callId.getCallId())) continue;
                            if (ct.acquireSem()) {
                                retval = ct;
                            }
                            sIPClientTransaction2 = retval;
                            break block11;
                        }
                        sIPClientTransaction = retval;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var19_12 = null;
                        if (!this.isLoggingEnabled()) throw throwable;
                        this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
                        throw throwable;
                    }
                }
                Object var19_9 = null;
                if (!this.isLoggingEnabled()) return sIPClientTransaction3;
                this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
                return sIPClientTransaction3;
            }
            Object var19_10 = null;
            if (!this.isLoggingEnabled()) return sIPClientTransaction2;
            this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
            return sIPClientTransaction2;
        }
        Object var19_11 = null;
        if (!this.isLoggingEnabled()) return sIPClientTransaction;
        this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
        return sIPClientTransaction;
    }

    public SIPTransaction findTransaction(SIPMessage sipMessage, boolean isServer) {
        SIPTransaction retval = null;
        if (isServer) {
            Via via = sipMessage.getTopmostVia();
            if (via.getBranch() != null) {
                String key = sipMessage.getTransactionId();
                retval = this.serverTransactionTable.get(key);
                if (this.logWriter.isLoggingEnabled()) {
                    this.getLogWriter().logDebug("serverTx: looking for key " + key + " existing=" + this.serverTransactionTable);
                }
                if (key.startsWith("z9hg4bk")) {
                    return retval;
                }
            }
            for (SIPServerTransaction sipServerTransaction : this.serverTransactionTable.values()) {
                if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return sipServerTransaction;
            }
        } else {
            Via via = sipMessage.getTopmostVia();
            if (via.getBranch() != null) {
                String key = sipMessage.getTransactionId();
                if (this.logWriter.isLoggingEnabled()) {
                    this.getLogWriter().logDebug("clientTx: looking for key " + key);
                }
                retval = this.clientTransactionTable.get(key);
                if (key.startsWith("z9hg4bk")) {
                    return retval;
                }
            }
            for (SIPClientTransaction clientTransaction : this.clientTransactionTable.values()) {
                if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return clientTransaction;
            }
        }
        return null;
    }

    public SIPTransaction findCancelTransaction(SIPRequest cancelRequest, boolean isServer) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("findCancelTransaction request= \n" + cancelRequest + "\nfindCancelRequest isServer=" + isServer);
        }
        if (isServer) {
            for (SIPTransaction sIPTransaction : this.serverTransactionTable.values()) {
                SIPServerTransaction sipServerTransaction = (SIPServerTransaction)sIPTransaction;
                if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipServerTransaction;
            }
        } else {
            for (SIPTransaction sIPTransaction : this.clientTransactionTable.values()) {
                SIPClientTransaction sipClientTransaction = (SIPClientTransaction)sIPTransaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipClientTransaction;
            }
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    public SIPServerTransaction findPendingTransaction(SIPRequest requestReceived) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("looking for pending tx for :" + requestReceived.getTransactionId());
        }
        return this.pendingTransactions.get(requestReceived.getTransactionId());
    }

    public SIPServerTransaction findMergedTransaction(SIPRequest sipRequest) {
        if (!this.isDialogCreated(sipRequest.getMethod())) {
            return null;
        }
        String mergeId = sipRequest.getMergeId();
        if (mergeId != null) {
            return this.mergeTable.get(mergeId);
        }
        return null;
    }

    public void removePendingTransaction(SIPServerTransaction tr) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("removePendingTx: " + tr.getTransactionId());
        }
        this.pendingTransactions.remove(tr.getTransactionId());
    }

    public void removeFromMergeTable(SIPServerTransaction tr) {
        String key;
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Removing tx from merge table ");
        }
        if ((key = ((SIPRequest)tr.getRequest()).getMergeId()) != null) {
            this.mergeTable.remove(key);
        }
    }

    public void putInMergeTable(SIPServerTransaction sipTransaction, SIPRequest sipRequest) {
        String mergeKey = sipRequest.getMergeId();
        if (mergeKey != null) {
            this.mergeTable.put(mergeKey, sipTransaction);
        }
    }

    public void mapTransaction(SIPServerTransaction transaction) {
        if (transaction.isMapped) {
            return;
        }
        this.addTransactionHash(transaction);
        transaction.isMapped = true;
    }

    public ServerRequestInterface newSIPServerRequest(SIPRequest requestReceived, MessageChannel requestMessageChannel) {
        String key = requestReceived.getTransactionId();
        requestReceived.setMessageChannel(requestMessageChannel);
        SIPServerTransaction currentTransaction = this.serverTransactionTable.get(key);
        if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(requestReceived)) {
            Iterator<SIPServerTransaction> transactionIterator = this.serverTransactionTable.values().iterator();
            currentTransaction = null;
            if (!key.toLowerCase().startsWith("z9hg4bk")) {
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPServerTransaction nextTransaction = transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
            }
            if (currentTransaction == null) {
                currentTransaction = this.findPendingTransaction(requestReceived);
                if (currentTransaction != null) {
                    requestReceived.setTransaction(currentTransaction);
                    if (currentTransaction != null && currentTransaction.acquireSem()) {
                        return currentTransaction;
                    }
                    return null;
                }
                currentTransaction = this.createServerTransaction(requestMessageChannel);
                if (currentTransaction != null) {
                    currentTransaction.setOriginalRequest(requestReceived);
                    requestReceived.setTransaction(currentTransaction);
                }
            }
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("newSIPServerRequest( " + requestReceived.getMethod() + ":" + requestReceived.getTopmostVia().getBranch() + "):" + currentTransaction);
        }
        if (currentTransaction != null) {
            currentTransaction.setRequestInterface(this.sipMessageFactory.newSIPServerRequest(requestReceived, currentTransaction));
        }
        if (currentTransaction != null && currentTransaction.acquireSem()) {
            return currentTransaction;
        }
        if (currentTransaction != null) {
            try {
                if (currentTransaction.isMessagePartOfTransaction(requestReceived) && currentTransaction.getMethod().equals(requestReceived.getMethod())) {
                    SIPResponse trying = requestReceived.createResponse(100);
                    trying.removeContent();
                    currentTransaction.getMessageChannel().sendMessage(trying);
                }
            }
            catch (Exception ex) {
                this.logWriter.logError("Exception occured sending TRYING");
            }
            return null;
        }
        return null;
    }

    protected ServerResponseInterface newSIPServerResponse(SIPResponse responseReceived, MessageChannel responseMessageChannel) {
        String key = responseReceived.getTransactionId();
        SIPClientTransaction currentTransaction = this.clientTransactionTable.get(key);
        if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(responseReceived) && !key.startsWith("z9hg4bk")) {
            Iterator<SIPClientTransaction> transactionIterator = this.clientTransactionTable.values().iterator();
            currentTransaction = null;
            while (transactionIterator.hasNext() && currentTransaction == null) {
                SIPClientTransaction nextTransaction = transactionIterator.next();
                if (!nextTransaction.isMessagePartOfTransaction(responseReceived)) continue;
                currentTransaction = nextTransaction;
            }
            if (currentTransaction == null) {
                if (this.logWriter.isLoggingEnabled(16)) {
                    responseMessageChannel.logResponse(responseReceived, System.currentTimeMillis(), "before processing");
                }
                return this.sipMessageFactory.newSIPServerResponse(responseReceived, responseMessageChannel);
            }
        }
        boolean acquired = currentTransaction.acquireSem();
        if (this.logWriter.isLoggingEnabled(16)) {
            currentTransaction.logResponse(responseReceived, System.currentTimeMillis(), "before processing");
        }
        if (acquired) {
            ServerResponseInterface sri = this.sipMessageFactory.newSIPServerResponse(responseReceived, currentTransaction);
            if (sri != null) {
                currentTransaction.setResponseInterface(sri);
            } else {
                if (this.logWriter.isLoggingEnabled()) {
                    this.logWriter.logDebug("returning null - serverResponseInterface is null!");
                }
                currentTransaction.releaseSem();
                return null;
            }
        }
        if (acquired) {
            return currentTransaction;
        }
        return null;
    }

    public MessageChannel createMessageChannel(SIPRequest request, MessageProcessor mp, Hop nextHop) throws IOException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel mc = mp.createMessageChannel(targetHostPort);
        if (mc == null) {
            return null;
        }
        SIPClientTransaction returnChannel = this.createClientTransaction(request, mc);
        returnChannel.setViaPort(nextHop.getPort());
        returnChannel.setViaHost(nextHop.getHost());
        this.addTransactionHash(returnChannel);
        return returnChannel;
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sipRequest, MessageChannel encapsulatedMessageChannel) {
        SIPClientTransaction ct = new SIPClientTransaction(this, encapsulatedMessageChannel);
        ct.setOriginalRequest(sipRequest);
        return ct;
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        boolean decision;
        if (this.unlimitedServerTransactionTableSize || this.serverTransactionTable.size() < this.serverTransactionTableLowaterMark) {
            return new SIPServerTransaction(this, encapsulatedMessageChannel);
        }
        if (this.serverTransactionTable.size() >= this.serverTransactionTableHighwaterMark) {
            return null;
        }
        float threshold = (float)(this.serverTransactionTable.size() - this.serverTransactionTableLowaterMark) / (float)(this.serverTransactionTableHighwaterMark - this.serverTransactionTableLowaterMark);
        boolean bl = decision = Math.random() > 1.0 - (double)threshold;
        if (decision) {
            return null;
        }
        return new SIPServerTransaction(this, encapsulatedMessageChannel);
    }

    public int getClientTransactionTableSize() {
        return this.clientTransactionTable.size();
    }

    public void addTransaction(SIPClientTransaction clientTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("added transaction " + clientTransaction);
        }
        this.addTransactionHash(clientTransaction);
    }

    public void removeTransaction(SIPTransaction sipTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Removing Transaction = " + sipTransaction.getTransactionId() + " transaction = " + sipTransaction);
        }
        if (sipTransaction instanceof SIPServerTransaction) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logStackTrace();
            }
            String key = sipTransaction.getTransactionId();
            SIPServerTransaction removed = this.serverTransactionTable.remove(key);
            String method = sipTransaction.getMethod();
            this.removePendingTransaction((SIPServerTransaction)sipTransaction);
            if (this.isDialogCreated(method)) {
                this.removeFromMergeTable((SIPServerTransaction)sipTransaction);
            }
            SipProviderImpl sipProvider = sipTransaction.getSipProvider();
            if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ServerTransaction)sipTransaction);
                sipProvider.handleEvent((EventObject)event, sipTransaction);
            }
        } else {
            String key = sipTransaction.getTransactionId();
            SIPClientTransaction removed = this.clientTransactionTable.remove(key);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("REMOVED client tx " + removed + " KEY = " + key);
            }
            if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                SipProviderImpl sipProvider = sipTransaction.getSipProvider();
                TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ClientTransaction)sipTransaction);
                sipProvider.handleEvent((EventObject)event, sipTransaction);
            }
        }
    }

    public void addTransaction(SIPServerTransaction serverTransaction) throws IOException {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("added transaction " + serverTransaction);
        }
        serverTransaction.map();
        this.addTransactionHash(serverTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipTransaction instanceof SIPClientTransaction) {
            if (!this.unlimitedClientTransactionTableSize) {
                if (this.activeClientTransactionCount.get() > this.clientTransactionTableHiwaterMark) {
                    try {
                        ConcurrentHashMap<String, SIPClientTransaction> concurrentHashMap = this.clientTransactionTable;
                        synchronized (concurrentHashMap) {
                            this.clientTransactionTable.wait();
                            this.activeClientTransactionCount.incrementAndGet();
                        }
                    }
                    catch (Exception ex) {
                        if (this.logWriter.isLoggingEnabled()) {
                            this.logWriter.logError("Exception occured while waiting for room", ex);
                        }
                    }
                }
            } else {
                this.activeClientTransactionCount.incrementAndGet();
            }
            String key = sipRequest.getTransactionId();
            this.clientTransactionTable.put(key, (SIPClientTransaction)sipTransaction);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug(" putTransactionHash :  key = " + key);
            }
        } else {
            String key = sipRequest.getTransactionId();
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug(" putTransactionHash :  key = " + key);
            }
            this.serverTransactionTable.put(key, (SIPServerTransaction)sipTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementActiveClientTransactionCount() {
        if (this.activeClientTransactionCount.decrementAndGet() <= this.clientTransactionTableLowaterMark && !this.unlimitedClientTransactionTableSize) {
            ConcurrentHashMap<String, SIPClientTransaction> concurrentHashMap = this.clientTransactionTable;
            synchronized (concurrentHashMap) {
                this.clientTransactionTable.notify();
            }
        }
    }

    protected void removeTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipRequest == null) {
            return;
        }
        if (sipTransaction instanceof SIPClientTransaction) {
            String key = sipTransaction.getTransactionId();
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logStackTrace();
                this.logWriter.logDebug("removing client Tx : " + key);
            }
            this.clientTransactionTable.remove(key);
        } else if (sipTransaction instanceof SIPServerTransaction) {
            String key = sipTransaction.getTransactionId();
            this.serverTransactionTable.remove(key);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("removing server Tx : " + key);
            }
        }
    }

    @Override
    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            transaction.setState(SIPTransaction.TERMINATED_STATE);
            if (transaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)transaction).collectionTime = 0;
            }
            transaction.disableTimeoutTimer();
            transaction.disableRetransmissionTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.pendingTransactions.clear();
        this.toExit = true;
        Collection<MessageProcessor> collection = this;
        synchronized (collection) {
            this.notifyAll();
        }
        collection = this.clientTransactionTable;
        synchronized (collection) {
            this.clientTransactionTable.notifyAll();
        }
        collection = this.messageProcessors;
        synchronized (collection) {
            MessageProcessor[] processorList = this.getMessageProcessors();
            for (int processorIndex = 0; processorIndex < processorList.length; ++processorIndex) {
                this.removeMessageProcessor(processorList[processorIndex]);
            }
            this.ioHandler.closeAll();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clientTransactionTable.clear();
        this.serverTransactionTable.clear();
        this.dialogTable.clear();
        this.serverLog.closeLogFile();
    }

    public void putPendingTransaction(SIPServerTransaction tr) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("putPendingTransaction: " + tr);
        }
        this.pendingTransactions.put(tr.getTransactionId(), tr);
    }

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public boolean isLoggingEnabled() {
        return this.logWriter == null ? false : this.logWriter.isLoggingEnabled();
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public ServerLog getServerLog() {
        return this.serverLog;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public Hop getNextHop(SIPRequest sipRequest) throws SipException {
        if (this.useRouterForAll) {
            if (this.router != null) {
                return this.router.getNextHop((Request)sipRequest);
            }
            return null;
        }
        if (sipRequest.getRequestURI().isSipURI() || sipRequest.getRouteHeaders() != null) {
            return this.defaultRouter.getNextHop(sipRequest);
        }
        if (this.router != null) {
            return this.router.getNextHop((Request)sipRequest);
        }
        return null;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public Server createServerHeaderForStack() {
        Server retval = new Server();
        retval.addProductToken(this.stackName);
        return retval;
    }

    protected void setHostAddress(String stackAddress) throws UnknownHostException {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
        this.stackInetAddress = InetAddress.getByName(stackAddress);
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    protected void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter(SIPRequest request) {
        if (request.getRequestLine() == null) {
            return this.defaultRouter;
        }
        if (this.useRouterForAll) {
            return this.router;
        }
        if (request.getRequestURI().getScheme().equals("sip") || request.getRequestURI().getScheme().equals("sips")) {
            return this.defaultRouter;
        }
        if (this.router != null) {
            return this.router;
        }
        return this.defaultRouter;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        Collection<MessageProcessor> collection = this.messageProcessors;
        synchronized (collection) {
            this.messageProcessors.add(newMessageProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        Collection<MessageProcessor> collection = this.messageProcessors;
        synchronized (collection) {
            if (this.messageProcessors.remove(oldMessageProcessor)) {
                oldMessageProcessor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageProcessor[] getMessageProcessors() {
        Collection<MessageProcessor> collection = this.messageProcessors;
        synchronized (collection) {
            return this.messageProcessors.toArray(new MessageProcessor[0]);
        }
    }

    protected MessageProcessor createMessageProcessor(InetAddress ipAddress, int port, String transport) throws IOException {
        if (transport.equalsIgnoreCase("udp")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(udpMessageProcessor);
            this.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tcp")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(tcpMessageProcessor);
            return tcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tls")) {
            TLSMessageProcessor tlsMessageProcessor = new TLSMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(tlsMessageProcessor);
            return tlsMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(StackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createRawMessageChannel(String sourceIpAddress, int sourcePort, Hop nextHop) throws UnknownHostException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Iterator<MessageProcessor> processorIterator = this.messageProcessors.iterator();
        while (processorIterator.hasNext() && newChannel == null) {
            MessageProcessor nextProcessor = processorIterator.next();
            if (!nextHop.getTransport().equalsIgnoreCase(nextProcessor.getTransport()) || !sourceIpAddress.equals(nextProcessor.getIpAddress().getHostAddress()) || sourcePort != nextProcessor.getPort()) continue;
            try {
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (UnknownHostException ex) {
                if (this.logWriter.isLoggingEnabled()) {
                    this.logWriter.logException(ex);
                }
                throw ex;
            }
            catch (IOException e) {
                if (!this.logWriter.isLoggingEnabled()) continue;
                this.logWriter.logException(e);
            }
        }
        return newChannel;
    }

    public boolean isEventForked(String ename) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("isEventForked: " + ename + " returning " + this.forkedEvents.contains(ename));
        }
        return this.forkedEvents.contains(ename);
    }

    public AddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public void setLogRecordFactory(LogRecordFactory logRecordFactory) {
        this.logRecordFactory = logRecordFactory;
    }

    public ThreadAuditor getThreadAuditor() {
        return this.threadAuditor;
    }

    public String auditStack(Set activeCallIDs, long leakedDialogTimer, long leakedTransactionTimer) {
        String auditReport = null;
        String leakedDialogs = this.auditDialogs(activeCallIDs, leakedDialogTimer);
        String leakedServerTransactions = this.auditTransactions(this.serverTransactionTable, leakedTransactionTimer);
        String leakedClientTransactions = this.auditTransactions(this.clientTransactionTable, leakedTransactionTimer);
        if (leakedDialogs != null || leakedServerTransactions != null || leakedClientTransactions != null) {
            auditReport = "SIP Stack Audit:\n" + (leakedDialogs != null ? leakedDialogs : "") + (leakedServerTransactions != null ? leakedServerTransactions : "") + (leakedClientTransactions != null ? leakedClientTransactions : "");
        }
        return auditReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String auditDialogs(Set activeCallIDs, long leakedDialogTimer) {
        LinkedList<SIPDialog> dialogs;
        String auditReport = "  Leaked dialogs:\n";
        int leakedDialogs = 0;
        long currentTime = System.currentTimeMillis();
        ConcurrentHashMap<String, SIPDialog> concurrentHashMap = this.dialogTable;
        synchronized (concurrentHashMap) {
            dialogs = new LinkedList<SIPDialog>(this.dialogTable.values());
        }
        for (SIPDialog itDialog : dialogs) {
            CallIdHeader callIdHeader = itDialog != null ? itDialog.getCallId() : null;
            String callID = callIdHeader != null ? callIdHeader.getCallId() : null;
            if (callID == null || activeCallIDs.contains(callID)) continue;
            if (itDialog.auditTag == 0L) {
                itDialog.auditTag = currentTime;
                continue;
            }
            if (currentTime - itDialog.auditTag < leakedDialogTimer) continue;
            ++leakedDialogs;
            DialogState dialogState = itDialog.getState();
            String dialogReport = "dialog id: " + itDialog.getDialogId() + ", dialog state: " + (dialogState != null ? dialogState.toString() : "null");
            auditReport = auditReport + "    " + dialogReport + "\n";
            itDialog.setState(3);
            this.logWriter.logDebug("auditDialogs: leaked " + dialogReport);
        }
        auditReport = leakedDialogs > 0 ? auditReport + "    Total: " + Integer.toString(leakedDialogs) + " leaked dialogs detected and removed.\n" : null;
        return auditReport;
    }

    private String auditTransactions(ConcurrentHashMap transactionsMap, long a_nLeakedTransactionTimer) {
        String auditReport = "  Leaked transactions:\n";
        int leakedTransactions = 0;
        long currentTime = System.currentTimeMillis();
        LinkedList transactionsList = new LinkedList(transactionsMap.values());
        for (SIPTransaction sipTransaction : transactionsList) {
            if (sipTransaction == null) continue;
            if (sipTransaction.auditTag == 0L) {
                sipTransaction.auditTag = currentTime;
                continue;
            }
            if (currentTime - sipTransaction.auditTag < a_nLeakedTransactionTimer) continue;
            ++leakedTransactions;
            TransactionState transactionState = sipTransaction.getState();
            SIPRequest origRequest = sipTransaction.getOriginalRequest();
            String origRequestMethod = origRequest != null ? origRequest.getMethod() : null;
            String transactionReport = sipTransaction.getClass().getName() + ", state: " + (transactionState != null ? transactionState.toString() : "null") + ", OR: " + (origRequestMethod != null ? origRequestMethod : "null");
            auditReport = auditReport + "    " + transactionReport + "\n";
            this.removeTransaction(sipTransaction);
            this.logWriter.logDebug("auditTransactions: leaked " + transactionReport);
        }
        auditReport = leakedTransactions > 0 ? auditReport + "    Total: " + Integer.toString(leakedTransactions) + " leaked transactions detected and removed.\n" : null;
        return auditReport;
    }

    public void setNon2XXAckPassedToListener(boolean passToListener) {
        this.non2XXAckPassedToListener = passToListener;
    }

    public boolean isNon2XXAckPassedToListener() {
        return this.non2XXAckPassedToListener;
    }

    public int getActiveClientTransactionCount() {
        return this.activeClientTransactionCount.get();
    }

    public boolean isRfc2543Supported() {
        return this.rfc2543Supported;
    }

    public boolean isCancelClientTransactionChecked() {
        return this.cancelClientTransactionChecked;
    }

    public boolean isRemoteTagReassignmentAllowed() {
        return this.remoteTagReassignmentAllowed;
    }

    public Collection<Dialog> getDialogs() {
        HashSet<Dialog> dialogs = new HashSet<Dialog>();
        dialogs.addAll(this.dialogTable.values());
        dialogs.addAll(this.earlyDialogTable.values());
        return dialogs;
    }

    public Collection<Dialog> getDialogs(DialogState state) {
        HashSet<Dialog> matchingDialogs = new HashSet<Dialog>();
        if (DialogState.EARLY.equals((Object)state)) {
            matchingDialogs.addAll(this.earlyDialogTable.values());
        } else {
            Collection<SIPDialog> dialogs = this.dialogTable.values();
            for (SIPDialog dialog : dialogs) {
                if (dialog.getState() == null || !dialog.getState().equals((Object)state)) continue;
                matchingDialogs.add(dialog);
            }
        }
        return matchingDialogs;
    }

    public Dialog getReplacesDialog(ReplacesHeader replacesHeader) {
        String cid = replacesHeader.getCallId();
        String fromTag = replacesHeader.getFromTag();
        String toTag = replacesHeader.getToTag();
        StringBuffer retval = new StringBuffer(cid);
        if (toTag != null) {
            retval.append(":");
            retval.append(toTag);
        }
        if (fromTag != null) {
            retval.append(":");
            retval.append(fromTag);
        }
        return this.dialogTable.get(retval.toString().toLowerCase());
    }

    public Dialog getJoinDialog(JoinHeader joinHeader) {
        String cid = joinHeader.getCallId();
        String fromTag = joinHeader.getFromTag();
        String toTag = joinHeader.getToTag();
        StringBuffer retval = new StringBuffer(cid);
        if (toTag != null) {
            retval.append(":");
            retval.append(toTag);
        }
        if (fromTag != null) {
            retval.append(":");
            retval.append(fromTag);
        }
        return this.dialogTable.get(retval.toString().toLowerCase());
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    class PingTimer
    extends SIPStackTimerTask {
        ThreadAuditor.ThreadHandle threadHandle;

        public PingTimer(ThreadAuditor.ThreadHandle a_oThreadHandle) {
            this.threadHandle = a_oThreadHandle;
        }

        protected void runTask() {
            if (SIPTransactionStack.this.getTimer() != null) {
                if (this.threadHandle == null) {
                    this.threadHandle = SIPTransactionStack.this.getThreadAuditor().addCurrentThread();
                }
                this.threadHandle.ping();
                SIPTransactionStack.this.getTimer().schedule((TimerTask)new PingTimer(this.threadHandle), this.threadHandle.getPingIntervalInMillisecs());
            }
        }
    }
}

