/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.Collection;
import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.ClientHolder;
import org.jboss.remoting.ConnectionNotifier;
import org.jboss.remoting.util.TimerUtil;

public class Lease {
    private ConnectionNotifier notifier = null;
    private String clientSessionId = null;
    private long leasePeriod = -1L;
    private String locatorURL = null;
    private Map requestPayload = null;
    private LeaseTimerTask leaseTimerTask = null;
    private long leaseWindow = -1L;
    private long pingStart = -1L;
    private Map clientLeases = null;
    private boolean leaseUpdated = false;
    private static final Logger log = Logger.getLogger(Lease.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();

    public Lease(String clientSessionId, long leasePeriod, String locatorurl, Map requestPayload, ConnectionNotifier notifier, Map clientLeases) {
        this.clientSessionId = clientSessionId;
        this.leasePeriod = leasePeriod;
        this.notifier = notifier;
        this.locatorURL = locatorurl;
        if (requestPayload != null) {
            this.requestPayload = (Map)requestPayload.get("ClientHolderKey");
        }
        this.leaseWindow = leasePeriod * 2L;
        this.clientLeases = clientLeases;
    }

    public void startLease() {
        if (isTraceEnabled) {
            log.trace("Starting lease for client invoker (session id = " + this.clientSessionId + ") with lease window time of " + this.leaseWindow);
        }
        this.leaseTimerTask = new LeaseTimerTask();
        TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
    }

    public void updateLease(long leasePeriod, Map requestMap) {
        if (requestMap != null) {
            this.requestPayload = (Map)requestMap.get("ClientHolderKey");
        }
        this.updateLease(leasePeriod);
    }

    public void updateLease(long leasePeriod) {
        long pingDuration;
        this.leaseUpdated = true;
        if (leasePeriod != this.leasePeriod) {
            this.leasePeriod = leasePeriod;
            this.leaseWindow = leasePeriod * 2L;
            this.stopLease();
            this.startLease();
            if (isTraceEnabled) {
                log.trace("Lease for client invoker (session id = " + this.clientSessionId + ") updated with new lease window of " + this.leaseWindow + ".  Resetting timer.");
            }
        } else if (this.pingStart != -1L && (double)(pingDuration = System.currentTimeMillis() - this.pingStart) > 0.75 * (double)this.leaseWindow) {
            this.leaseWindow = pingDuration * 2L;
            this.stopLease();
            this.leaseTimerTask = new LeaseTimerTask();
            TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
        }
        this.pingStart = System.currentTimeMillis();
    }

    public void terminateLease(String sessionId) {
        if (isTraceEnabled) {
            log.trace("Terminating lease for session id " + sessionId);
        }
        if (this.clientSessionId.equals(sessionId)) {
            this.stopLease();
            this.notifyClientTermination(null);
        } else {
            this.notifyClientTermination(sessionId);
        }
    }

    private void notifyClientTermination(String sessionId) {
        if (this.requestPayload != null) {
            if (sessionId != null) {
                Object clientHolderObj = this.requestPayload.remove(sessionId);
                if (clientHolderObj != null && clientHolderObj instanceof ClientHolder) {
                    ClientHolder clientHolder = (ClientHolder)clientHolderObj;
                    this.notifier.connectionTerminated(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
                    if (isTraceEnabled) {
                        log.trace("Notified connection listener of lease termination due to disconnect from client (client session id = " + clientHolder.getSessionId());
                    }
                }
            } else {
                Collection clientHoldersCol = this.requestPayload.values();
                if (clientHoldersCol != null && clientHoldersCol.size() > 0) {
                    for (Object val : clientHoldersCol) {
                        if (val == null || !(val instanceof ClientHolder)) continue;
                        ClientHolder clientHolder = (ClientHolder)val;
                        this.notifier.connectionTerminated(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
                        if (!isTraceEnabled) continue;
                        log.trace("Notified connection listener of lease termination due to disconnect from client (client session id = " + clientHolder.getSessionId());
                    }
                }
            }
        } else {
            log.warn("Tried to terminate lease for session id " + sessionId + ", but no collection of clients have been set.");
        }
    }

    private void notifyClientLost() {
        if (this.requestPayload != null) {
            Collection clientHoldersCol = this.requestPayload.values();
            if (clientHoldersCol != null && clientHoldersCol.size() > 0) {
                for (Object val : clientHoldersCol) {
                    if (val == null || !(val instanceof ClientHolder)) continue;
                    ClientHolder clientHolder = (ClientHolder)val;
                    this.notifier.connectionLost(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
                    if (!isTraceEnabled) continue;
                    log.trace("Notified connection listener of lease expired due to lost connection from client (client session id = " + clientHolder.getSessionId());
                }
            }
        } else {
            this.notifier.connectionTerminated(this.locatorURL, this.clientSessionId, null);
        }
    }

    private void stopLease() {
        this.leaseTimerTask.cancel();
    }

    private class LeaseTimerTask
    extends TimerTask {
        private LeaseTimerTask() {
        }

        public void run() {
            if (Lease.this.leaseUpdated) {
                Lease.this.leaseUpdated = false;
            } else {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("did not receive ping: " + Lease.this.clientSessionId);
                    }
                    Lease.this.stopLease();
                    Lease.this.notifyClientLost();
                    if (Lease.this.clientLeases != null) {
                        Lease.this.clientLeases.remove(Lease.this.clientSessionId);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("removed lease:" + Lease.this.clientSessionId);
                    }
                }
                catch (Throwable thr) {
                    log.error("Error terminating client lease and sending notification of lost client.", thr);
                }
            }
        }
    }
}

