/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;
    protected Vector nodes;
    protected NodeImpl ownerNode;

    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public void removeAll() {
        if (this.nodes != null) {
            this.nodes.removeAllElements();
        }
    }

    final boolean changed() {
        return (this.flags & 2) != 0;
    }

    boolean getReadOnly() {
        return this.isReadOnly();
    }

    final boolean hasDefaults() {
        return (this.flags & 4) != 0;
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    protected void removeItem(int index) {
        if (this.nodes != null && index < this.nodes.size()) {
            this.nodes.removeElementAt(index);
        }
    }

    final void changed(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final void hasDefaults(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    final void isReadOnly(boolean value) {
        this.flags = (short)(value ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    void setReadOnly(boolean readOnly, boolean deep) {
        this.isReadOnly(readOnly);
        if (deep && this.nodes != null) {
            int i = this.nodes.size() - 1;
            while (i >= 0) {
                ((NodeImpl)this.nodes.elementAt(i)).setReadOnly(readOnly, deep);
                --i;
            }
        }
    }

    void setOwnerDocument(CoreDocumentImpl doc) {
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                ((NodeImpl)this.item(i)).setOwnerDocument(doc);
                ++i;
            }
        }
    }

    protected void cloneContent(NamedNodeMapImpl srcmap) {
        int size;
        Vector srcnodes = srcmap.nodes;
        if (srcnodes != null && (size = srcnodes.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(size);
            }
            this.nodes.setSize(size);
            int i = 0;
            while (i < size) {
                NodeImpl n = (NodeImpl)srcmap.nodes.elementAt(i);
                NodeImpl clone = (NodeImpl)n.cloneNode(true);
                clone.isSpecified(n.isSpecified());
                this.nodes.setElementAt(clone, i);
                ++i;
            }
        }
    }

    protected NamedNodeMapImpl(NodeImpl ownerNode) {
        this.ownerNode = ownerNode;
    }

    protected Object getItem(int index) {
        if (this.nodes != null) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    protected int findNamePoint(String name, int start) {
        int i = 0;
        if (this.nodes != null) {
            int first = start;
            int last = this.nodes.size() - 1;
            while (first <= last) {
                i = (first + last) / 2;
                int test = name.compareTo(((Node)this.nodes.elementAt(i)).getNodeName());
                if (test == 0) {
                    return i;
                }
                if (test < 0) {
                    last = i - 1;
                    continue;
                }
                first = i + 1;
            }
            if (first > i) {
                i = first;
            }
        }
        return -1 - i;
    }

    public Node item(int index) {
        return this.nodes != null && index < this.nodes.size() ? (Node)this.nodes.elementAt(index) : null;
    }

    protected int addItem(Node arg) {
        int i = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                previous = (NodeImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        return i;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl ownerNode) {
        NamedNodeMapImpl newmap = new NamedNodeMapImpl(ownerNode);
        newmap.cloneContent(this);
        return newmap;
    }

    protected int findNamePoint(String namespaceURI, String name) {
        if (this.nodes == null) {
            return -1;
        }
        if (name == null) {
            return -1;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            NodeImpl a = (NodeImpl)this.nodes.elementAt(i);
            String aNamespaceURI = a.getNamespaceURI();
            String aLocalName = a.getLocalName();
            if (namespaceURI == null ? aNamespaceURI == null && (name.equals(aLocalName) || aLocalName == null && name.equals(a.getNodeName())) : namespaceURI.equals(aNamespaceURI) && name.equals(aLocalName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getNamedItemIndex(String namespaceURI, String localName) {
        return this.findNamePoint(namespaceURI, localName);
    }

    protected Vector cloneMap(Vector list) {
        if (list == null) {
            list = new Vector(5, 10);
        }
        list.setSize(0);
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                list.insertElementAt(this.nodes.elementAt(i), i);
                ++i;
            }
        }
        return list;
    }

    public Node getNamedItem(String name) {
        int i = this.findNamePoint(name, 0);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    public Node removeNamedItem(String name) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i = this.findNamePoint(name, 0);
        if (i < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    public Node setNamedItem(Node arg) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        int i = this.findNamePoint(arg.getNodeName(), 0);
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = -1 - i;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(arg, i);
        }
        return previous;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        int i = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                previous = (NodeImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        return previous;
    }

    protected boolean precedes(Node a, Node b) {
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                Node n = (Node)this.nodes.elementAt(i);
                if (n == a) {
                    return true;
                }
                if (n == b) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        int i = this.findNamePoint(namespaceURI, localName);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i = this.findNamePoint(namespaceURI, name);
        if (i < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }
}

