/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XSGrammarBucket {
    Hashtable fGrammarRegistry = new Hashtable();
    SchemaGrammar fNoNSGrammar = null;

    public void reset() {
        this.fNoNSGrammar = null;
        this.fGrammarRegistry.clear();
    }

    public SchemaGrammar[] getGrammars() {
        int count = this.fGrammarRegistry.size() + (this.fNoNSGrammar == null ? 0 : 1);
        SchemaGrammar[] grammars = new SchemaGrammar[count];
        Enumeration schemas = this.fGrammarRegistry.elements();
        int i = 0;
        while (schemas.hasMoreElements()) {
            grammars[i++] = (SchemaGrammar)schemas.nextElement();
        }
        if (this.fNoNSGrammar != null) {
            grammars[count - 1] = this.fNoNSGrammar;
        }
        return grammars;
    }

    public void putGrammar(SchemaGrammar grammar) {
        if (grammar.getTargetNamespace() == null) {
            this.fNoNSGrammar = grammar;
        } else {
            this.fGrammarRegistry.put(grammar.getTargetNamespace(), grammar);
        }
    }

    public boolean putGrammar(SchemaGrammar grammar, boolean deep) {
        SchemaGrammar sg = this.getGrammar(grammar.fTargetNamespace);
        if (sg != null) {
            return sg == grammar;
        }
        if (!deep) {
            this.putGrammar(grammar);
            return true;
        }
        Vector currGrammars = grammar.getImportedGrammars();
        if (currGrammars == null) {
            this.putGrammar(grammar);
            return true;
        }
        Vector grammars = (Vector)currGrammars.clone();
        int i = 0;
        while (i < grammars.size()) {
            SchemaGrammar sg1 = (SchemaGrammar)grammars.elementAt(i);
            SchemaGrammar sg2 = this.getGrammar(sg1.fTargetNamespace);
            if (sg2 == null) {
                Vector gs = sg1.getImportedGrammars();
                if (gs != null) {
                    int j = gs.size() - 1;
                    while (j >= 0) {
                        sg2 = (SchemaGrammar)gs.elementAt(j);
                        if (!grammars.contains(sg2)) {
                            grammars.addElement(sg2);
                        }
                        --j;
                    }
                }
            } else if (sg2 != sg1) {
                return false;
            }
            ++i;
        }
        this.putGrammar(grammar);
        int i2 = grammars.size() - 1;
        while (i2 >= 0) {
            this.putGrammar((SchemaGrammar)grammars.elementAt(i2));
            --i2;
        }
        return true;
    }

    public SchemaGrammar getGrammar(String namespace) {
        if (namespace == null) {
            return this.fNoNSGrammar;
        }
        return (SchemaGrammar)this.fGrammarRegistry.get(namespace);
    }
}

