/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.dom.ASModelImpl;
import com.sun.org.apache.xerces.internal.dom3.as.ASModel;
import com.sun.org.apache.xerces.internal.dom3.as.DOMASBuilder;
import com.sun.org.apache.xerces.internal.dom3.as.DOMASException;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.XSGrammarBucket;
import com.sun.org.apache.xerces.internal.parsers.DOMParserImpl;
import com.sun.org.apache.xerces.internal.parsers.XMLGrammarCachingConfiguration;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.util.Vector;
import org.w3c.dom.ls.LSInput;

public class DOMASBuilderImpl
extends DOMParserImpl
implements DOMASBuilder {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected XSGrammarBucket fGrammarBucket;
    protected ASModelImpl fAbstractSchema;

    public DOMASBuilderImpl() {
        super(new XMLGrammarCachingConfiguration());
    }

    private void initGrammarBucket() {
        this.fGrammarBucket.reset();
        if (this.fAbstractSchema != null) {
            this.initGrammarBucketRecurse(this.fAbstractSchema);
        }
    }

    private void initGrammarBucketRecurse(ASModelImpl currModel) {
        if (currModel.getGrammar() != null) {
            this.fGrammarBucket.putGrammar(currModel.getGrammar());
        }
        int i = 0;
        while (i < currModel.getInternalASModels().size()) {
            ASModelImpl nextModel = (ASModelImpl)currModel.getInternalASModels().elementAt(i);
            this.initGrammarBucketRecurse(nextModel);
            ++i;
        }
    }

    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    public void setAbstractSchema(ASModel abstractSchema) {
        this.fAbstractSchema = (ASModelImpl)abstractSchema;
        XMLGrammarPool grammarPool = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        if (grammarPool == null) {
            grammarPool = new XMLGrammarPoolImpl();
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
        }
        if (this.fAbstractSchema != null) {
            this.initGrammarPool(this.fAbstractSchema, grammarPool);
        }
    }

    public DOMASBuilderImpl(XMLGrammarCachingConfiguration config) {
        super(config);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new XMLGrammarCachingConfiguration(symbolTable));
    }

    ASModel parseASInputSource(XMLInputSource is) throws Exception {
        if (this.fGrammarBucket == null) {
            this.fGrammarBucket = new XSGrammarBucket();
        }
        this.initGrammarBucket();
        XMLGrammarCachingConfiguration gramConfig = (XMLGrammarCachingConfiguration)this.fConfiguration;
        gramConfig.lockGrammarPool();
        SchemaGrammar grammar = gramConfig.parseXMLSchema(is);
        gramConfig.unlockGrammarPool();
        ASModelImpl newAsModel = null;
        if (grammar != null) {
            newAsModel = new ASModelImpl();
            this.fGrammarBucket.putGrammar(grammar, true);
            this.addGrammars(newAsModel, this.fGrammarBucket);
        }
        return newAsModel;
    }

    public ASModel parseASURI(String uri) throws DOMASException, Exception {
        XMLInputSource source = new XMLInputSource(null, uri, null);
        return this.parseASInputSource(source);
    }

    public ASModel parseASInputSource(LSInput is) throws DOMASException, Exception {
        XMLInputSource xis = this.dom2xmlInputSource(is);
        try {
            return this.parseASInputSource(xis);
        }
        catch (XNIException e) {
            Exception ex = e.getException();
            throw ex;
        }
    }

    private void addGrammars(ASModelImpl model, XSGrammarBucket grammarBucket) {
        SchemaGrammar[] grammarList = grammarBucket.getGrammars();
        int i = 0;
        while (i < grammarList.length) {
            ASModelImpl newModel = new ASModelImpl();
            newModel.setGrammar(grammarList[i]);
            model.addASModel(newModel);
            ++i;
        }
    }

    private void initGrammarPool(ASModelImpl currModel, XMLGrammarPool grammarPool) {
        Grammar[] grammars = new Grammar[1];
        grammars[0] = currModel.getGrammar();
        if (grammars[0] != null) {
            grammarPool.cacheGrammars(grammars[0].getGrammarDescription().getGrammarType(), grammars);
        }
        Vector modelStore = currModel.getInternalASModels();
        int i = 0;
        while (i < modelStore.size()) {
            this.initGrammarPool((ASModelImpl)modelStore.elementAt(i), grammarPool);
            ++i;
        }
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        super(new XMLGrammarCachingConfiguration(symbolTable, grammarPool));
    }
}

