/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.aggregator.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u0017\t9Q*\u001b8IK\u0006\u0004(BA\u0002\u0005\u0003\u0011\u0011\u0017m]3\u000b\u0005\u00151\u0011AC1hOJ,w-\u0019;pe*\u0011q\u0001C\u0001\bG\"\u0014xN\\8o\u0015\u0005I\u0011AA1j\u0007\u0001)\"\u0001\u0004\u0015\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0003\u0005\u0015\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u001di\u0017\r_*ju\u0016\u0004\"A\u0004\f\n\u0005]y!aA%oi\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0005pe\u0012,'/\u001b8h!\rY2E\n\b\u00039\u0005r!!\b\u0011\u000e\u0003yQ!a\b\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001\u0012\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001J\u0013\u0003\u0011=\u0013H-\u001a:j]\u001eT!AI\b\u0011\u0005\u001dBC\u0002\u0001\u0003\u0006S\u0001\u0011\rA\u000b\u0002\u0002)F\u00111F\f\t\u0003\u001d1J!!L\b\u0003\u000f9{G\u000f[5oOB\u0011abL\u0005\u0003a=\u00111!\u00118z\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0007U\u0002a%D\u0001\u0003\u0011\u0015!\u0012\u00071\u0001\u0016\u0011\u0015I\u0012\u00071\u0001\u001b\u0011\u001dI\u0004A1A\u0005\ni\n\u0011C]3wKJ\u001cXmQ8na\u0006\u0014\u0018\r^8s+\u0005Y\u0004c\u0001\u001f@M5\tQH\u0003\u0002?\u001f\u0005!Q.\u0019;i\u0013\t!S\b\u0003\u0004B\u0001\u0001\u0006IaO\u0001\u0013e\u00164XM]:f\u0007>l\u0007/\u0019:bi>\u0014\b%\u0002\u0003D\u0001\u0001!%!D\"p]R\f\u0017N\\3s)f\u0004X-\u0006\u0002F\u001dB\u0019aiS'\u000e\u0003\u001dS!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauIA\u0005BeJ\f\u0017\u0010T5tiB\u0011qE\u0014\u0003\u0006S\t\u0013\rA\u000b\u0005\u0006!\u0002!i!U\u0001\rg&4G\u000fR8x]J{w\u000e\u001e\u000b\u0003%V\u0003\"AD*\n\u0005Q{!\u0001B+oSRDQAV(A\u0002]\u000b1!\u0019:s!\rA&IJ\u0007\u0002\u0001!)!\f\u0001C\u00017\u00061\u0011N\\:feR$2a\u0016/^\u0011\u00151\u0016\f1\u0001X\u0011\u0015q\u0016\f1\u0001'\u0003\u0011)G.Z7\t\u000b\u0001\u0004A\u0011A1\u0002\u000b5,'oZ3\u0015\u0007]\u0013G\rC\u0003d?\u0002\u0007q+\u0001\u0003beJ\f\u0004\"B3`\u0001\u00049\u0016\u0001B1seJBQa\u001a\u0001\u0005\u0002!\fAa]8siR\u0011q+\u001b\u0005\u0006-\u001a\u0004\ra\u0016")
public class MinHeap<T> {
    private final int maxSize;
    private final Ordering<T> ordering;
    private final Ordering<T> reverseComparator;

    private Ordering<T> reverseComparator() {
        return this.reverseComparator;
    }

    private final void siftDownRoot(ArrayList<T> arr) {
        int par2 = 0;
        int left = (par2 << 1) + 1;
        while (par2 >= 0 && left < arr.size()) {
            T parentVal;
            T rightVal;
            int candidate = left;
            T candidateVal = arr.get(left);
            int right = left + 1;
            if (right < arr.size() && this.ordering.lt(candidateVal, rightVal = arr.get(right))) {
                candidate = right;
                candidateVal = rightVal;
            }
            if (this.ordering.gteq(parentVal = arr.get(par2), candidateVal)) {
                return;
            }
            arr.set(par2, candidateVal);
            arr.set(candidate, parentVal);
            par2 = candidate;
            left = (par2 << 1) + 1;
        }
    }

    public ArrayList<T> insert(ArrayList<T> arr, T elem) {
        Serializable serializable;
        if (arr.size() < this.maxSize - 1) {
            serializable = BoxesRunTime.boxToBoolean(arr.add(elem));
        } else {
            if (arr.size() == this.maxSize - 1) {
                arr.add(elem);
                arr.sort(this.reverseComparator());
            } else if (arr.size() == this.maxSize && this.ordering.lteq(elem, arr.get(0))) {
                arr.set(0, elem);
                this.siftDownRoot(arr);
            }
            serializable = BoxedUnit.UNIT;
        }
        return arr;
    }

    public ArrayList<T> merge(ArrayList<T> arr1, ArrayList<T> arr2) {
        Serializable serializable;
        if (arr1.size() + arr2.size() < this.maxSize) {
            serializable = BoxesRunTime.boxToBoolean(arr1.addAll(arr2));
        } else {
            Iterator<T> it = arr2.iterator();
            while (it.hasNext()) {
                this.insert(arr1, it.next());
            }
            serializable = BoxedUnit.UNIT;
        }
        return arr1;
    }

    public ArrayList<T> sort(ArrayList<T> arr) {
        arr.sort(this.ordering);
        return arr;
    }

    public MinHeap(int maxSize, Ordering<T> ordering) {
        this.maxSize = maxSize;
        this.ordering = ordering;
        this.reverseComparator = ordering.reverse();
    }
}

