/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.online;

import ai.chronon.online.ExternalSourceRegistry;
import ai.chronon.online.Fetcher;
import ai.chronon.online.FetcherResponseWithTs;
import ai.chronon.online.JavaMergedStatsResponse;
import ai.chronon.online.JavaRequest;
import ai.chronon.online.JavaResponse;
import ai.chronon.online.JavaSeriesStatsResponse;
import ai.chronon.online.JavaStatsRequest;
import ai.chronon.online.JavaStatsResponse;
import ai.chronon.online.KVStore;
import ai.chronon.online.LoggableResponse;
import ai.chronon.online.Metrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class JavaFetcher {
    Fetcher fetcher;

    public JavaFetcher(KVStore kVStore, String string2, Long l, Consumer<LoggableResponse> consumer, ExternalSourceRegistry externalSourceRegistry) {
        this.fetcher = new Fetcher(kVStore, string2, l, consumer, false, externalSourceRegistry);
    }

    public static List<JavaResponse> toJavaResponses(Seq<Fetcher.Response> seq2) {
        ArrayList<JavaResponse> arrayList = new ArrayList<JavaResponse>(seq2.size());
        Iterator iterator2 = seq2.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(new JavaResponse((Fetcher.Response)iterator2.next()));
        }
        return arrayList;
    }

    private CompletableFuture<List<JavaResponse>> convertResponsesWithTs(Future<FetcherResponseWithTs> future, boolean bl, long l) {
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(fetcherResponseWithTs -> {
            List<JavaResponse> list2 = JavaFetcher.toJavaResponses(fetcherResponseWithTs.responses());
            List<String> list3 = list2.stream().map(javaResponse -> javaResponse.request.name).collect(Collectors.toList());
            this.instrument(list3, bl, "java.response_conversion.latency.millis", fetcherResponseWithTs.endTs());
            this.instrument(list3, bl, "java.overall.latency.millis", l);
            return list2;
        });
    }

    public static List<JavaStatsResponse> toJavaStatsResponses(Seq<Fetcher.StatsResponse> seq2) {
        ArrayList<JavaStatsResponse> arrayList = new ArrayList<JavaStatsResponse>(seq2.size());
        Iterator iterator2 = seq2.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(new JavaStatsResponse((Fetcher.StatsResponse)iterator2.next()));
        }
        return arrayList;
    }

    public static JavaStatsResponse toJavaStatsResponse(Fetcher.StatsResponse statsResponse) {
        return new JavaStatsResponse(statsResponse);
    }

    public static JavaMergedStatsResponse toJavaMergedStatsResponse(Fetcher.MergedStatsResponse mergedStatsResponse) {
        return new JavaMergedStatsResponse(mergedStatsResponse);
    }

    public static JavaSeriesStatsResponse toJavaSeriesStatsResponse(Fetcher.SeriesStatsResponse seriesStatsResponse) {
        return new JavaSeriesStatsResponse(seriesStatsResponse);
    }

    private CompletableFuture<List<JavaStatsResponse>> convertStatsResponses(Future<Seq<Fetcher.StatsResponse>> future) {
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaStatsResponses);
    }

    private Seq<Fetcher.Request> convertJavaRequestList(List<JavaRequest> list2, boolean bl, long l) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        for (JavaRequest javaRequest2 : list2) {
            Fetcher.Request request = javaRequest2.toScalaRequest();
            arrayBuffer.$plus$eq(request);
        }
        GenSeq genSeq = arrayBuffer.toSeq();
        this.instrument(list2.stream().map(javaRequest -> javaRequest.name).collect(Collectors.toList()), bl, "java.request_conversion.latency.millis", l);
        return genSeq;
    }

    public CompletableFuture<List<JavaResponse>> fetchGroupBys(List<JavaRequest> list2) {
        long l = System.currentTimeMillis();
        Seq<Fetcher.Request> seq2 = this.convertJavaRequestList(list2, true, l);
        Future<FetcherResponseWithTs> future = this.fetcher.withTs(this.fetcher.fetchGroupBys(seq2));
        return this.convertResponsesWithTs(future, true, l);
    }

    public CompletableFuture<List<JavaResponse>> fetchJoin(List<JavaRequest> list2) {
        long l = System.currentTimeMillis();
        Seq<Fetcher.Request> seq2 = this.convertJavaRequestList(list2, false, l);
        Future<FetcherResponseWithTs> future = this.fetcher.withTs(this.fetcher.fetchJoin(seq2));
        return this.convertResponsesWithTs(future, false, l);
    }

    private void instrument(List<String> list2, boolean bl, String string2, Long l) {
        long l2 = System.currentTimeMillis();
        for (String string3 : list2) {
            Metrics.Context context = bl ? this.getGroupByContext(string3) : this.getJoinContext(string3);
            context.histogram(string2, l2 - l);
        }
    }

    private Metrics.Context getJoinContext(String string2) {
        return new Metrics.Context("join.fetch", string2, null, null, false, null, null, null, null);
    }

    private Metrics.Context getGroupByContext(String string2) {
        return new Metrics.Context("group_by.fetch", null, string2, null, false, null, null, null, null);
    }

    public CompletableFuture<List<JavaStatsResponse>> fetchStats(JavaStatsRequest javaStatsRequest) {
        Future<Seq<Fetcher.StatsResponse>> future = this.fetcher.fetchStats(javaStatsRequest.toScalaRequest());
        return this.convertStatsResponses(future);
    }

    public CompletableFuture<JavaMergedStatsResponse> fetchMergedStatsBetween(JavaStatsRequest javaStatsRequest) {
        Future<Fetcher.MergedStatsResponse> future = this.fetcher.fetchMergedStatsBetween(javaStatsRequest.toScalaRequest());
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaMergedStatsResponse);
    }

    public CompletableFuture<JavaSeriesStatsResponse> fetchStatsTimeseries(JavaStatsRequest javaStatsRequest) {
        Future<Fetcher.SeriesStatsResponse> future = this.fetcher.fetchStatsTimeseries(javaStatsRequest.toScalaRequest());
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaSeriesStatsResponse);
    }
}

