/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.spark.Extensions$;
import java.io.File;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LocalDataLoader$ {
    public static final LocalDataLoader$ MODULE$;

    static {
        new LocalDataLoader$();
    }

    public void writeTableFromFile(File file, String tableName, SparkSession session) {
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking table: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tableName})));
        if (session.catalog().tableExists(tableName)) {
            return;
        }
        String extension2 = (String)Predef$.MODULE$.refArrayOps((Object[])file.getName().split("\\.")).last();
        if (((SeqLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csv", "json", "jsonl"}))).contains(extension2)) {
            Dataset dataset;
            DataFrameReader reader = session.read().option("inferSchema", "true").option("mode", FailFastMode$.MODULE$.name());
            String string2 = extension2;
            String string3 = "csv";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                dataset = reader.option("header", true).csv(file.getPath());
            } else {
                String string4 = extension2;
                String string5 = "json";
                dataset = reader.option("multiLine", !(string4 != null ? !string4.equals(string5) : string5 != null)).option("allowComments", true).json(file.getPath());
            }
            Dataset df = dataset;
            StructType schema = df.schema();
            if (Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).contains("ts")) {
                DataType dataType = schema.apply(schema.fieldIndex("ts")).dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
                    df = df.withColumnRenamed("ts", "ts_string").withColumn("ts", functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("ts_string")).$times((Object)BoxesRunTime.boxToInteger(1000))).drop("ts_string");
                }
            }
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading data from ", " into ", ". Sample data and schema shown below"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file.getPath(), tableName})));
            df.show(100);
            Predef$.MODULE$.println(Extensions$.MODULE$.StructTypeOps(df.schema()).pretty());
            if (((SeqLike)df.schema().map((Function1)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$1) {
                    return x$1.name();
                }
            }), Seq$.MODULE$.canBuildFrom())).contains("ds")) {
                df.write().partitionBy(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ds"})).saveAsTable(tableName);
            } else {
                df.write().saveAsTable(tableName);
            }
            return;
        }
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load file due to invalid extension from file: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file.getPath()})));
    }

    public void loadDataRecursively(File fileOrDirectory, SparkSession session, Seq<String> namespaces) {
        Tuple2<Seq, String> tuple2;
        block4: {
            block3: {
                Tuple2<Seq, String> tuple22;
                String[] splits;
                Seq nsFields;
                block2: {
                    Predef$.MODULE$.assert(fileOrDirectory.exists(), (Function0<Object>)((Object)new Serializable(fileOrDirectory){
                        public static final long serialVersionUID = 0L;
                        private final File fileOrDirectory$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non existent file: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.fileOrDirectory$1.getPath()}));
                        }
                        {
                            this.fileOrDirectory$1 = fileOrDirectory$1;
                        }
                    }));
                    nsFields = namespaces.isEmpty() ? (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default"})) : namespaces;
                    splits = fileOrDirectory.getName().split("\\.");
                    if (!fileOrDirectory.isDirectory()) break block2;
                    Predef$.MODULE$.refArrayOps((Object[])fileOrDirectory.listFiles()).foreach(new Serializable(fileOrDirectory, session, namespaces){
                        public static final long serialVersionUID = 0L;
                        private final File fileOrDirectory$1;
                        private final SparkSession session$1;
                        private final Seq namespaces$1;

                        public final void apply(File x$2) {
                            LocalDataLoader$.MODULE$.loadDataRecursively(x$2, this.session$1, this.namespaces$1.$colon$plus(this.fileOrDirectory$1.getName(), Seq$.MODULE$.canBuildFrom()));
                        }
                        {
                            this.fileOrDirectory$1 = fileOrDirectory$1;
                            this.session$1 = session$1;
                            this.namespaces$1 = namespaces$1;
                        }
                    });
                    break block3;
                }
                Tuple2<Seq, String> tuple23 = tuple2 = Predef$.MODULE$.refArrayOps((Object[])splits).size() == 2 ? Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nsFields), splits[0]) : Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nsFields.$colon$plus(splits[0], Seq$.MODULE$.canBuildFrom())), splits[1]);
                if (tuple2 == null) break block4;
                Seq ns = tuple2._1();
                String table = tuple2._2();
                Tuple2<Seq, String> tuple24 = tuple22 = new Tuple2<Seq, String>(ns, table);
                Seq ns2 = tuple24._1();
                String table2 = tuple24._2();
                String namespace = ns2.mkString("_");
                this.loadDataFile(fileOrDirectory, session, namespace, table2);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public Seq<String> loadDataRecursively$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public void loadDataFileAsTable(File file, SparkSession session, String namespaceAndTable) {
        Tuple2<String, String> tuple2;
        String[] splits = namespaceAndTable.split("\\.");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])splits).nonEmpty() && Predef$.MODULE$.refArrayOps((Object[])splits).size() <= 2, (Function0<Object>)((Object)new Serializable(namespaceAndTable){
            public static final long serialVersionUID = 0L;
            private final String namespaceAndTable$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid table name ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.namespaceAndTable$1}));
            }
            {
                this.namespaceAndTable$1 = namespaceAndTable$1;
            }
        }));
        Tuple2<String, String> tuple22 = tuple2 = Predef$.MODULE$.refArrayOps((Object[])splits).size() == 1 ? Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("default"), splits[0]) : Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(splits[0]), splits[1]);
        if (tuple2 != null) {
            Tuple2<String, String> tuple23;
            String namespace = tuple2._1();
            String tableName = tuple2._2();
            Tuple2<String, String> tuple24 = tuple23 = new Tuple2<String, String>(namespace, tableName);
            String namespace2 = tuple24._1();
            String tableName2 = tuple24._2();
            this.loadDataFile(file, session, namespace2, tableName2);
            return;
        }
        throw new MatchError(tuple2);
    }

    private void loadDataFile(File file, SparkSession session, String namespace, String tableName) {
        Predef$.MODULE$.assert(file.exists(), (Function0<Object>)((Object)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non existent file: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.file$1.getPath()}));
            }
            {
                this.file$1 = file$1;
            }
        }));
        Predef$.MODULE$.assert(file.isFile(), (Function0<Object>)((Object)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot load a directory as a local table: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.file$1.getPath()}));
            }
            {
                this.file$1 = file$1;
            }
        }));
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading file(", ") as ", ".", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file.getPath(), namespace, tableName})));
        BoxedUnit boxedUnit = session.catalog().databaseExists(namespace) ? BoxedUnit.UNIT : session.sql(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE DATABASE ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{namespace})));
        this.writeTableFromFile(file, new StringBuilder().append((Object)namespace).append((Object)".").append((Object)tableName).toString(), session);
    }

    private LocalDataLoader$() {
        MODULE$ = this;
    }
}

